/*
 * Decompiled with CFR 0.152.
 */
package yakworks.rally.activity.repo;

import gorm.tools.async.AsyncService;
import gorm.tools.async.ParallelTools;
import gorm.tools.beans.Pager;
import gorm.tools.beans.map.MetaMapEntityService;
import gorm.tools.databinding.BindAction;
import gorm.tools.databinding.EntityMapBinder;
import gorm.tools.idgen.IdGenerator;
import gorm.tools.job.SyncJobArgs;
import gorm.tools.job.SyncJobContext;
import gorm.tools.job.SyncJobService;
import gorm.tools.mango.MangoDetachedCriteria;
import gorm.tools.mango.api.MangoQuery;
import gorm.tools.mango.api.QueryArgs;
import gorm.tools.mango.api.QueryMangoEntityApi;
import gorm.tools.model.Persistable;
import gorm.tools.model.SourceType;
import gorm.tools.problem.ProblemHandler;
import gorm.tools.repository.GormRepo;
import gorm.tools.repository.GormRepository;
import gorm.tools.repository.PersistArgs;
import gorm.tools.repository.bulk.BulkableRepo;
import gorm.tools.repository.events.AfterBindEvent;
import gorm.tools.repository.events.BeforeBindEvent;
import gorm.tools.repository.events.BeforePersistEvent;
import gorm.tools.repository.events.BeforeRemoveEvent;
import gorm.tools.repository.events.RepoEventPublisher;
import gorm.tools.repository.events.RepoListener;
import gorm.tools.repository.model.IdGeneratorRepo;
import gorm.tools.security.services.SecService;
import gorm.tools.utils.GormUtils;
import grails.artefact.Artefact;
import grails.core.support.proxy.ProxyHandler;
import grails.gorm.DetachedCriteria;
import grails.gorm.transactions.GrailsTransactionTemplate;
import grails.gorm.transactions.ReadOnly;
import grails.gorm.transactions.Transactional;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.IntRange;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.persistence.criteria.JoinType;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.trait.Traits;
import org.grails.datastore.gorm.GormEnhancer;
import org.grails.datastore.gorm.GormInstanceApi;
import org.grails.datastore.gorm.GormStaticApi;
import org.grails.datastore.gorm.GormValidationApi;
import org.grails.datastore.gorm.internal.RuntimeSupport;
import org.grails.datastore.gorm.query.criteria.AbstractDetachedCriteria;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.query.api.QueryableCriteria;
import org.grails.datastore.mapping.transactions.CustomizableRollbackTransactionAttribute;
import org.grails.datastore.mapping.transactions.TransactionCapableDatastore;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import yakworks.api.ApiResults;
import yakworks.api.Result;
import yakworks.commons.lang.Validate;
import yakworks.rally.activity.model.Activity;
import yakworks.rally.activity.model.ActivityContact;
import yakworks.rally.activity.model.ActivityLink;
import yakworks.rally.activity.model.ActivityNote;
import yakworks.rally.activity.model.Task;
import yakworks.rally.activity.model.TaskStatus;
import yakworks.rally.activity.model.TaskType;
import yakworks.rally.activity.repo.ActivityLinkRepo;
import yakworks.rally.attachment.model.Attachment;
import yakworks.rally.attachment.model.AttachmentLink;
import yakworks.rally.attachment.repo.AttachmentRepo;
import yakworks.rally.orgs.model.Org;
import yakworks.rally.tag.model.TagLink;

@GormRepository
@Artefact(value="Repository")
public class ActivityRepo
implements GormRepo<Activity>,
IdGeneratorRepo<Activity>,
IdGeneratorRepo.Trait.FieldHelper,
GormRepo.Trait.FieldHelper,
QueryMangoEntityApi.Trait.FieldHelper,
BulkableRepo.Trait.FieldHelper,
GroovyObject {
    @Inject
    @Nullable
    private ActivityLinkRepo activityLinkRepo;
    @Inject
    @Nullable
    private AttachmentRepo attachmentRepo;
    @Inject
    @Nullable
    private SecService secService;
    @Inject
    @Nullable
    private ProblemHandler problemHandler;
    private List<String> toOneAssociations;
    @Autowired(required=true)
    private RepoEventPublisher gorm_tools_repository_model_IdGeneratorRepo__repoEventPublisher;
    @Resource(shareable=true, lookup="", name="idGenerator", description="", type=Object.class, mappedName="")
    private IdGenerator gorm_tools_repository_model_IdGeneratorRepo__idGenerator;
    private String gorm_tools_repository_model_IdGeneratorRepo__idGeneratorKey;
    @Autowired(required=true)
    private ProxyHandler gorm_tools_repository_GormRepo__proxyHandler;
    private Class<Activity> gorm_tools_repository_GormRepo__entityClass;
    private Boolean gorm_tools_repository_GormRepo__enableEvents;
    @Autowired(required=true)
    private RepoEventPublisher gorm_tools_repository_GormRepo__repoEventPublisher;
    @Autowired(required=true)
    private EntityMapBinder gorm_tools_repository_GormRepo__entityMapBinder;
    @Autowired(required=true)
    @Qualifier(value="mangoQuery")
    private MangoQuery gorm_tools_mango_api_QueryMangoEntityApi__mangoQuery;
    private static final Logger gorm_tools_repository_bulk_BulkableRepo__log;
    @Autowired(required=true)
    private AsyncService gorm_tools_repository_bulk_BulkableRepo__asyncService;
    @Autowired(required=false)
    private SyncJobService gorm_tools_repository_bulk_BulkableRepo__syncJobService;
    @Autowired(required=true)
    private ProblemHandler gorm_tools_repository_bulk_BulkableRepo__problemHandler;
    @Autowired(required=true)
    @Qualifier(value="parallelTools")
    private ParallelTools gorm_tools_repository_bulk_BulkableRepo__parallelTools;
    @Autowired(required=true)
    private MetaMapEntityService gorm_tools_repository_bulk_BulkableRepo__metaMapEntityService;
    protected PlatformTransactionManager $transactionManager;
    protected Datastore $targetDatastore;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public ActivityRepo() {
        MetaClass metaClass;
        List list;
        this.toOneAssociations = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{"note", "task"});
        this.metaClass = metaClass = this.$getStaticMetaClass();
        IdGeneratorRepo.Trait.Helper.$init$((IdGeneratorRepo)this);
        GormRepo.Trait.Helper.$init$((GormRepo)this);
        QueryMangoEntityApi.Trait.Helper.$init$((QueryMangoEntityApi)this);
        BulkableRepo.Trait.Helper.$init$((BulkableRepo)this);
    }

    @RepoListener
    public void beforeValidate(Activity activity) {
        this.updateNameSummary(activity);
    }

    @RepoListener
    public void beforeBind(Activity activity, Map data, BeforeBindEvent e) {
        this.fixUpTaskParams(data);
        if (e.isBindUpdate() && DefaultTypeTransformation.booleanUnbox((Object)activity.getNote()) && DefaultTypeTransformation.booleanUnbox(data.get("name"))) {
            Object v = data.get("name");
            activity.getNote().setBody(ShortTypeHandling.castToString(v));
            activity.getNote().persist();
        }
    }

    @RepoListener
    public void afterBind(Activity activity, Map data, AfterBindEvent e) {
        this.assignOrg(activity, data);
    }

    @RepoListener
    public void beforeRemove(Activity activity, BeforeRemoveEvent e) {
        if (DefaultTypeTransformation.booleanUnbox((Object)activity.getNote())) {
            ActivityNote note = activity.getNote();
            Object var4_4 = null;
            activity.setNote((ActivityNote)ScriptBytecodeAdapter.castToType(var4_4, ActivityNote.class));
            activity.persist(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"flush", true}));
            note.delete();
        }
        TagLink.remove((Persistable)activity);
        AttachmentLink.getRepo().remove((Persistable)activity);
        ActivityLink.getRepo().remove(activity);
        ActivityContact.getRepo().remove((Persistable)activity);
    }

    @RepoListener
    public void beforePersist(Activity activity, BeforePersistEvent e) {
        if (DefaultTypeTransformation.booleanUnbox((Object)e.getData())) {
            Map data = e.getData();
            this.addRelatedDomainsToActivity(activity, data);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)activity.getTask())) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)activity.getTask().getStatus())) {
                TaskStatus taskStatus = TaskStatus.getOPEN();
                activity.getTask().setStatus(taskStatus);
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)activity.getTask().getTaskType())) {
                TaskType taskType = TaskType.getTODO();
                activity.getTask().setTaskType(taskType);
            }
        }
    }

    public void doAfterPersistWithData(Activity activity, PersistArgs args) {
        Map data = args.getData();
        if (DefaultTypeTransformation.booleanUnbox(data.get("attachments"))) {
            this.doAttachments(activity, data.get("attachments"));
        }
        if (DefaultTypeTransformation.booleanUnbox(data.get("contacts"))) {
            ActivityContact.addOrRemove(activity, data.get("contacts"));
        }
        if (DefaultTypeTransformation.booleanUnbox(data.get("tags"))) {
            TagLink.addOrRemoveTags((Persistable)activity, data.get("tags"));
        }
        if (DefaultTypeTransformation.booleanUnbox(data.get("arTranId"))) {
            this.activityLinkRepo.create((Long)ScriptBytecodeAdapter.asType(data.get("arTranId"), Long.class), "ArTran", (Persistable)activity);
        }
    }

    public MangoDetachedCriteria<Activity> query(QueryArgs queryArgs, @DelegatesTo(value=MangoDetachedCriteria.class) Closure closure) {
        Map criteriaMap = queryArgs.getCriteria();
        DetachedCriteria tagExistsCrit = null;
        if (DefaultTypeTransformation.booleanUnbox(criteriaMap.get("tags")) || DefaultTypeTransformation.booleanUnbox(criteriaMap.get("tagIds"))) {
            DetachedCriteria detachedCriteria;
            LinkedHashMap tagCriteriaMap = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"tags", criteriaMap.remove("tags"), "tagIds", criteriaMap.remove("tagIds")}), LinkedHashMap.class);
            tagExistsCrit = detachedCriteria = TagLink.getExistsCriteria(tagCriteriaMap, Activity.class, "activity_.id");
        }
        MangoDetachedCriteria detCrit = this.getMangoQuery().query(Activity.class, queryArgs, closure);
        if (tagExistsCrit != null) {
            detCrit.exists((QueryableCriteria)tagExistsCrit.id());
        }
        return detCrit;
    }

    public void assignOrg(Activity activity, Map data) {
        if (!DefaultTypeTransformation.booleanUnbox(data.get("orgId"))) {
            if (DefaultTypeTransformation.booleanUnbox(data.get("org")) && data.get("org") instanceof Map) {
                Org org = Org.getRepo().findWithData((Map)ScriptBytecodeAdapter.asType(data.get("org"), Map.class));
                activity.setOrg(org);
            } else if (DefaultTypeTransformation.booleanUnbox(data.get("org")) && data.get("org") instanceof Org) {
                Org org = (Org)ScriptBytecodeAdapter.castToType(data.get("org"), Org.class);
                activity.setOrg(org);
            }
        }
    }

    public void updateNameSummary(Activity activity) {
        String string = activity.getName();
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)(string != null ? Integer.valueOf(string.length()) : null), (Object)255)) {
            String string2 = StringUtils.abbreviate((String)activity.getName(), (int)255);
            activity.setName(string2);
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)activity.getKind()), (Object)((Object)Activity.Kind.Note)) && DefaultTypeTransformation.booleanUnbox((Object)activity.getNote())) {
            int endChar = activity.getNote().getBody().trim().length();
            String string3 = endChar > 255 ? StringGroovyMethods.plus((String)activity.getNote().getBody().trim().substring(0, 251), (CharSequence)" ...") : activity.getNote().getBody().trim();
            activity.setName(string3);
        }
    }

    public void addRelatedDomainsToActivity(Activity activity, Map data) {
        String string;
        String string2;
        Map task = (Map)ScriptBytecodeAdapter.asType(data.get("task"), Map.class);
        if (!DefaultTypeTransformation.booleanUnbox(data.get("kind")) && DefaultTypeTransformation.booleanUnbox(task == null ? null : task.get("dueDate"))) {
            Activity.Kind kind = Activity.Kind.Todo;
            activity.setKind(kind);
        }
        String name = (string2 = (String)ScriptBytecodeAdapter.asType(data.get("name"), String.class)) != null ? string2.trim() : null;
        if (!DefaultTypeTransformation.booleanUnbox((Object)activity.getNote()) && ScriptBytecodeAdapter.compareGreaterThan((Object)((string = name) != null ? Integer.valueOf(string.length()) : null), (Object)255)) {
            this.addNote(activity, name);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)activity.getNote()) && !DefaultTypeTransformation.booleanUnbox((Object)activity.getNote().getBody()) && DefaultTypeTransformation.booleanUnbox(data.get("name"))) {
            Object v = data.get("name");
            activity.getNote().setBody(ShortTypeHandling.castToString(v));
        }
    }

    public void doAttachments(Activity activity, Object attData) {
        Reference activity2 = new Reference((Object)activity);
        List<Attachment> attachments = this.attachmentRepo.createOrUpdate((List)ScriptBytecodeAdapter.asType((Object)attData, List.class));
        public final class _doAttachments_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference activity;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _doAttachments_closure1(Object _outerInstance, Object _thisObject, Reference activity) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.activity = reference = activity;
            }

            public Object doCall(Attachment attachment) {
                return AttachmentLink.create((Persistable)ScriptBytecodeAdapter.castToType((Object)this.activity.get(), Persistable.class), attachment);
            }

            public Object call(Attachment attachment) {
                return this.doCall(attachment);
            }

            @Generated
            public Activity getActivity() {
                return (Activity)ScriptBytecodeAdapter.castToType((Object)this.activity.get(), Activity.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _doAttachments_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(attachments, (Closure)new _doAttachments_closure1(this, this, activity2));
        ((Activity)activity2.get()).setHasAttachments(true);
    }

    public ActivityNote addNote(Activity act, String body, String contentType) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)act.getNote())) {
            ActivityNote activityNote = new ActivityNote();
            act.setNote(activityNote);
        }
        String string = body;
        act.getNote().setBody(string);
        String string2 = contentType;
        act.getNote().setContentType(string2);
        return act.getNote();
    }

    public void completeTask(Task task, Long completedById) {
        Validate.notNull((Object)completedById, (String)"[completedById]");
        task.bind(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"status", TaskStatus.getCOMPLETE(), "state", (Integer)ScriptBytecodeAdapter.asType((Object)TaskStatus.getCOMPLETE().getId(), Integer.class), "completedDate", LocalDateTime.now(), "completedBy", completedById}));
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public Activity insertMassNote(List targets, String entityName, Org org, String body) {
        void var3_3;
        void var2_2;
        Reference targets2 = new Reference((Object)targets);
        Reference entityName2 = new Reference((Object)var2_2);
        Reference org2 = new Reference((Object)var3_3);
        Reference body2 = new Reference((Object)body);
        CustomizableRollbackTransactionAttribute $transactionAttribute = new CustomizableRollbackTransactionAttribute();
        String string = "yakworks.rally.activity.repo.ActivityRepo.insertMassNote";
        $transactionAttribute.setName(string);
        GrailsTransactionTemplate $transactionTemplate = new GrailsTransactionTemplate(this.getTransactionManager(), $transactionAttribute);
        public final class _insertMassNote_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference targets;
            private /* synthetic */ Reference entityName;
            private /* synthetic */ Reference org;
            private /* synthetic */ Reference body;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _insertMassNote_closure2(Object _outerInstance, Object _thisObject, Reference targets, Reference entityName, Reference org, Reference body) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.targets = reference4 = targets;
                this.entityName = reference3 = entityName;
                this.org = reference2 = org;
                this.body = reference = body;
            }

            public Object doCall(TransactionStatus transactionStatus) {
                return InvokerHelper.invokeMethodSafe((Object)((ActivityRepo)this.getThisObject()), (String)"$tt__insertMassNote", (Object)new Object[]{this.targets.get(), this.entityName.get(), this.org.get(), this.body.get(), transactionStatus});
            }

            public Object call(TransactionStatus transactionStatus) {
                return this.doCall(transactionStatus);
            }

            @Generated
            public List getTargets() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.targets.get(), List.class);
            }

            @Generated
            public String getEntityName() {
                return ShortTypeHandling.castToString((Object)this.entityName.get());
            }

            @Generated
            public Org getOrg() {
                return (Org)ScriptBytecodeAdapter.castToType((Object)this.org.get(), Org.class);
            }

            @Generated
            public String getBody() {
                return ShortTypeHandling.castToString((Object)this.body.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _insertMassNote_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (Activity)$transactionTemplate.execute((Closure)new _insertMassNote_closure2(this, this, targets2, entityName2, org2, body2));
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public List<Activity> insertMassActivity(List targets, Map activityData, String source, boolean newAttachments) {
        void var3_3;
        void var2_2;
        Reference targets2 = new Reference((Object)targets);
        Reference activityData2 = new Reference((Object)var2_2);
        Reference source2 = new Reference((Object)var3_3);
        Reference newAttachments2 = new Reference((Object)newAttachments);
        CustomizableRollbackTransactionAttribute $transactionAttribute = new CustomizableRollbackTransactionAttribute();
        String string = "yakworks.rally.activity.repo.ActivityRepo.insertMassActivity";
        $transactionAttribute.setName(string);
        GrailsTransactionTemplate $transactionTemplate = new GrailsTransactionTemplate(this.getTransactionManager(), $transactionAttribute);
        public final class _insertMassActivity_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference targets;
            private /* synthetic */ Reference activityData;
            private /* synthetic */ Reference source;
            private /* synthetic */ Reference newAttachments;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _insertMassActivity_closure3(Object _outerInstance, Object _thisObject, Reference targets, Reference activityData, Reference source, Reference newAttachments) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.targets = reference4 = targets;
                this.activityData = reference3 = activityData;
                this.source = reference2 = source;
                this.newAttachments = reference = newAttachments;
            }

            public Object doCall(TransactionStatus transactionStatus) {
                return InvokerHelper.invokeMethodSafe((Object)((ActivityRepo)this.getThisObject()), (String)"$tt__insertMassActivity", (Object)new Object[]{this.targets.get(), this.activityData.get(), this.source.get(), this.newAttachments.get(), transactionStatus});
            }

            public Object call(TransactionStatus transactionStatus) {
                return this.doCall(transactionStatus);
            }

            @Generated
            public List getTargets() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.targets.get(), List.class);
            }

            @Generated
            public Map getActivityData() {
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.activityData.get(), Map.class);
            }

            @Generated
            public String getSource() {
                return ShortTypeHandling.castToString((Object)this.source.get());
            }

            @Generated
            public boolean getNewAttachments() {
                return DefaultTypeTransformation.booleanUnbox((Object)this.newAttachments.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _insertMassActivity_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (List)$transactionTemplate.execute((Closure)new _insertMassActivity_closure3(this, this, targets2, activityData2, source2, newAttachments2));
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public Activity createActivity(String text, Org org, Map task, List<Attachment> attachments, String entityName, String source) {
        void var3_3;
        void var2_2;
        Reference text2 = new Reference((Object)text);
        Reference org2 = new Reference((Object)var2_2);
        Reference task2 = new Reference((Object)var3_3);
        Reference attachments2 = new Reference(attachments);
        Reference entityName2 = new Reference((Object)entityName);
        Reference source2 = new Reference((Object)source);
        CustomizableRollbackTransactionAttribute $transactionAttribute = new CustomizableRollbackTransactionAttribute();
        String string = "yakworks.rally.activity.repo.ActivityRepo.createActivity";
        $transactionAttribute.setName(string);
        GrailsTransactionTemplate $transactionTemplate = new GrailsTransactionTemplate(this.getTransactionManager(), $transactionAttribute);
        public final class _createActivity_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference text;
            private /* synthetic */ Reference org;
            private /* synthetic */ Reference task;
            private /* synthetic */ Reference attachments;
            private /* synthetic */ Reference entityName;
            private /* synthetic */ Reference source;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _createActivity_closure4(Object _outerInstance, Object _thisObject, Reference text, Reference org, Reference task, Reference attachments, Reference entityName, Reference source) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                Reference reference6;
                this.text = reference6 = text;
                this.org = reference5 = org;
                this.task = reference4 = task;
                this.attachments = reference3 = attachments;
                this.entityName = reference2 = entityName;
                this.source = reference = source;
            }

            public Object doCall(TransactionStatus transactionStatus) {
                return InvokerHelper.invokeMethodSafe((Object)((ActivityRepo)this.getThisObject()), (String)"$tt__createActivity", (Object)new Object[]{this.text.get(), this.org.get(), this.task.get(), this.attachments.get(), this.entityName.get(), this.source.get(), transactionStatus});
            }

            public Object call(TransactionStatus transactionStatus) {
                return this.doCall(transactionStatus);
            }

            @Generated
            public String getText() {
                return ShortTypeHandling.castToString((Object)this.text.get());
            }

            @Generated
            public Org getOrg() {
                return (Org)ScriptBytecodeAdapter.castToType((Object)this.org.get(), Org.class);
            }

            @Generated
            public Map getTask() {
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.task.get(), Map.class);
            }

            @Generated
            public List getAttachments() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.attachments.get(), List.class);
            }

            @Generated
            public String getEntityName() {
                return ShortTypeHandling.castToString((Object)this.entityName.get());
            }

            @Generated
            public String getSource() {
                return ShortTypeHandling.castToString((Object)this.source.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createActivity_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (Activity)$transactionTemplate.execute((Closure)new _createActivity_closure4(this, this, text2, org2, task2, attachments2, entityName2, source2));
    }

    @Transactional
    public Task createActivityTask(Map taskData) {
        Reference taskData2 = new Reference((Object)taskData);
        CustomizableRollbackTransactionAttribute $transactionAttribute = new CustomizableRollbackTransactionAttribute();
        String string = "yakworks.rally.activity.repo.ActivityRepo.createActivityTask";
        $transactionAttribute.setName(string);
        GrailsTransactionTemplate $transactionTemplate = new GrailsTransactionTemplate(this.getTransactionManager(), $transactionAttribute);
        public final class _createActivityTask_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference taskData;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _createActivityTask_closure5(Object _outerInstance, Object _thisObject, Reference taskData) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.taskData = reference = taskData;
            }

            public Object doCall(TransactionStatus transactionStatus) {
                return InvokerHelper.invokeMethodSafe((Object)((ActivityRepo)this.getThisObject()), (String)"$tt__createActivityTask", (Object)new Object[]{this.taskData.get(), transactionStatus});
            }

            public Object call(TransactionStatus transactionStatus) {
                return this.doCall(transactionStatus);
            }

            @Generated
            public Map getTaskData() {
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.taskData.get(), Map.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createActivityTask_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (Task)$transactionTemplate.execute((Closure)new _createActivityTask_closure5(this, this, taskData2));
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public Activity createTodo(Org org, Long userId, String name, String linkedEntity, List<Long> linkedIds, LocalDateTime dueDate) {
        void var3_3;
        void var2_2;
        Reference org2 = new Reference((Object)org);
        Reference userId2 = new Reference((Object)var2_2);
        Reference name2 = new Reference((Object)var3_3);
        Reference linkedEntity2 = new Reference((Object)linkedEntity);
        Reference linkedIds2 = new Reference(linkedIds);
        Reference dueDate2 = new Reference((Object)dueDate);
        CustomizableRollbackTransactionAttribute $transactionAttribute = new CustomizableRollbackTransactionAttribute();
        String string = "yakworks.rally.activity.repo.ActivityRepo.createTodo";
        $transactionAttribute.setName(string);
        GrailsTransactionTemplate $transactionTemplate = new GrailsTransactionTemplate(this.getTransactionManager(), $transactionAttribute);
        public final class _createTodo_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference org;
            private /* synthetic */ Reference userId;
            private /* synthetic */ Reference name;
            private /* synthetic */ Reference linkedEntity;
            private /* synthetic */ Reference linkedIds;
            private /* synthetic */ Reference dueDate;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _createTodo_closure6(Object _outerInstance, Object _thisObject, Reference org, Reference userId, Reference name, Reference linkedEntity, Reference linkedIds, Reference dueDate) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                Reference reference6;
                this.org = reference6 = org;
                this.userId = reference5 = userId;
                this.name = reference4 = name;
                this.linkedEntity = reference3 = linkedEntity;
                this.linkedIds = reference2 = linkedIds;
                this.dueDate = reference = dueDate;
            }

            public Object doCall(TransactionStatus transactionStatus) {
                return InvokerHelper.invokeMethodSafe((Object)((ActivityRepo)this.getThisObject()), (String)"$tt__createTodo", (Object)new Object[]{this.org.get(), this.userId.get(), this.name.get(), this.linkedEntity.get(), this.linkedIds.get(), this.dueDate.get(), transactionStatus});
            }

            public Object call(TransactionStatus transactionStatus) {
                return this.doCall(transactionStatus);
            }

            @Generated
            public Org getOrg() {
                return (Org)ScriptBytecodeAdapter.castToType((Object)this.org.get(), Org.class);
            }

            @Generated
            public Long getUserId() {
                return (Long)ScriptBytecodeAdapter.castToType((Object)this.userId.get(), Long.class);
            }

            @Generated
            public String getName() {
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            @Generated
            public String getLinkedEntity() {
                return ShortTypeHandling.castToString((Object)this.linkedEntity.get());
            }

            @Generated
            public List getLinkedIds() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.linkedIds.get(), List.class);
            }

            @Generated
            public LocalDateTime getDueDate() {
                return (LocalDateTime)ScriptBytecodeAdapter.castToType((Object)this.dueDate.get(), LocalDateTime.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createTodo_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (Activity)$transactionTemplate.execute((Closure)new _createTodo_closure6(this, this, org2, userId2, name2, linkedEntity2, linkedIds2, dueDate2));
    }

    public void fixUpTaskParams(Map params) {
        Map taskParams = (Map)ScriptBytecodeAdapter.asType(params.get("task"), Map.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)taskParams) || taskParams.get("dueDate") == null) {
            params.remove("task");
        }
    }

    /*
     * WARNING - void declaration
     */
    public DetachedCriteria<Activity> linkedActivityCriteria(Persistable linkedEntity, Activity.Kind kind) {
        void var2_2;
        Reference linkedEntity2 = new Reference((Object)linkedEntity);
        Reference kind2 = new Reference((Object)var2_2);
        public final class _linkedActivityCriteria_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference linkedEntity;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _linkedActivityCriteria_closure7(Object _outerInstance, Object _thisObject, Reference linkedEntity) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.linkedEntity = reference = linkedEntity;
            }

            public Object doCall(Object it) {
                ((AbstractDetachedCriteria)this.getDelegate()).setAlias("actLink");
                ((MangoDetachedCriteria)this.getDelegate()).eqProperty("activity.id", "act.id");
                ((MangoDetachedCriteria)this.getDelegate()).eq("linkedId", (Object)((Persistable)this.linkedEntity.get()).getId());
                return ((MangoDetachedCriteria)this.getDelegate()).eq("linkedEntity", (Object)this.linkedEntity.get().getClass().getSimpleName());
            }

            @Generated
            public Persistable getLinkedEntity() {
                return (Persistable)ScriptBytecodeAdapter.castToType((Object)this.linkedEntity.get(), Persistable.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _linkedActivityCriteria_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Reference actLinkExists = new Reference(ActivityLink.query(new _linkedActivityCriteria_closure7(this, this, linkedEntity2)));
        public final class _linkedActivityCriteria_closure8
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference kind;
            private /* synthetic */ Reference actLinkExists;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _linkedActivityCriteria_closure8(Object _outerInstance, Object _thisObject, Reference kind, Reference actLinkExists) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.kind = reference2 = kind;
                this.actLinkExists = reference = actLinkExists;
            }

            public Object doCall(Object it) {
                ((AbstractDetachedCriteria)this.getDelegate()).setAlias("act");
                if (this.kind.get() != null) {
                    ((MangoDetachedCriteria)this.getDelegate()).eq("kind", this.kind.get());
                }
                return ((DetachedCriteria)this.getDelegate()).exists((QueryableCriteria)((MangoDetachedCriteria)this.actLinkExists.get()).id());
            }

            @Generated
            public Activity.Kind getKind() {
                return (Activity.Kind)ShortTypeHandling.castToEnum((Object)this.kind.get(), Activity.Kind.class);
            }

            @Generated
            public Object getActLinkExists() {
                return this.actLinkExists.get();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _linkedActivityCriteria_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return Activity.query(new _linkedActivityCriteria_closure8(this, this, kind2, actLinkExists));
    }

    @ReadOnly
    public boolean hasActivityWithAttachments(Persistable entity) {
        Reference entity2 = new Reference((Object)entity);
        CustomizableRollbackTransactionAttribute $transactionAttribute = new CustomizableRollbackTransactionAttribute();
        Boolean bl = Boolean.TRUE;
        $transactionAttribute.setReadOnly(DefaultTypeTransformation.booleanUnbox((Object)bl));
        String string = "yakworks.rally.activity.repo.ActivityRepo.hasActivityWithAttachments";
        $transactionAttribute.setName(string);
        GrailsTransactionTemplate $transactionTemplate = new GrailsTransactionTemplate(this.getTransactionManager(), $transactionAttribute);
        public final class _hasActivityWithAttachments_closure9
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference entity;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _hasActivityWithAttachments_closure9(Object _outerInstance, Object _thisObject, Reference entity) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.entity = reference = entity;
            }

            public Object doCall(TransactionStatus transactionStatus) {
                return InvokerHelper.invokeMethodSafe((Object)((ActivityRepo)this.getThisObject()), (String)"$tt__hasActivityWithAttachments", (Object)new Object[]{this.entity.get(), transactionStatus});
            }

            public Object call(TransactionStatus transactionStatus) {
                return this.doCall(transactionStatus);
            }

            @Generated
            public Persistable getEntity() {
                return (Persistable)ScriptBytecodeAdapter.castToType((Object)this.entity.get(), Persistable.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _hasActivityWithAttachments_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultTypeTransformation.booleanUnbox((Object)$transactionTemplate.execute((Closure)new _hasActivityWithAttachments_closure9(this, this, entity2)));
    }

    /*
     * WARNING - void declaration
     */
    @ReadOnly
    public List<Activity> listByLinked(Long linkedId, String linkedEntity, Map params) {
        void var3_3;
        void var2_2;
        Reference linkedId2 = new Reference((Object)linkedId);
        Reference linkedEntity2 = new Reference((Object)var2_2);
        Reference params2 = new Reference((Object)var3_3);
        CustomizableRollbackTransactionAttribute $transactionAttribute = new CustomizableRollbackTransactionAttribute();
        Boolean bl = Boolean.TRUE;
        $transactionAttribute.setReadOnly(DefaultTypeTransformation.booleanUnbox((Object)bl));
        String string = "yakworks.rally.activity.repo.ActivityRepo.listByLinked";
        $transactionAttribute.setName(string);
        GrailsTransactionTemplate $transactionTemplate = new GrailsTransactionTemplate(this.getTransactionManager(), $transactionAttribute);
        public final class _listByLinked_closure10
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference linkedId;
            private /* synthetic */ Reference linkedEntity;
            private /* synthetic */ Reference params;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _listByLinked_closure10(Object _outerInstance, Object _thisObject, Reference linkedId, Reference linkedEntity, Reference params) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.linkedId = reference3 = linkedId;
                this.linkedEntity = reference2 = linkedEntity;
                this.params = reference = params;
            }

            public Object doCall(TransactionStatus transactionStatus) {
                return InvokerHelper.invokeMethodSafe((Object)((ActivityRepo)this.getThisObject()), (String)"$tt__listByLinked", (Object)new Object[]{this.linkedId.get(), this.linkedEntity.get(), this.params.get(), transactionStatus});
            }

            public Object call(TransactionStatus transactionStatus) {
                return this.doCall(transactionStatus);
            }

            @Generated
            public Long getLinkedId() {
                return (Long)ScriptBytecodeAdapter.castToType((Object)this.linkedId.get(), Long.class);
            }

            @Generated
            public String getLinkedEntity() {
                return ShortTypeHandling.castToString((Object)this.linkedEntity.get());
            }

            @Generated
            public Map getParams() {
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.params.get(), Map.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _listByLinked_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (List)$transactionTemplate.execute((Closure)new _listByLinked_closure10(this, this, linkedId2, linkedEntity2, params2));
    }

    /*
     * WARNING - void declaration
     */
    public DetachedCriteria<Activity> getActivityByLinkedCriteria(Long linkedId, String linkedEntity, boolean custArea) {
        void var2_2;
        Reference linkedId2 = new Reference((Object)linkedId);
        Reference linkedEntity2 = new Reference((Object)var2_2);
        Reference custArea2 = new Reference((Object)custArea);
        public final class _getActivityByLinkedCriteria_closure11
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference linkedId;
            private /* synthetic */ Reference linkedEntity;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getActivityByLinkedCriteria_closure11(Object _outerInstance, Object _thisObject, Reference linkedId, Reference linkedEntity) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.linkedId = reference2 = linkedId;
                this.linkedEntity = reference = linkedEntity;
            }

            public Object doCall(Object it) {
                ((AbstractDetachedCriteria)this.getDelegate()).setAlias("actLink");
                ((MangoDetachedCriteria)this.getDelegate()).eqProperty("activity.id", "act.id");
                ((MangoDetachedCriteria)this.getDelegate()).eq("linkedId", this.linkedId.get());
                return ((MangoDetachedCriteria)this.getDelegate()).eq("linkedEntity", this.linkedEntity.get());
            }

            @Generated
            public Long getLinkedId() {
                return (Long)ScriptBytecodeAdapter.castToType((Object)this.linkedId.get(), Long.class);
            }

            @Generated
            public String getLinkedEntity() {
                return ShortTypeHandling.castToString((Object)this.linkedEntity.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getActivityByLinkedCriteria_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Reference actLinkExists = new Reference(ActivityLink.query(new _getActivityByLinkedCriteria_closure11(this, this, linkedId2, linkedEntity2)));
        public final class _getActivityByLinkedCriteria_closure12
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference actLinkExists;
            private /* synthetic */ Reference custArea;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getActivityByLinkedCriteria_closure12(Object _outerInstance, Object _thisObject, Reference actLinkExists, Reference custArea) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.actLinkExists = reference2 = actLinkExists;
                this.custArea = reference = custArea;
            }

            public Object doCall(Object it) {
                ((AbstractDetachedCriteria)this.getDelegate()).setAlias("act");
                ((AbstractDetachedCriteria)this.getDelegate()).createAlias("task", "task");
                ((DetachedCriteria)this.getDelegate()).join("task", JoinType.LEFT);
                ((DetachedCriteria)this.getDelegate()).exists((QueryableCriteria)((MangoDetachedCriteria)this.actLinkExists.get()).id());
                public final class _closure22
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure22(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        ((MangoDetachedCriteria)((Closure)this.getOwner()).getDelegate()).isNull("task");
                        return ((MangoDetachedCriteria)((Closure)this.getOwner()).getDelegate()).le("task.state", (Object)1);
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure22.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                ((DetachedCriteria)this.getDelegate()).or((Closure)new _closure22((Object)this, this.getThisObject()));
                public final class _closure23
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference custArea;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure23(Object _outerInstance, Object _thisObject, Reference custArea) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.custArea = reference = custArea;
                    }

                    public Object doCall(Object it) {
                        ((MangoDetachedCriteria)((Closure)this.getOwner()).getDelegate()).eq("visibleTo", (Object)Activity.VisibleTo.Everyone);
                        if (!DefaultTypeTransformation.booleanUnbox((Object)this.custArea.get())) {
                            ((MangoDetachedCriteria)((Closure)this.getOwner()).getDelegate()).ne("visibleTo", (Object)Activity.VisibleTo.Owner);
                            public final class _closure24
                            extends Closure
                            implements GeneratedClosure {
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;

                                public _closure24(Object _outerInstance, Object _thisObject) {
                                    super(_outerInstance, _thisObject);
                                }

                                public Object doCall(Object it) {
                                    ((MangoDetachedCriteria)((Closure)((Closure)this.getOwner()).getOwner()).getDelegate()).eq("visibleTo", (Object)Activity.VisibleTo.Owner);
                                    return ((MangoDetachedCriteria)((Closure)((Closure)this.getOwner()).getOwner()).getDelegate()).eq("createdBy", (Object)((ActivityRepo)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ActivityRepo.class)).getSecService().getUserId());
                                }

                                public Object call(Object args) {
                                    return this.doCall(args);
                                }

                                public Object call() {
                                    return this.doCall(null);
                                }

                                @Generated
                                public Object doCall() {
                                    return this.doCall(null);
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _closure24.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }
                            }
                            return ((DetachedCriteria)((Closure)this.getOwner()).getDelegate()).and((Closure)new _closure24((Object)this, this.getThisObject()));
                        }
                        return null;
                    }

                    @Generated
                    public boolean getCustArea() {
                        return DefaultTypeTransformation.booleanUnbox((Object)this.custArea.get());
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure23.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                return ((DetachedCriteria)this.getDelegate()).or((Closure)new _closure23((Object)this, this.getThisObject(), this.custArea));
            }

            @Generated
            public Object getActLinkExists() {
                return this.actLinkExists.get();
            }

            @Generated
            public boolean getCustArea() {
                return DefaultTypeTransformation.booleanUnbox((Object)this.custArea.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getActivityByLinkedCriteria_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return Activity.query(new _getActivityByLinkedCriteria_closure12(this, this, actLinkExists, custArea2));
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public Activity copy(Activity fromAct, Activity toAct) {
        void var2_2;
        Reference fromAct2 = new Reference((Object)fromAct);
        Reference toAct2 = new Reference((Object)var2_2);
        CustomizableRollbackTransactionAttribute $transactionAttribute = new CustomizableRollbackTransactionAttribute();
        String string = "yakworks.rally.activity.repo.ActivityRepo.copy";
        $transactionAttribute.setName(string);
        GrailsTransactionTemplate $transactionTemplate = new GrailsTransactionTemplate(this.getTransactionManager(), $transactionAttribute);
        public final class _copy_closure13
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference fromAct;
            private /* synthetic */ Reference toAct;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _copy_closure13(Object _outerInstance, Object _thisObject, Reference fromAct, Reference toAct) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.fromAct = reference2 = fromAct;
                this.toAct = reference = toAct;
            }

            public Object doCall(TransactionStatus transactionStatus) {
                return InvokerHelper.invokeMethodSafe((Object)((ActivityRepo)this.getThisObject()), (String)"$tt__copy", (Object)new Object[]{this.fromAct.get(), this.toAct.get(), transactionStatus});
            }

            public Object call(TransactionStatus transactionStatus) {
                return this.doCall(transactionStatus);
            }

            @Generated
            public Activity getFromAct() {
                return (Activity)ScriptBytecodeAdapter.castToType((Object)this.fromAct.get(), Activity.class);
            }

            @Generated
            public Activity getToAct() {
                return (Activity)ScriptBytecodeAdapter.castToType((Object)this.toAct.get(), Activity.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _copy_closure13.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (Activity)$transactionTemplate.execute((Closure)new _copy_closure13(this, this, fromAct2, toAct2));
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public Result copyToOrg(Org fromOrg, Org toOrg) {
        void var2_2;
        Reference fromOrg2 = new Reference((Object)fromOrg);
        Reference toOrg2 = new Reference((Object)var2_2);
        CustomizableRollbackTransactionAttribute $transactionAttribute = new CustomizableRollbackTransactionAttribute();
        String string = "yakworks.rally.activity.repo.ActivityRepo.copyToOrg";
        $transactionAttribute.setName(string);
        GrailsTransactionTemplate $transactionTemplate = new GrailsTransactionTemplate(this.getTransactionManager(), $transactionAttribute);
        public final class _copyToOrg_closure14
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference fromOrg;
            private /* synthetic */ Reference toOrg;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _copyToOrg_closure14(Object _outerInstance, Object _thisObject, Reference fromOrg, Reference toOrg) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.fromOrg = reference2 = fromOrg;
                this.toOrg = reference = toOrg;
            }

            public Object doCall(TransactionStatus transactionStatus) {
                return InvokerHelper.invokeMethodSafe((Object)((ActivityRepo)this.getThisObject()), (String)"$tt__copyToOrg", (Object)new Object[]{this.fromOrg.get(), this.toOrg.get(), transactionStatus});
            }

            public Object call(TransactionStatus transactionStatus) {
                return this.doCall(transactionStatus);
            }

            @Generated
            public Org getFromOrg() {
                return (Org)ScriptBytecodeAdapter.castToType((Object)this.fromOrg.get(), Org.class);
            }

            @Generated
            public Org getToOrg() {
                return (Org)ScriptBytecodeAdapter.castToType((Object)this.toOrg.get(), Org.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _copyToOrg_closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (Result)$transactionTemplate.execute((Closure)new _copyToOrg_closure14(this, this, fromOrg2, toOrg2));
    }

    @Traits.TraitBridge(traitClass=IdGeneratorRepo.class, desc="()Ljava/lang/String;")
    public String getIdGeneratorKey() {
        return IdGeneratorRepo.Trait.Helper.getIdGeneratorKey((IdGeneratorRepo)this);
    }

    public /* synthetic */ String gorm_tools_repository_model_IdGeneratorRepotrait$super$getIdGeneratorKey() {
        if (this instanceof GeneratedGroovyProxy) {
            return ShortTypeHandling.castToString((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getIdGeneratorKey", (Object)new Object[0]));
        }
        return ShortTypeHandling.castToString((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getIdGeneratorKey"));
    }

    @Traits.TraitBridge(traitClass=IdGeneratorRepo.class, desc="(Lgorm/tools/repository/events/RepoEventPublisher;)V")
    public void setRepoEventPublisher(RepoEventPublisher param1) {
        IdGeneratorRepo.Trait.Helper.setRepoEventPublisher((IdGeneratorRepo)this, (RepoEventPublisher)param1);
    }

    public /* synthetic */ void gorm_tools_repository_model_IdGeneratorRepotrait$super$setRepoEventPublisher(RepoEventPublisher param0) {
        GormRepo.Trait.Helper.setRepoEventPublisher((GormRepo)this, (RepoEventPublisher)param0);
    }

    public /* synthetic */ void gorm_tools_repository_GormRepotrait$super$setRepoEventPublisher(RepoEventPublisher param0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setRepoEventPublisher", (Object)new Object[]{param0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"setRepoEventPublisher", (Object[])new Object[]{param0});
        }
    }

    @Traits.TraitBridge(traitClass=IdGeneratorRepo.class, desc="(Lgorm/tools/idgen/IdGenerator;)V")
    public void setIdGenerator(IdGenerator param1) {
        IdGeneratorRepo.Trait.Helper.setIdGenerator((IdGeneratorRepo)this, (IdGenerator)param1);
    }

    public /* synthetic */ void gorm_tools_repository_model_IdGeneratorRepotrait$super$setIdGenerator(IdGenerator param0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setIdGenerator", (Object)new Object[]{param0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"setIdGenerator", (Object[])new Object[]{param0});
        }
    }

    @Traits.TraitBridge(traitClass=IdGeneratorRepo.class, desc="(Lgorm/tools/model/Persistable;)Ljava/lang/Long;")
    public Long generateId(Persistable param1) {
        return IdGeneratorRepo.Trait.Helper.generateId((IdGeneratorRepo)this, (Persistable)param1);
    }

    public /* synthetic */ Long gorm_tools_repository_model_IdGeneratorRepotrait$super$generateId(Persistable param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Long)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"generateId", (Object)new Object[]{param0}), Long.class);
        }
        return (Long)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"generateId", (Object[])new Object[]{param0}), Long.class);
    }

    @Traits.TraitBridge(traitClass=IdGeneratorRepo.class, desc="()Lgorm/tools/idgen/IdGenerator;")
    public IdGenerator getIdGenerator() {
        return IdGeneratorRepo.Trait.Helper.getIdGenerator((IdGeneratorRepo)this);
    }

    public /* synthetic */ IdGenerator gorm_tools_repository_model_IdGeneratorRepotrait$super$getIdGenerator() {
        if (this instanceof GeneratedGroovyProxy) {
            return (IdGenerator)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getIdGenerator", (Object)new Object[0]), IdGenerator.class);
        }
        return (IdGenerator)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getIdGenerator"), IdGenerator.class);
    }

    @Traits.TraitBridge(traitClass=IdGeneratorRepo.class, desc="()Lgorm/tools/repository/events/RepoEventPublisher;")
    public RepoEventPublisher getRepoEventPublisher() {
        return IdGeneratorRepo.Trait.Helper.getRepoEventPublisher((IdGeneratorRepo)this);
    }

    public /* synthetic */ RepoEventPublisher gorm_tools_repository_model_IdGeneratorRepotrait$super$getRepoEventPublisher() {
        return GormRepo.Trait.Helper.getRepoEventPublisher((GormRepo)this);
    }

    public /* synthetic */ RepoEventPublisher gorm_tools_repository_GormRepotrait$super$getRepoEventPublisher() {
        if (this instanceof GeneratedGroovyProxy) {
            return (RepoEventPublisher)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getRepoEventPublisher", (Object)new Object[0]), RepoEventPublisher.class);
        }
        return (RepoEventPublisher)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getRepoEventPublisher"), RepoEventPublisher.class);
    }

    @Traits.TraitBridge(traitClass=IdGeneratorRepo.class, desc="(Ljava/lang/String;)V")
    public void setIdGeneratorKey(String param1) {
        IdGeneratorRepo.Trait.Helper.setIdGeneratorKey((IdGeneratorRepo)this, (String)param1);
    }

    public /* synthetic */ void gorm_tools_repository_model_IdGeneratorRepotrait$super$setIdGeneratorKey(String param0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setIdGeneratorKey", (Object)new Object[]{param0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"setIdGeneratorKey", (Object[])new Object[]{param0});
        }
    }

    @Traits.TraitBridge(traitClass=IdGeneratorRepo.class, desc="(Ljava/lang/Object;Lgorm/tools/repository/PersistArgs;)V")
    public void doBeforePersist(Activity param1, PersistArgs param2) {
        IdGeneratorRepo.Trait.Helper.doBeforePersist((IdGeneratorRepo)this, (Object)param1, (PersistArgs)param2);
    }

    @Traits.TraitBridge(traitClass=IdGeneratorRepo.class, desc="()Ljava/lang/Long;")
    public Long generateId() {
        return IdGeneratorRepo.Trait.Helper.generateId((IdGeneratorRepo)this);
    }

    public /* synthetic */ Long gorm_tools_repository_model_IdGeneratorRepotrait$super$generateId() {
        if (this instanceof GeneratedGroovyProxy) {
            return (Long)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"generateId", (Object)new Object[0]), Long.class);
        }
        return (Long)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"generateId"), Long.class);
    }

    static {
        Logger logger;
        gorm_tools_repository_bulk_BulkableRepo__log = logger = BulkableRepo.Trait.Helper.$static$init$gorm_tools_repository_bulk_BulkableRepo__log(ActivityRepo.class);
        IdGeneratorRepo.Trait.Helper.$static$init$(ActivityRepo.class);
        GormRepo.Trait.Helper.$static$init$(ActivityRepo.class);
        QueryMangoEntityApi.Trait.Helper.$static$init$(ActivityRepo.class);
        BulkableRepo.Trait.Helper.$static$init$(ActivityRepo.class);
    }

    public RepoEventPublisher gorm_tools_repository_model_IdGeneratorRepo__repoEventPublisher$get() {
        return this.gorm_tools_repository_model_IdGeneratorRepo__repoEventPublisher;
    }

    public IdGenerator gorm_tools_repository_model_IdGeneratorRepo__idGenerator$get() {
        return this.gorm_tools_repository_model_IdGeneratorRepo__idGenerator;
    }

    public String gorm_tools_repository_model_IdGeneratorRepo__idGeneratorKey$get() {
        return this.gorm_tools_repository_model_IdGeneratorRepo__idGeneratorKey;
    }

    public String gorm_tools_repository_model_IdGeneratorRepo__idGeneratorKey$set(String val) {
        String string;
        this.gorm_tools_repository_model_IdGeneratorRepo__idGeneratorKey = string = val;
        return string;
    }

    public RepoEventPublisher gorm_tools_repository_model_IdGeneratorRepo__repoEventPublisher$set(RepoEventPublisher val) {
        RepoEventPublisher repoEventPublisher;
        this.gorm_tools_repository_model_IdGeneratorRepo__repoEventPublisher = repoEventPublisher = val;
        return repoEventPublisher;
    }

    public IdGenerator gorm_tools_repository_model_IdGeneratorRepo__idGenerator$set(IdGenerator val) {
        IdGenerator idGenerator;
        this.gorm_tools_repository_model_IdGeneratorRepo__idGenerator = idGenerator = val;
        return idGenerator;
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Lgorm/tools/repository/PersistArgs;)Z")
    public boolean validate(Activity param1, PersistArgs param2) {
        return GormRepo.Trait.Helper.validate((GormRepo)this, (Object)param1, (PersistArgs)param2);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/io/Serializable;)Ljava/lang/Object;")
    public Activity load(Serializable param1) {
        return (Activity)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.load((GormRepo)this, (Serializable)param1), Activity.class);
    }

    public /* synthetic */ Activity gorm_tools_repository_GormRepotrait$super$load(Serializable param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Activity)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"load", (Object)new Object[]{param0}), Activity.class);
        }
        return (Activity)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"load", (Object[])new Object[]{param0}), Activity.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Ljava/util/Map;)V")
    public void remove(Activity param1, Map param2) {
        GormRepo.Trait.Helper.remove((GormRepo)this, (Object)param1, (Map)param2);
    }

    @Generated
    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/util/Map;)Ljava/lang/Object;")
    public Activity createOrUpdate(Map param1) {
        return (Activity)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.createOrUpdate((GormRepo)this, (Map)param1), Activity.class);
    }

    public /* synthetic */ Activity gorm_tools_repository_GormRepotrait$super$createOrUpdate(Map<Object, Object> param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Activity)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"createOrUpdate", (Object)new Object[]{param0}), Activity.class);
        }
        return (Activity)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"createOrUpdate", (Object[])new Object[]{param0}), Activity.class);
    }

    @Generated
    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/util/Map;)Ljava/lang/Object;")
    public Activity update(Map param1) {
        return (Activity)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.update((GormRepo)this, (Map)param1), Activity.class);
    }

    public /* synthetic */ Activity gorm_tools_repository_GormRepotrait$super$update(Map<Object, Object> param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Activity)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"update", (Object)new Object[]{param0}), Activity.class);
        }
        return (Activity)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"update", (Object[])new Object[]{param0}), Activity.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Lgorm/tools/repository/PersistArgs;)Ljava/lang/Object;")
    public Activity doPersist(Activity param1, PersistArgs param2) {
        return (Activity)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.doPersist((GormRepo)this, (Object)param1, (PersistArgs)param2), Activity.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="()Lgorm/tools/databinding/EntityMapBinder;")
    public EntityMapBinder getEntityMapBinder() {
        return GormRepo.Trait.Helper.getEntityMapBinder((GormRepo)this);
    }

    public /* synthetic */ EntityMapBinder gorm_tools_repository_GormRepotrait$super$getEntityMapBinder() {
        if (this instanceof GeneratedGroovyProxy) {
            return (EntityMapBinder)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getEntityMapBinder", (Object)new Object[0]), EntityMapBinder.class);
        }
        return (EntityMapBinder)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getEntityMapBinder"), EntityMapBinder.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Lgorm/tools/repository/PersistArgs;)V")
    public void doAfterValidateBeforeSave(Activity param1, PersistArgs param2) {
        GormRepo.Trait.Helper.doAfterValidateBeforeSave((GormRepo)this, (Object)param1, (PersistArgs)param2);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Class;)V")
    public void setEntityClass(Class<Activity> param1) {
        GormRepo.Trait.Helper.setEntityClass((GormRepo)this, param1);
    }

    public /* synthetic */ void gorm_tools_repository_GormRepotrait$super$setEntityClass(Class<Activity> param0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setEntityClass", (Object)new Object[]{param0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"setEntityClass", (Object[])new Object[]{param0});
        }
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/util/Map;Lgorm/tools/repository/PersistArgs;)Ljava/lang/Object;")
    public Activity doCreate(Map param1, PersistArgs param2) {
        return (Activity)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.doCreate((GormRepo)this, (Map)param1, (PersistArgs)param2), Activity.class);
    }

    public /* synthetic */ Activity gorm_tools_repository_GormRepotrait$super$doCreate(Map<Object, Object> param0, PersistArgs param1) {
        return (Activity)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeStaticMethodN(ActivityRepo.class, BulkableRepo.Trait.Helper.class, (String)"doCreate", (Object[])new Object[]{this, param0, param1}), Activity.class);
    }

    public /* synthetic */ Activity gorm_tools_repository_bulk_BulkableRepotrait$super$doCreate(Map<Object, Object> param0, PersistArgs param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Activity)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"doCreate", (Object)new Object[]{param0, param1}), Activity.class);
        }
        return (Activity)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"doCreate", (Object[])new Object[]{param0, param1}), Activity.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/util/Map;Z)Ljava/lang/Object;")
    public Activity findWithData(Map param1, boolean param2) {
        return (Activity)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.findWithData((GormRepo)this, (Map)param1, (boolean)param2), Activity.class);
    }

    public /* synthetic */ Activity gorm_tools_repository_GormRepotrait$super$findWithData(Map<Object, Object> param0, boolean param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Activity)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"findWithData", (Object)new Object[]{param0, param1}), Activity.class);
        }
        return (Activity)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"findWithData", (Object[])new Object[]{param0, param1}), Activity.class);
    }

    @Generated
    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;)V")
    public void remove(Activity param1) {
        GormRepo.Trait.Helper.remove((GormRepo)this, (Object)param1);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Lgorm/tools/databinding/EntityMapBinder;)V")
    public void setEntityMapBinder(EntityMapBinder param1) {
        GormRepo.Trait.Helper.setEntityMapBinder((GormRepo)this, (EntityMapBinder)param1);
    }

    public /* synthetic */ void gorm_tools_repository_GormRepotrait$super$setEntityMapBinder(EntityMapBinder param0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setEntityMapBinder", (Object)new Object[]{param0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"setEntityMapBinder", (Object[])new Object[]{param0});
        }
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="()Lorg/grails/datastore/gorm/GormStaticApi;")
    public GormStaticApi<Activity> gormStaticApi() {
        return GormRepo.Trait.Helper.gormStaticApi((GormRepo)this);
    }

    public /* synthetic */ GormStaticApi<Activity> gorm_tools_repository_GormRepotrait$super$gormStaticApi() {
        if (this instanceof GeneratedGroovyProxy) {
            return (GormStaticApi)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"gormStaticApi", (Object)new Object[0]), GormStaticApi.class);
        }
        return (GormStaticApi)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"gormStaticApi"), GormStaticApi.class);
    }

    @Generated
    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Ljava/util/Map;Lgorm/tools/databinding/BindAction;)V")
    public void bind(Activity param1, Map param2, BindAction param3) {
        GormRepo.Trait.Helper.bind((GormRepo)this, (Object)param1, (Map)param2, (BindAction)param3);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/util/Map;Lgorm/tools/repository/PersistArgs;)Ljava/lang/Object;")
    public Activity createOrUpdate(Map param1, PersistArgs param2) {
        return (Activity)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.createOrUpdate((GormRepo)this, (Map)param1, (PersistArgs)param2), Activity.class);
    }

    public /* synthetic */ Activity gorm_tools_repository_GormRepotrait$super$createOrUpdate(Map<Object, Object> param0, PersistArgs param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Activity)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"createOrUpdate", (Object)new Object[]{param0, param1}), Activity.class);
        }
        return (Activity)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"createOrUpdate", (Object[])new Object[]{param0, param1}), Activity.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Lgroovy/lang/Closure;)Ljava/lang/Object;")
    public Activity entityTrx(Closure<Activity> param1) {
        return (Activity)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.entityTrx((GormRepo)this, param1), Activity.class);
    }

    public /* synthetic */ Activity gorm_tools_repository_GormRepotrait$super$entityTrx(Closure<Activity> param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Activity)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"entityTrx", (Object)new Object[]{param0}), Activity.class);
        }
        return (Activity)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"entityTrx", (Object[])new Object[]{param0}), Activity.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="()V")
    public void clear() {
        GormRepo.Trait.Helper.clear((GormRepo)this);
    }

    public /* synthetic */ void gorm_tools_repository_GormRepotrait$super$clear() {
        ScriptBytecodeAdapter.invokeStaticMethodN(ActivityRepo.class, BulkableRepo.Trait.Helper.class, (String)"clear", (Object[])new Object[]{this});
    }

    public /* synthetic */ void gorm_tools_repository_bulk_BulkableRepotrait$super$clear() {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"clear", (Object)new Object[0]);
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"clear");
        }
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Ljava/util/Map;Lgorm/tools/databinding/BindAction;Lgorm/tools/repository/PersistArgs;)V")
    public void bindAndSave(Activity param1, Map param2, BindAction param3, PersistArgs param4) {
        GormRepo.Trait.Helper.bindAndSave((GormRepo)this, (Object)param1, (Map)param2, (BindAction)param3, (PersistArgs)param4);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/io/Serializable;Ljava/lang/Long;)Ljava/lang/Object;")
    public Activity get(Serializable param1, Long param2) {
        return (Activity)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.get((GormRepo)this, (Serializable)param1, (Long)param2), Activity.class);
    }

    public /* synthetic */ Activity gorm_tools_repository_GormRepotrait$super$get(Serializable param0, Long param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Activity)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"get", (Object)new Object[]{param0, param1}), Activity.class);
        }
        return (Activity)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"get", (Object[])new Object[]{param0, param1}), Activity.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Lgorm/tools/repository/GormRepo;Ljava/util/List;Ljava/lang/String;)Ljava/util/List;")
    public List persistToManyData(Activity param1, GormRepo param2, List<Map> param3, String param4) {
        return GormRepo.Trait.Helper.persistToManyData((GormRepo)this, (Object)param1, (GormRepo)param2, param3, (String)param4);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/io/Serializable;)Ljava/lang/Object;")
    public Activity read(Serializable param1) {
        return (Activity)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.read((GormRepo)this, (Serializable)param1), Activity.class);
    }

    public /* synthetic */ Activity gorm_tools_repository_GormRepotrait$super$read(Serializable param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Activity)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"read", (Object)new Object[]{param0}), Activity.class);
        }
        return (Activity)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"read", (Object[])new Object[]{param0}), Activity.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Lgorm/tools/repository/PersistArgs;)V")
    public void doBeforePersistWithData(Activity param1, PersistArgs param2) {
        GormRepo.Trait.Helper.doBeforePersistWithData((GormRepo)this, (Object)param1, (PersistArgs)param2);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="()Lgrails/core/support/proxy/ProxyHandler;")
    public ProxyHandler getProxyHandler() {
        return GormRepo.Trait.Helper.getProxyHandler((GormRepo)this);
    }

    public /* synthetic */ ProxyHandler gorm_tools_repository_GormRepotrait$super$getProxyHandler() {
        if (this instanceof GeneratedGroovyProxy) {
            return (ProxyHandler)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getProxyHandler", (Object)new Object[0]), ProxyHandler.class);
        }
        return (ProxyHandler)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getProxyHandler"), ProxyHandler.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="()V")
    public void flushAndClear() {
        GormRepo.Trait.Helper.flushAndClear((GormRepo)this);
    }

    public /* synthetic */ void gorm_tools_repository_GormRepotrait$super$flushAndClear() {
        ScriptBytecodeAdapter.invokeStaticMethodN(ActivityRepo.class, BulkableRepo.Trait.Helper.class, (String)"flushAndClear", (Object[])new Object[]{this});
    }

    public /* synthetic */ void gorm_tools_repository_bulk_BulkableRepotrait$super$flushAndClear() {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"flushAndClear", (Object)new Object[0]);
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"flushAndClear");
        }
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Ljava/util/List;)V")
    public void persistToOneAssociations(Activity param1, List<String> param2) {
        GormRepo.Trait.Helper.persistToOneAssociations((GormRepo)this, (Object)param1, param2);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="()Lorg/grails/datastore/gorm/GormValidationApi;")
    public GormValidationApi gormValidationApi() {
        return GormRepo.Trait.Helper.gormValidationApi((GormRepo)this);
    }

    public /* synthetic */ GormValidationApi<Activity> gorm_tools_repository_GormRepotrait$super$gormValidationApi() {
        if (this instanceof GeneratedGroovyProxy) {
            return (GormValidationApi)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"gormValidationApi", (Object)new Object[0]), GormValidationApi.class);
        }
        return (GormValidationApi)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"gormValidationApi"), GormValidationApi.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="()Ljava/lang/Boolean;")
    public Boolean getEnableEvents() {
        return GormRepo.Trait.Helper.getEnableEvents((GormRepo)this);
    }

    public /* synthetic */ Boolean gorm_tools_repository_GormRepotrait$super$getEnableEvents() {
        if (this instanceof GeneratedGroovyProxy) {
            return (Boolean)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getEnableEvents", (Object)new Object[0]), Boolean.class);
        }
        return (Boolean)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getEnableEvents"), Boolean.class);
    }

    @Generated
    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Lgorm/tools/repository/GormRepo;Ljava/util/List;)Ljava/util/List;")
    public List persistToManyData(Activity param1, GormRepo param2, List<Map> param3) {
        return GormRepo.Trait.Helper.persistToManyData((GormRepo)this, (Object)param1, (GormRepo)param2, param3);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/io/Serializable;)Ljava/lang/Object;")
    public Activity get(Serializable param1) {
        return (Activity)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.get((GormRepo)this, (Serializable)param1), Activity.class);
    }

    public /* synthetic */ Activity gorm_tools_repository_GormRepotrait$super$get(Serializable param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Activity)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"get", (Object)new Object[]{param0}), Activity.class);
        }
        return (Activity)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"get", (Object[])new Object[]{param0}), Activity.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Ljava/util/Map;Lgorm/tools/databinding/BindAction;Lgorm/tools/repository/PersistArgs;)V")
    public void doBind(Activity param1, Map param2, BindAction param3, PersistArgs param4) {
        GormRepo.Trait.Helper.doBind((GormRepo)this, (Object)param1, (Map)param2, (BindAction)param3, (PersistArgs)param4);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Lgroovy/lang/Closure;)Ljava/lang/Object;")
    public Activity entityReadOnlyTrx(Closure<Activity> param1) {
        return (Activity)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.entityReadOnlyTrx((GormRepo)this, param1), Activity.class);
    }

    public /* synthetic */ Activity gorm_tools_repository_GormRepotrait$super$entityReadOnlyTrx(Closure<Activity> param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Activity)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"entityReadOnlyTrx", (Object)new Object[]{param0}), Activity.class);
        }
        return (Activity)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"entityReadOnlyTrx", (Object[])new Object[]{param0}), Activity.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/util/Map;Lgorm/tools/repository/PersistArgs;)Ljava/lang/Object;")
    public Activity create(Map param1, PersistArgs param2) {
        return (Activity)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.create((GormRepo)this, (Map)param1, (PersistArgs)param2), Activity.class);
    }

    public /* synthetic */ Activity gorm_tools_repository_GormRepotrait$super$create(Map<Object, Object> param0, PersistArgs param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Activity)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"create", (Object)new Object[]{param0, param1}), Activity.class);
        }
        return (Activity)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"create", (Object[])new Object[]{param0, param1}), Activity.class);
    }

    public /* synthetic */ List<String> gorm_tools_repository_GormRepotrait$super$getToOneAssociations() {
        if (this instanceof GeneratedGroovyProxy) {
            return (List)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getToOneAssociations", (Object)new Object[0]), List.class);
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getToOneAssociations"), List.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Ljava/util/Map;Lgorm/tools/repository/PersistArgs;)V")
    public void bindAndUpdate(Activity param1, Map param2, PersistArgs param3) {
        GormRepo.Trait.Helper.bindAndUpdate((GormRepo)this, (Object)param1, (Map)param2, (PersistArgs)param3);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/util/List;)Ljava/util/List;")
    public List<Activity> createOrUpdate(List<Map> param1) {
        return GormRepo.Trait.Helper.createOrUpdate((GormRepo)this, param1);
    }

    public /* synthetic */ List<Activity> gorm_tools_repository_GormRepotrait$super$createOrUpdate(List<Map<Object, Object>> param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (List)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"createOrUpdate", (Object)new Object[]{param0}), List.class);
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"createOrUpdate", (Object[])new Object[]{param0}), List.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Boolean;)V")
    public void setEnableEvents(Boolean param1) {
        GormRepo.Trait.Helper.setEnableEvents((GormRepo)this, (Boolean)param1);
    }

    public /* synthetic */ void gorm_tools_repository_GormRepotrait$super$setEnableEvents(Boolean param0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setEnableEvents", (Object)new Object[]{param0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"setEnableEvents", (Object[])new Object[]{param0});
        }
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="()V")
    public void flush() {
        GormRepo.Trait.Helper.flush((GormRepo)this);
    }

    public /* synthetic */ void gorm_tools_repository_GormRepotrait$super$flush() {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"flush", (Object)new Object[0]);
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"flush");
        }
    }

    @Generated
    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/util/Map;)Ljava/lang/Object;")
    public Activity findWithData(Map param1) {
        return (Activity)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.findWithData((GormRepo)this, (Map)param1), Activity.class);
    }

    public /* synthetic */ Activity gorm_tools_repository_GormRepotrait$super$findWithData(Map<Object, Object> param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Activity)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"findWithData", (Object)new Object[]{param0}), Activity.class);
        }
        return (Activity)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"findWithData", (Object[])new Object[]{param0}), Activity.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/util/Map;)Ljava/lang/Object;")
    public Activity lookup(Map param1) {
        return (Activity)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.lookup((GormRepo)this, (Map)param1), Activity.class);
    }

    public /* synthetic */ Activity gorm_tools_repository_GormRepotrait$super$lookup(Map<Object, Object> param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Activity)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"lookup", (Object)new Object[]{param0}), Activity.class);
        }
        return (Activity)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"lookup", (Object[])new Object[]{param0}), Activity.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/io/Serializable;)Ljava/lang/Object;")
    public Activity getWithTrx(Serializable param1) {
        return (Activity)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.getWithTrx((GormRepo)this, (Serializable)param1), Activity.class);
    }

    public /* synthetic */ Activity gorm_tools_repository_GormRepotrait$super$getWithTrx(Serializable param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Activity)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getWithTrx", (Object)new Object[]{param0}), Activity.class);
        }
        return (Activity)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"getWithTrx", (Object[])new Object[]{param0}), Activity.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Lgorm/tools/repository/PersistArgs;)V")
    public void doRemove(Activity param1, PersistArgs param2) {
        GormRepo.Trait.Helper.doRemove((GormRepo)this, (Object)param1, (PersistArgs)param2);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="()Lorg/grails/datastore/gorm/GormInstanceApi;")
    public GormInstanceApi<Activity> gormInstanceApi() {
        return GormRepo.Trait.Helper.gormInstanceApi((GormRepo)this);
    }

    public /* synthetic */ GormInstanceApi<Activity> gorm_tools_repository_GormRepotrait$super$gormInstanceApi() {
        if (this instanceof GeneratedGroovyProxy) {
            return (GormInstanceApi)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"gormInstanceApi", (Object)new Object[0]), GormInstanceApi.class);
        }
        return (GormInstanceApi)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"gormInstanceApi"), GormInstanceApi.class);
    }

    @Generated
    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;)Ljava/lang/Object;")
    public Activity gormSave(Activity param1) {
        return (Activity)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.gormSave((GormRepo)this, (Object)param1), Activity.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/util/Map;Lgorm/tools/repository/PersistArgs;)Ljava/lang/Object;")
    public Activity doUpdate(Map param1, PersistArgs param2) {
        return (Activity)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.doUpdate((GormRepo)this, (Map)param1, (PersistArgs)param2), Activity.class);
    }

    public /* synthetic */ Activity gorm_tools_repository_GormRepotrait$super$doUpdate(Map<Object, Object> param0, PersistArgs param1) {
        return (Activity)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeStaticMethodN(ActivityRepo.class, BulkableRepo.Trait.Helper.class, (String)"doUpdate", (Object[])new Object[]{this, param0, param1}), Activity.class);
    }

    public /* synthetic */ Activity gorm_tools_repository_bulk_BulkableRepotrait$super$doUpdate(Map<Object, Object> param0, PersistArgs param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Activity)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"doUpdate", (Object)new Object[]{param0, param1}), Activity.class);
        }
        return (Activity)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"doUpdate", (Object[])new Object[]{param0, param1}), Activity.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="()Ljava/lang/Class;")
    public Class<Activity> getEntityClass() {
        return GormRepo.Trait.Helper.getEntityClass((GormRepo)this);
    }

    public /* synthetic */ Class<Activity> gorm_tools_repository_model_IdGeneratorRepotrait$super$getEntityClass() {
        return GormRepo.Trait.Helper.getEntityClass((GormRepo)this);
    }

    public /* synthetic */ Class<Activity> gorm_tools_repository_GormRepotrait$super$getEntityClass() {
        return ShortTypeHandling.castToClass((Object)ScriptBytecodeAdapter.invokeStaticMethodN(ActivityRepo.class, QueryMangoEntityApi.Trait.Helper.class, (String)"getEntityClass", (Object[])new Object[]{this}));
    }

    public /* synthetic */ Class<Activity> gorm_tools_mango_api_QueryMangoEntityApitrait$super$getEntityClass() {
        return ShortTypeHandling.castToClass((Object)ScriptBytecodeAdapter.invokeStaticMethodN(ActivityRepo.class, BulkableRepo.Trait.Helper.class, (String)"getEntityClass", (Object[])new Object[]{this}));
    }

    public /* synthetic */ Class<Activity> gorm_tools_repository_bulk_BulkableRepotrait$super$getEntityClass() {
        if (this instanceof GeneratedGroovyProxy) {
            return ShortTypeHandling.castToClass((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getEntityClass", (Object)new Object[0]));
        }
        return ShortTypeHandling.castToClass((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getEntityClass"));
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Lgorm/tools/repository/PersistArgs;)V")
    public void doAfterPersist(Activity param1, PersistArgs param2) {
        GormRepo.Trait.Helper.doAfterPersist((GormRepo)this, (Object)param1, (PersistArgs)param2);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Lgorm/tools/repository/PersistArgs;)Ljava/lang/Object;")
    public Activity gormSave(Activity param1, PersistArgs param2) {
        return (Activity)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.gormSave((GormRepo)this, (Object)param1, (PersistArgs)param2), Activity.class);
    }

    @Generated
    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/util/Map;)Ljava/lang/Object;")
    public Activity create(Map param1) {
        return (Activity)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.create((GormRepo)this, (Map)param1), Activity.class);
    }

    public /* synthetic */ Activity gorm_tools_repository_GormRepotrait$super$create(Map<Object, Object> param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Activity)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"create", (Object)new Object[]{param0}), Activity.class);
        }
        return (Activity)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"create", (Object[])new Object[]{param0}), Activity.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Ljava/util/Map;)Ljava/lang/Object;")
    public Activity persist(Activity param1, Map param2) {
        return (Activity)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.persist((GormRepo)this, (Object)param1, (Map)param2), Activity.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Lgrails/core/support/proxy/ProxyHandler;)V")
    public void setProxyHandler(ProxyHandler param1) {
        GormRepo.Trait.Helper.setProxyHandler((GormRepo)this, (ProxyHandler)param1);
    }

    public /* synthetic */ void gorm_tools_repository_GormRepotrait$super$setProxyHandler(ProxyHandler param0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setProxyHandler", (Object)new Object[]{param0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"setProxyHandler", (Object[])new Object[]{param0});
        }
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;)Z")
    public boolean isNewOrDirty(Activity param1) {
        return GormRepo.Trait.Helper.isNewOrDirty((GormRepo)this, (Object)param1);
    }

    @Generated
    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/io/Serializable;)V")
    public void removeById(Serializable param1) {
        GormRepo.Trait.Helper.removeById((GormRepo)this, (Serializable)param1);
    }

    public /* synthetic */ void gorm_tools_repository_GormRepotrait$super$removeById(Serializable param0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"removeById", (Object)new Object[]{param0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"removeById", (Object[])new Object[]{param0});
        }
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Lgroovy/lang/Closure;)Ljava/lang/Object;")
    public <T> T withTrx(Closure<T> param1) {
        return (T)GormRepo.Trait.Helper.withTrx((GormRepo)this, param1);
    }

    public /* synthetic */ <T> T gorm_tools_repository_GormRepotrait$super$withTrx(Closure<T> param0) {
        return (T)ScriptBytecodeAdapter.invokeStaticMethodN(ActivityRepo.class, BulkableRepo.Trait.Helper.class, (String)"withTrx", (Object[])new Object[]{this, param0});
    }

    public /* synthetic */ <T> T gorm_tools_repository_bulk_BulkableRepotrait$super$withTrx(Closure<T> param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (T)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"withTrx", (Object)new Object[]{param0});
        }
        return (T)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"withTrx", (Object[])new Object[]{param0});
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/util/Map;Ljava/util/Map;)Ljava/lang/Object;")
    public Activity update(Map param1, Map param2) {
        return (Activity)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.update((GormRepo)this, (Map)param1, (Map)param2), Activity.class);
    }

    public /* synthetic */ Activity gorm_tools_repository_GormRepotrait$super$update(Map<Object, Object> param0, Map<Object, Object> param1) {
        return (Activity)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeStaticMethodN(ActivityRepo.class, BulkableRepo.Trait.Helper.class, (String)"update", (Object[])new Object[]{this, param0, param1}), Activity.class);
    }

    public /* synthetic */ Activity gorm_tools_repository_bulk_BulkableRepotrait$super$update(Map<Object, Object> param0, Map<Object, Object> param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Activity)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"update", (Object)new Object[]{param0, param1}), Activity.class);
        }
        return (Activity)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"update", (Object[])new Object[]{param0, param1}), Activity.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="()Lorg/grails/datastore/mapping/core/Datastore;")
    public Datastore getDatastore() {
        return GormRepo.Trait.Helper.getDatastore((GormRepo)this);
    }

    public /* synthetic */ Datastore gorm_tools_repository_GormRepotrait$super$getDatastore() {
        return (Datastore)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeStaticMethodN(ActivityRepo.class, BulkableRepo.Trait.Helper.class, (String)"getDatastore", (Object[])new Object[]{this}), Datastore.class);
    }

    public /* synthetic */ Datastore gorm_tools_repository_bulk_BulkableRepotrait$super$getDatastore() {
        if (this instanceof GeneratedGroovyProxy) {
            return (Datastore)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getDatastore", (Object)new Object[0]), Datastore.class);
        }
        return (Datastore)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getDatastore"), Datastore.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Ljava/util/Map;Lgorm/tools/repository/PersistArgs;)V")
    public void bindAndCreate(Activity param1, Map param2, PersistArgs param3) {
        GormRepo.Trait.Helper.bindAndCreate((GormRepo)this, (Object)param1, (Map)param2, (PersistArgs)param3);
    }

    @Generated
    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;)Ljava/lang/Object;")
    public Activity persist(Activity param1) {
        return (Activity)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.persist((GormRepo)this, (Object)param1), Activity.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/io/Serializable;Ljava/util/Map;)V")
    public void removeById(Serializable param1, Map param2) {
        GormRepo.Trait.Helper.removeById((GormRepo)this, (Serializable)param1, (Map)param2);
    }

    public /* synthetic */ void gorm_tools_repository_GormRepotrait$super$removeById(Serializable param0, Map<Object, Object> param1) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"removeById", (Object)new Object[]{param0, param1});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"removeById", (Object[])new Object[]{param0, param1});
        }
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Lgroovy/lang/Closure;)Ljava/lang/Object;")
    public <T> T withNewTrx(Closure<T> param1) {
        return (T)GormRepo.Trait.Helper.withNewTrx((GormRepo)this, param1);
    }

    public /* synthetic */ <T> T gorm_tools_repository_GormRepotrait$super$withNewTrx(Closure<T> param0) {
        return (T)ScriptBytecodeAdapter.invokeStaticMethodN(ActivityRepo.class, BulkableRepo.Trait.Helper.class, (String)"withNewTrx", (Object[])new Object[]{this, param0});
    }

    public /* synthetic */ <T> T gorm_tools_repository_bulk_BulkableRepotrait$super$withNewTrx(Closure<T> param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (T)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"withNewTrx", (Object)new Object[]{param0});
        }
        return (T)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"withNewTrx", (Object[])new Object[]{param0});
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Ljava/util/Map;Lgorm/tools/databinding/BindAction;Lgorm/tools/repository/PersistArgs;)V")
    public void bind(Activity param1, Map param2, BindAction param3, PersistArgs param4) {
        GormRepo.Trait.Helper.bind((GormRepo)this, (Object)param1, (Map)param2, (BindAction)param3, (PersistArgs)param4);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/util/Map;Lgorm/tools/repository/PersistArgs;)Ljava/lang/Object;")
    public Activity update(Map param1, PersistArgs param2) {
        return (Activity)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.update((GormRepo)this, (Map)param1, (PersistArgs)param2), Activity.class);
    }

    public /* synthetic */ Activity gorm_tools_repository_GormRepotrait$super$update(Map<Object, Object> param0, PersistArgs param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Activity)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"update", (Object)new Object[]{param0, param1}), Activity.class);
        }
        return (Activity)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"update", (Object[])new Object[]{param0, param1}), Activity.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Lgorm/tools/repository/PersistArgs;)Ljava/lang/Object;")
    public Activity persist(Activity param1, PersistArgs param2) {
        return (Activity)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.persist((GormRepo)this, (Object)param1, (PersistArgs)param2), Activity.class);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/lang/Object;Lgorm/tools/repository/PersistArgs;)V")
    public void validateAndSave(Activity param1, PersistArgs param2) {
        GormRepo.Trait.Helper.validateAndSave((GormRepo)this, (Object)param1, (PersistArgs)param2);
    }

    @Traits.TraitBridge(traitClass=GormRepo.class, desc="(Ljava/util/Map;Ljava/util/Map;)Ljava/lang/Object;")
    public Activity create(Map param1, Map param2) {
        return (Activity)ScriptBytecodeAdapter.castToType((Object)GormRepo.Trait.Helper.create((GormRepo)this, (Map)param1, (Map)param2), Activity.class);
    }

    public /* synthetic */ Activity gorm_tools_repository_GormRepotrait$super$create(Map<Object, Object> param0, Map<Object, Object> param1) {
        return (Activity)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeStaticMethodN(ActivityRepo.class, BulkableRepo.Trait.Helper.class, (String)"create", (Object[])new Object[]{this, param0, param1}), Activity.class);
    }

    public /* synthetic */ Activity gorm_tools_repository_bulk_BulkableRepotrait$super$create(Map<Object, Object> param0, Map<Object, Object> param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Activity)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"create", (Object)new Object[]{param0, param1}), Activity.class);
        }
        return (Activity)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"create", (Object[])new Object[]{param0, param1}), Activity.class);
    }

    public ProxyHandler gorm_tools_repository_GormRepo__proxyHandler$get() {
        return this.gorm_tools_repository_GormRepo__proxyHandler;
    }

    public Class<Activity> gorm_tools_repository_GormRepo__entityClass$get() {
        return this.gorm_tools_repository_GormRepo__entityClass;
    }

    public Boolean gorm_tools_repository_GormRepo__enableEvents$get() {
        return this.gorm_tools_repository_GormRepo__enableEvents;
    }

    public RepoEventPublisher gorm_tools_repository_GormRepo__repoEventPublisher$get() {
        return this.gorm_tools_repository_GormRepo__repoEventPublisher;
    }

    public EntityMapBinder gorm_tools_repository_GormRepo__entityMapBinder$get() {
        return this.gorm_tools_repository_GormRepo__entityMapBinder;
    }

    public EntityMapBinder gorm_tools_repository_GormRepo__entityMapBinder$set(EntityMapBinder val) {
        EntityMapBinder entityMapBinder;
        this.gorm_tools_repository_GormRepo__entityMapBinder = entityMapBinder = val;
        return entityMapBinder;
    }

    public ProxyHandler gorm_tools_repository_GormRepo__proxyHandler$set(ProxyHandler val) {
        ProxyHandler proxyHandler;
        this.gorm_tools_repository_GormRepo__proxyHandler = proxyHandler = val;
        return proxyHandler;
    }

    public Class<Activity> gorm_tools_repository_GormRepo__entityClass$set(Class<Activity> val) {
        Class<Activity> clazz = val;
        this.gorm_tools_repository_GormRepo__entityClass = clazz;
        return clazz;
    }

    public Boolean gorm_tools_repository_GormRepo__enableEvents$set(Boolean val) {
        Boolean bl;
        this.gorm_tools_repository_GormRepo__enableEvents = bl = val;
        return bl;
    }

    public RepoEventPublisher gorm_tools_repository_GormRepo__repoEventPublisher$set(RepoEventPublisher val) {
        RepoEventPublisher repoEventPublisher;
        this.gorm_tools_repository_GormRepo__repoEventPublisher = repoEventPublisher = val;
        return repoEventPublisher;
    }

    @Traits.TraitBridge(traitClass=QueryMangoEntityApi.class, desc="(Lgroovy/lang/Closure;)Lgorm/tools/mango/MangoDetachedCriteria;")
    public MangoDetachedCriteria<Activity> query(@DelegatesTo(genericTypeIndex=-1, strategy=0, type="", value=MangoDetachedCriteria.class, target="") Closure param1) {
        return QueryMangoEntityApi.Trait.Helper.query((QueryMangoEntityApi)this, (Closure)param1);
    }

    public /* synthetic */ MangoDetachedCriteria<Activity> gorm_tools_mango_api_QueryMangoEntityApitrait$super$query(Closure<Object> param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (MangoDetachedCriteria)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"query", (Object)new Object[]{param0}), MangoDetachedCriteria.class);
        }
        return (MangoDetachedCriteria)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"query", (Object[])new Object[]{param0}), MangoDetachedCriteria.class);
    }

    @Generated
    @Traits.TraitBridge(traitClass=QueryMangoEntityApi.class, desc="(Ljava/util/Map;)Ljava/util/List;")
    public List<Activity> queryList(Map param1) {
        return QueryMangoEntityApi.Trait.Helper.queryList((QueryMangoEntityApi)this, (Map)param1);
    }

    public /* synthetic */ List<Activity> gorm_tools_mango_api_QueryMangoEntityApitrait$super$queryList(Map<Object, Object> param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (List)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"queryList", (Object)new Object[]{param0}), List.class);
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"queryList", (Object[])new Object[]{param0}), List.class);
    }

    @Generated
    @Traits.TraitBridge(traitClass=QueryMangoEntityApi.class, desc="()Ljava/util/List;")
    public List<Activity> queryList() {
        return QueryMangoEntityApi.Trait.Helper.queryList((QueryMangoEntityApi)this);
    }

    public /* synthetic */ List<Activity> gorm_tools_mango_api_QueryMangoEntityApitrait$super$queryList() {
        if (this instanceof GeneratedGroovyProxy) {
            return (List)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"queryList", (Object)new Object[0]), List.class);
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"queryList"), List.class);
    }

    @Generated
    @Traits.TraitBridge(traitClass=QueryMangoEntityApi.class, desc="(Ljava/util/Map;)Lgorm/tools/mango/MangoDetachedCriteria;")
    public MangoDetachedCriteria<Activity> query(Map param1) {
        return QueryMangoEntityApi.Trait.Helper.query((QueryMangoEntityApi)this, (Map)param1);
    }

    public /* synthetic */ MangoDetachedCriteria<Activity> gorm_tools_mango_api_QueryMangoEntityApitrait$super$query(Map<Object, Object> param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (MangoDetachedCriteria)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"query", (Object)new Object[]{param0}), MangoDetachedCriteria.class);
        }
        return (MangoDetachedCriteria)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"query", (Object[])new Object[]{param0}), MangoDetachedCriteria.class);
    }

    @Traits.TraitBridge(traitClass=QueryMangoEntityApi.class, desc="(Ljava/util/Map;Lgroovy/lang/Closure;)Ljava/util/List;")
    public List<Activity> queryList(Map param1, @DelegatesTo(genericTypeIndex=-1, strategy=0, type="", value=MangoDetachedCriteria.class, target="") Closure param2) {
        return QueryMangoEntityApi.Trait.Helper.queryList((QueryMangoEntityApi)this, (Map)param1, (Closure)param2);
    }

    public /* synthetic */ List<Activity> gorm_tools_mango_api_QueryMangoEntityApitrait$super$queryList(Map<Object, Object> param0, Closure<Object> param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (List)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"queryList", (Object)new Object[]{param0, param1}), List.class);
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"queryList", (Object[])new Object[]{param0, param1}), List.class);
    }

    @Generated
    @Traits.TraitBridge(traitClass=QueryMangoEntityApi.class, desc="(Lgorm/tools/mango/api/QueryArgs;)Lgorm/tools/mango/MangoDetachedCriteria;")
    public MangoDetachedCriteria<Activity> query(QueryArgs param1) {
        return QueryMangoEntityApi.Trait.Helper.query((QueryMangoEntityApi)this, (QueryArgs)param1);
    }

    public /* synthetic */ MangoDetachedCriteria<Activity> gorm_tools_mango_api_QueryMangoEntityApitrait$super$query(QueryArgs param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (MangoDetachedCriteria)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"query", (Object)new Object[]{param0}), MangoDetachedCriteria.class);
        }
        return (MangoDetachedCriteria)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"query", (Object[])new Object[]{param0}), MangoDetachedCriteria.class);
    }

    @Traits.TraitBridge(traitClass=QueryMangoEntityApi.class, desc="(Lgorm/tools/mango/api/MangoQuery;)V")
    public void setMangoQuery(MangoQuery param1) {
        QueryMangoEntityApi.Trait.Helper.setMangoQuery((QueryMangoEntityApi)this, (MangoQuery)param1);
    }

    public /* synthetic */ void gorm_tools_mango_api_QueryMangoEntityApitrait$super$setMangoQuery(MangoQuery param0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setMangoQuery", (Object)new Object[]{param0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"setMangoQuery", (Object[])new Object[]{param0});
        }
    }

    public /* synthetic */ MangoDetachedCriteria<Activity> gorm_tools_mango_api_QueryMangoEntityApitrait$super$query(QueryArgs param0, Closure<Object> param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (MangoDetachedCriteria)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"query", (Object)new Object[]{param0, param1}), MangoDetachedCriteria.class);
        }
        return (MangoDetachedCriteria)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"query", (Object[])new Object[]{param0, param1}), MangoDetachedCriteria.class);
    }

    @Generated
    @Traits.TraitBridge(traitClass=QueryMangoEntityApi.class, desc="()Lgorm/tools/mango/MangoDetachedCriteria;")
    public MangoDetachedCriteria<Activity> query() {
        return QueryMangoEntityApi.Trait.Helper.query((QueryMangoEntityApi)this);
    }

    public /* synthetic */ MangoDetachedCriteria<Activity> gorm_tools_mango_api_QueryMangoEntityApitrait$super$query() {
        if (this instanceof GeneratedGroovyProxy) {
            return (MangoDetachedCriteria)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"query", (Object)new Object[0]), MangoDetachedCriteria.class);
        }
        return (MangoDetachedCriteria)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"query"), MangoDetachedCriteria.class);
    }

    @Generated
    @Traits.TraitBridge(traitClass=QueryMangoEntityApi.class, desc="(Lgorm/tools/mango/api/QueryArgs;)Ljava/util/List;")
    public List<Activity> queryList(QueryArgs param1) {
        return QueryMangoEntityApi.Trait.Helper.queryList((QueryMangoEntityApi)this, (QueryArgs)param1);
    }

    public /* synthetic */ List<Activity> gorm_tools_mango_api_QueryMangoEntityApitrait$super$queryList(QueryArgs param0) {
        if (this instanceof GeneratedGroovyProxy) {
            return (List)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"queryList", (Object)new Object[]{param0}), List.class);
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"queryList", (Object[])new Object[]{param0}), List.class);
    }

    @Traits.TraitBridge(traitClass=QueryMangoEntityApi.class, desc="(Ljava/util/Map;Lgroovy/lang/Closure;)Lgorm/tools/mango/MangoDetachedCriteria;")
    public MangoDetachedCriteria<Activity> query(Map param1, @DelegatesTo(genericTypeIndex=-1, strategy=0, type="", value=MangoDetachedCriteria.class, target="") Closure param2) {
        return QueryMangoEntityApi.Trait.Helper.query((QueryMangoEntityApi)this, (Map)param1, (Closure)param2);
    }

    public /* synthetic */ MangoDetachedCriteria<Activity> gorm_tools_mango_api_QueryMangoEntityApitrait$super$query(Map<Object, Object> param0, Closure<Object> param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (MangoDetachedCriteria)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"query", (Object)new Object[]{param0, param1}), MangoDetachedCriteria.class);
        }
        return (MangoDetachedCriteria)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"query", (Object[])new Object[]{param0, param1}), MangoDetachedCriteria.class);
    }

    @Traits.TraitBridge(traitClass=QueryMangoEntityApi.class, desc="()Lgorm/tools/mango/api/MangoQuery;")
    public MangoQuery getMangoQuery() {
        return QueryMangoEntityApi.Trait.Helper.getMangoQuery((QueryMangoEntityApi)this);
    }

    public /* synthetic */ MangoQuery gorm_tools_mango_api_QueryMangoEntityApitrait$super$getMangoQuery() {
        if (this instanceof GeneratedGroovyProxy) {
            return (MangoQuery)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getMangoQuery", (Object)new Object[0]), MangoQuery.class);
        }
        return (MangoQuery)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getMangoQuery"), MangoQuery.class);
    }

    @Traits.TraitBridge(traitClass=QueryMangoEntityApi.class, desc="(Lgorm/tools/mango/api/QueryArgs;Lgroovy/lang/Closure;)Ljava/util/List;")
    public List<Activity> queryList(QueryArgs param1, @DelegatesTo(genericTypeIndex=-1, strategy=0, type="", value=MangoDetachedCriteria.class, target="") Closure param2) {
        return QueryMangoEntityApi.Trait.Helper.queryList((QueryMangoEntityApi)this, (QueryArgs)param1, (Closure)param2);
    }

    public /* synthetic */ List<Activity> gorm_tools_mango_api_QueryMangoEntityApitrait$super$queryList(QueryArgs param0, Closure<Object> param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (List)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"queryList", (Object)new Object[]{param0, param1}), List.class);
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"queryList", (Object[])new Object[]{param0, param1}), List.class);
    }

    public MangoQuery gorm_tools_mango_api_QueryMangoEntityApi__mangoQuery$get() {
        return this.gorm_tools_mango_api_QueryMangoEntityApi__mangoQuery;
    }

    public MangoQuery gorm_tools_mango_api_QueryMangoEntityApi__mangoQuery$set(MangoQuery val) {
        MangoQuery mangoQuery;
        this.gorm_tools_mango_api_QueryMangoEntityApi__mangoQuery = mangoQuery = val;
        return mangoQuery;
    }

    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="(Lgorm/tools/async/AsyncService;)V")
    public void setAsyncService(AsyncService param1) {
        BulkableRepo.Trait.Helper.setAsyncService((BulkableRepo)this, (AsyncService)param1);
    }

    public /* synthetic */ void gorm_tools_repository_bulk_BulkableRepotrait$super$setAsyncService(AsyncService param0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setAsyncService", (Object)new Object[]{param0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"setAsyncService", (Object[])new Object[]{param0});
        }
    }

    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="(Ljava/lang/Object;Lgorm/tools/job/SyncJobContext;)Ljava/util/Map;")
    public Map buildSuccessMap(Activity param1, SyncJobContext param2) {
        return BulkableRepo.Trait.Helper.buildSuccessMap((BulkableRepo)this, (Object)param1, (SyncJobContext)param2);
    }

    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="(Ljava/util/List;Lgorm/tools/job/SyncJobContext;Z)Lyakworks/api/ApiResults;")
    public ApiResults doBulk(List<Map> param1, SyncJobContext param2, boolean param3) {
        return BulkableRepo.Trait.Helper.doBulk((BulkableRepo)this, param1, (SyncJobContext)param2, (boolean)param3);
    }

    public /* synthetic */ ApiResults gorm_tools_repository_bulk_BulkableRepotrait$super$doBulk(List<Map<Object, Object>> param0, SyncJobContext param1, boolean param2) {
        if (this instanceof GeneratedGroovyProxy) {
            return (ApiResults)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"doBulk", (Object)new Object[]{param0, param1, param2}), ApiResults.class);
        }
        return (ApiResults)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"doBulk", (Object[])new Object[]{param0, param1, param2}), ApiResults.class);
    }

    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="(Lgorm/tools/job/SyncJobService;)V")
    public void setSyncJobService(SyncJobService param1) {
        BulkableRepo.Trait.Helper.setSyncJobService((BulkableRepo)this, (SyncJobService)param1);
    }

    public /* synthetic */ void gorm_tools_repository_bulk_BulkableRepotrait$super$setSyncJobService(SyncJobService<Activity> param0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setSyncJobService", (Object)new Object[]{param0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"setSyncJobService", (Object[])new Object[]{param0});
        }
    }

    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="(Ljava/util/Map;Lgorm/tools/job/SyncJobContext;)Ljava/util/Map;")
    public Map buildErrorMap(Map param1, SyncJobContext param2) {
        return BulkableRepo.Trait.Helper.buildErrorMap((BulkableRepo)this, (Map)param1, (SyncJobContext)param2);
    }

    public /* synthetic */ Map<Object, Object> gorm_tools_repository_bulk_BulkableRepotrait$super$buildErrorMap(Map<Object, Object> param0, SyncJobContext param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Map)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"buildErrorMap", (Object)new Object[]{param0, param1}), Map.class);
        }
        return (Map)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"buildErrorMap", (Object[])new Object[]{param0, param1}), Map.class);
    }

    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="(Lgorm/tools/job/SyncJobContext;ZZLjava/util/Map;Lgorm/tools/repository/PersistArgs;)Ljava/util/Map;")
    public Map createOrUpdate(SyncJobContext param1, boolean param2, boolean param3, Map param4, PersistArgs param5) {
        return BulkableRepo.Trait.Helper.createOrUpdate((BulkableRepo)this, (SyncJobContext)param1, (boolean)param2, (boolean)param3, (Map)param4, (PersistArgs)param5);
    }

    public /* synthetic */ Map<Object, Object> gorm_tools_repository_bulk_BulkableRepotrait$super$createOrUpdate(SyncJobContext param0, boolean param1, boolean param2, Map<Object, Object> param3, PersistArgs param4) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Map)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"createOrUpdate", (Object)new Object[]{param0, param1, param2, param3, param4}), Map.class);
        }
        return (Map)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"createOrUpdate", (Object[])new Object[]{param0, param1, param2, param3, param4}), Map.class);
    }

    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="(Ljava/util/function/Supplier;Lgorm/tools/job/SyncJobContext;)Ljava/lang/Long;")
    public Long bulk(Supplier param1, SyncJobContext param2) {
        return BulkableRepo.Trait.Helper.bulk((BulkableRepo)this, (Supplier)param1, (SyncJobContext)param2);
    }

    public /* synthetic */ Long gorm_tools_repository_bulk_BulkableRepotrait$super$bulk(Supplier<Object> param0, SyncJobContext param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Long)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"bulk", (Object)new Object[]{param0, param1}), Long.class);
        }
        return (Long)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"bulk", (Object[])new Object[]{param0, param1}), Long.class);
    }

    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="(Lgorm/tools/job/SyncJobContext;Lyakworks/api/ApiResults;Ljava/lang/Long;)V")
    public void updateJobResults(SyncJobContext param1, ApiResults param2, Long param3) {
        BulkableRepo.Trait.Helper.updateJobResults((BulkableRepo)this, (SyncJobContext)param1, (ApiResults)param2, (Long)param3);
    }

    public /* synthetic */ void gorm_tools_repository_bulk_BulkableRepotrait$super$updateJobResults(SyncJobContext param0, ApiResults param1, Long param2) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"updateJobResults", (Object)new Object[]{param0, param1, param2});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"updateJobResults", (Object[])new Object[]{param0, param1, param2});
        }
    }

    public /* synthetic */ void gorm_tools_repository_bulk_BulkableRepotrait$super$setProblemHandler(ProblemHandler param0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setProblemHandler", (Object)new Object[]{param0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"setProblemHandler", (Object[])new Object[]{param0});
        }
    }

    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="()Lgorm/tools/job/SyncJobService;")
    public SyncJobService getSyncJobService() {
        return BulkableRepo.Trait.Helper.getSyncJobService((BulkableRepo)this);
    }

    public /* synthetic */ SyncJobService<Activity> gorm_tools_repository_bulk_BulkableRepotrait$super$getSyncJobService() {
        if (this instanceof GeneratedGroovyProxy) {
            return (SyncJobService)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getSyncJobService", (Object)new Object[0]), SyncJobService.class);
        }
        return (SyncJobService)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getSyncJobService"), SyncJobService.class);
    }

    @Generated
    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="(Ljava/util/List;Lgorm/tools/job/SyncJobContext;)Lyakworks/api/ApiResults;")
    public ApiResults doBulk(List<Map> param1, SyncJobContext param2) {
        return BulkableRepo.Trait.Helper.doBulk((BulkableRepo)this, param1, (SyncJobContext)param2);
    }

    public /* synthetic */ ApiResults gorm_tools_repository_bulk_BulkableRepotrait$super$doBulk(List<Map<Object, Object>> param0, SyncJobContext param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (ApiResults)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"doBulk", (Object)new Object[]{param0, param1}), ApiResults.class);
        }
        return (ApiResults)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"doBulk", (Object[])new Object[]{param0, param1}), ApiResults.class);
    }

    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="()Lgorm/tools/async/AsyncService;")
    public AsyncService getAsyncService() {
        return BulkableRepo.Trait.Helper.getAsyncService((BulkableRepo)this);
    }

    public /* synthetic */ AsyncService gorm_tools_repository_bulk_BulkableRepotrait$super$getAsyncService() {
        if (this instanceof GeneratedGroovyProxy) {
            return (AsyncService)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getAsyncService", (Object)new Object[0]), AsyncService.class);
        }
        return (AsyncService)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getAsyncService"), AsyncService.class);
    }

    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="(Ljava/lang/Object;Lgorm/tools/job/SyncJobContext;)Ljava/util/Map;")
    public Map createMetaMap(Activity param1, SyncJobContext param2) {
        return BulkableRepo.Trait.Helper.createMetaMap((BulkableRepo)this, (Object)param1, (SyncJobContext)param2);
    }

    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="(Ljava/util/List;Lgorm/tools/job/SyncJobArgs;)Ljava/lang/Long;")
    public Long bulk(List<Map> param1, SyncJobArgs param2) {
        return BulkableRepo.Trait.Helper.bulk((BulkableRepo)this, param1, (SyncJobArgs)param2);
    }

    public /* synthetic */ Long gorm_tools_repository_bulk_BulkableRepotrait$super$bulk(List<Map<Object, Object>> param0, SyncJobArgs param1) {
        if (this instanceof GeneratedGroovyProxy) {
            return (Long)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"bulk", (Object)new Object[]{param0, param1}), Long.class);
        }
        return (Long)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"bulk", (Object[])new Object[]{param0, param1}), Long.class);
    }

    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="(Lgorm/tools/beans/map/MetaMapEntityService;)V")
    public void setMetaMapEntityService(MetaMapEntityService param1) {
        BulkableRepo.Trait.Helper.setMetaMapEntityService((BulkableRepo)this, (MetaMapEntityService)param1);
    }

    public /* synthetic */ void gorm_tools_repository_bulk_BulkableRepotrait$super$setMetaMapEntityService(MetaMapEntityService param0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setMetaMapEntityService", (Object)new Object[]{param0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"setMetaMapEntityService", (Object[])new Object[]{param0});
        }
    }

    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="(Lgorm/tools/async/ParallelTools;)V")
    public void setParallelTools(ParallelTools param1) {
        BulkableRepo.Trait.Helper.setParallelTools((BulkableRepo)this, (ParallelTools)param1);
    }

    public /* synthetic */ void gorm_tools_repository_bulk_BulkableRepotrait$super$setParallelTools(ParallelTools param0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setParallelTools", (Object)new Object[]{param0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"setParallelTools", (Object[])new Object[]{param0});
        }
    }

    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="()Lgorm/tools/async/ParallelTools;")
    public ParallelTools getParallelTools() {
        return BulkableRepo.Trait.Helper.getParallelTools((BulkableRepo)this);
    }

    public /* synthetic */ ParallelTools gorm_tools_repository_bulk_BulkableRepotrait$super$getParallelTools() {
        if (this instanceof GeneratedGroovyProxy) {
            return (ParallelTools)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getParallelTools", (Object)new Object[0]), ParallelTools.class);
        }
        return (ParallelTools)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getParallelTools"), ParallelTools.class);
    }

    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="(Ljava/util/List;Lgorm/tools/job/SyncJobContext;)V")
    public void doBulkParallel(List<Map> param1, SyncJobContext param2) {
        BulkableRepo.Trait.Helper.doBulkParallel((BulkableRepo)this, param1, (SyncJobContext)param2);
    }

    public /* synthetic */ void gorm_tools_repository_bulk_BulkableRepotrait$super$doBulkParallel(List<Map<Object, Object>> param0, SyncJobContext param1) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"doBulkParallel", (Object)new Object[]{param0, param1});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"doBulkParallel", (Object[])new Object[]{param0, param1});
        }
    }

    public /* synthetic */ ProblemHandler gorm_tools_repository_bulk_BulkableRepotrait$super$getProblemHandler() {
        if (this instanceof GeneratedGroovyProxy) {
            return (ProblemHandler)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getProblemHandler", (Object)new Object[0]), ProblemHandler.class);
        }
        return (ProblemHandler)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getProblemHandler"), ProblemHandler.class);
    }

    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="()Lgorm/tools/beans/map/MetaMapEntityService;")
    public MetaMapEntityService getMetaMapEntityService() {
        return BulkableRepo.Trait.Helper.getMetaMapEntityService((BulkableRepo)this);
    }

    public /* synthetic */ MetaMapEntityService gorm_tools_repository_bulk_BulkableRepotrait$super$getMetaMapEntityService() {
        if (this instanceof GeneratedGroovyProxy) {
            return (MetaMapEntityService)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getMetaMapEntityService", (Object)new Object[0]), MetaMapEntityService.class);
        }
        return (MetaMapEntityService)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getMetaMapEntityService"), MetaMapEntityService.class);
    }

    @Generated
    @Traits.TraitBridge(traitClass=BulkableRepo.class, desc="(Lgorm/tools/job/SyncJobContext;Lyakworks/api/ApiResults;)V")
    public void updateJobResults(SyncJobContext param1, ApiResults param2) {
        BulkableRepo.Trait.Helper.updateJobResults((BulkableRepo)this, (SyncJobContext)param1, (ApiResults)param2);
    }

    public /* synthetic */ void gorm_tools_repository_bulk_BulkableRepotrait$super$updateJobResults(SyncJobContext param0, ApiResults param1) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"updateJobResults", (Object)new Object[]{param0, param1});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"updateJobResults", (Object[])new Object[]{param0, param1});
        }
    }

    public static Logger gorm_tools_repository_bulk_BulkableRepo__log$get() {
        return gorm_tools_repository_bulk_BulkableRepo__log;
    }

    public AsyncService gorm_tools_repository_bulk_BulkableRepo__asyncService$get() {
        return this.gorm_tools_repository_bulk_BulkableRepo__asyncService;
    }

    public SyncJobService gorm_tools_repository_bulk_BulkableRepo__syncJobService$get() {
        return this.gorm_tools_repository_bulk_BulkableRepo__syncJobService;
    }

    public ProblemHandler gorm_tools_repository_bulk_BulkableRepo__problemHandler$get() {
        return this.gorm_tools_repository_bulk_BulkableRepo__problemHandler;
    }

    public ParallelTools gorm_tools_repository_bulk_BulkableRepo__parallelTools$get() {
        return this.gorm_tools_repository_bulk_BulkableRepo__parallelTools;
    }

    public MetaMapEntityService gorm_tools_repository_bulk_BulkableRepo__metaMapEntityService$get() {
        return this.gorm_tools_repository_bulk_BulkableRepo__metaMapEntityService;
    }

    public ParallelTools gorm_tools_repository_bulk_BulkableRepo__parallelTools$set(ParallelTools val) {
        ParallelTools parallelTools;
        this.gorm_tools_repository_bulk_BulkableRepo__parallelTools = parallelTools = val;
        return parallelTools;
    }

    public MetaMapEntityService gorm_tools_repository_bulk_BulkableRepo__metaMapEntityService$set(MetaMapEntityService val) {
        MetaMapEntityService metaMapEntityService;
        this.gorm_tools_repository_bulk_BulkableRepo__metaMapEntityService = metaMapEntityService = val;
        return metaMapEntityService;
    }

    public ProblemHandler gorm_tools_repository_bulk_BulkableRepo__problemHandler$set(ProblemHandler val) {
        ProblemHandler problemHandler;
        this.gorm_tools_repository_bulk_BulkableRepo__problemHandler = problemHandler = val;
        return problemHandler;
    }

    public AsyncService gorm_tools_repository_bulk_BulkableRepo__asyncService$set(AsyncService val) {
        AsyncService asyncService;
        this.gorm_tools_repository_bulk_BulkableRepo__asyncService = asyncService = val;
        return asyncService;
    }

    public SyncJobService gorm_tools_repository_bulk_BulkableRepo__syncJobService$set(SyncJobService val) {
        SyncJobService syncJobService;
        this.gorm_tools_repository_bulk_BulkableRepo__syncJobService = syncJobService = val;
        return syncJobService;
    }

    public static Logger gorm_tools_repository_bulk_BulkableRepo__log$set(Logger val) {
        return null;
    }

    public PlatformTransactionManager getTransactionManager() {
        if (this.$transactionManager != null) {
            return this.$transactionManager;
        }
        return GormEnhancer.findSingleTransactionManager();
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        PlatformTransactionManager platformTransactionManager;
        this.$transactionManager = platformTransactionManager = transactionManager;
    }

    @Autowired(required=false)
    public void setTargetDatastore(Datastore ... datastores) {
        Datastore datastore;
        this.$targetDatastore = datastore = RuntimeSupport.findDefaultDatastore((Datastore[])datastores);
        if (RuntimeSupport.findDefaultDatastore((Datastore[])datastores) != null) {
            PlatformTransactionManager platformTransactionManager;
            this.$transactionManager = platformTransactionManager = ((TransactionCapableDatastore)ScriptBytecodeAdapter.castToType((Object)RuntimeSupport.findDefaultDatastore((Datastore[])datastores), TransactionCapableDatastore.class)).getTransactionManager();
        }
    }

    protected Datastore getTargetDatastore(String connectionName) {
        if (this.$targetDatastore != null) {
            return (Datastore)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodN(ActivityRepo.class, (Object)this.$targetDatastore, (String)"getDatastoreForConnection", (Object[])new Object[]{connectionName}), Datastore.class);
        }
        return (Datastore)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodN(ActivityRepo.class, (Object)GormEnhancer.findSingleDatastore(), (String)"getDatastoreForConnection", (Object[])new Object[]{connectionName}), Datastore.class);
    }

    protected Datastore getTargetDatastore() {
        if (this.$targetDatastore != null) {
            return this.$targetDatastore;
        }
        return GormEnhancer.findSingleDatastore();
    }

    protected Activity $tt__insertMassNote(List targets, String entityName, Org org, String body, TransactionStatus transactionStatus) {
        Reference entityName2 = new Reference((Object)entityName);
        Reference activity = new Reference((Object)new Activity());
        Org org2 = org;
        ((Activity)activity.get()).setOrg(org2);
        this.addNote((Activity)activity.get(), body);
        this.updateNameSummary((Activity)activity.get());
        String string = (String)entityName2.get();
        ((Activity)activity.get()).setSource(string);
        SourceType sourceType = SourceType.App;
        ((Activity)activity.get()).setSourceType(sourceType);
        ((Activity)activity.get()).persist();
        public final class __tt__insertMassNote_closure15
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference entityName;
            private /* synthetic */ Reference activity;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __tt__insertMassNote_closure15(Object _outerInstance, Object _thisObject, Reference entityName, Reference activity) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.entityName = reference2 = entityName;
                this.activity = reference = activity;
            }

            public Object doCall(Object target) {
                return ((ActivityRepo)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ActivityRepo.class)).getActivityLinkRepo().create((Long)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.getAt((Object)target, (String)"id"), Long.class), ShortTypeHandling.castToString((Object)this.entityName.get()), (Persistable)ScriptBytecodeAdapter.castToType((Object)this.activity.get(), Persistable.class));
            }

            @Generated
            public String getEntityName() {
                return ShortTypeHandling.castToString((Object)this.entityName.get());
            }

            @Generated
            public Activity getActivity() {
                return (Activity)ScriptBytecodeAdapter.castToType((Object)this.activity.get(), Activity.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __tt__insertMassNote_closure15.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((List)targets, (Closure)new __tt__insertMassNote_closure15(this, this, entityName2, activity));
        ((Activity)activity.get()).persist();
        return (Activity)activity.get();
    }

    /*
     * WARNING - void declaration
     */
    protected List $tt__insertMassActivity(List targets, Map activityData, String source, boolean newAttachments, TransactionStatus transactionStatus) {
        void var3_3;
        Reference activityData2 = new Reference((Object)activityData);
        Reference source2 = new Reference((Object)var3_3);
        Reference newAttachments2 = new Reference((Object)newAttachments);
        Reference createdActivities = new Reference((Object)((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class)));
        Reference attachments = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        List attachmentData = (List)ScriptBytecodeAdapter.asType((Map)activityData2.get() == null ? null : ((Map)activityData2.get()).get("attachments"), List.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)attachmentData)) {
            List<Attachment> list = this.attachmentRepo.createOrUpdate(attachmentData);
            attachments.set(list);
            if (ScriptBytecodeAdapter.compareEqual((Object)DefaultGroovyMethods.getAt((List)targets, (int)0).getClass().getSimpleName(), (Object)"Payment")) {
                public final class __tt__insertMassActivity_closure16
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference activityData;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public __tt__insertMassActivity_closure16(Object _outerInstance, Object _thisObject, Reference activityData) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.activityData = reference = activityData;
                    }

                    public Object doCall(Attachment att) {
                        String name = ShortTypeHandling.castToString(this.activityData.get() == null ? null : this.activityData.get().get("name"));
                        String string = name;
                        String string2 = ScriptBytecodeAdapter.compareGreaterThan((Object)(string != null ? Integer.valueOf(StringGroovyMethods.size((String)string)) : null), (Object)255) ? StringGroovyMethods.getAt((String)name, (IntRange)new IntRange(true, 0, 254)) : name;
                        att.setDescription(string2);
                        return att.persist();
                    }

                    public Object call(Attachment att) {
                        return this.doCall(att);
                    }

                    @Generated
                    public Map getActivityData() {
                        return (Map)ScriptBytecodeAdapter.castToType((Object)this.activityData.get(), Map.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != __tt__insertMassActivity_closure16.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                DefaultGroovyMethods.each((List)((List)attachments.get()), (Closure)new __tt__insertMassActivity_closure16(this, this, activityData2));
            }
        }
        Reference activities = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        public final class __tt__insertMassActivity_closure17
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference createdActivities;
            private /* synthetic */ Reference attachments;
            private /* synthetic */ Reference newAttachments;
            private /* synthetic */ Reference activityData;
            private /* synthetic */ Reference source;
            private /* synthetic */ Reference activities;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __tt__insertMassActivity_closure17(Object _outerInstance, Object _thisObject, Reference createdActivities, Reference attachments, Reference newAttachments, Reference activityData, Reference source, Reference activities) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                Reference reference6;
                this.createdActivities = reference6 = createdActivities;
                this.attachments = reference5 = attachments;
                this.newAttachments = reference4 = newAttachments;
                this.activityData = reference3 = activityData;
                this.source = reference2 = source;
                this.activities = reference = activities;
            }

            public Object doCall(Object target, Object i) {
                String entityName = target.getClass().getSimpleName();
                Org org = (Org)ScriptBytecodeAdapter.asType((Object)(ScriptBytecodeAdapter.compareEqual((Object)entityName, (Object)"ArTran") ? DefaultGroovyMethods.getAt((Object)DefaultGroovyMethods.getAt((Object)target, (String)"customer"), (String)"org") : DefaultGroovyMethods.getAt((Object)target, (String)"org")), Org.class);
                Activity activity = null;
                if (DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.getAt((Map)((Map)ScriptBytecodeAdapter.castToType((Object)this.createdActivities.get(), Map.class)), (Object)org.getId())) && ScriptBytecodeAdapter.compareNotEqual((Object)entityName, (Object)"Payment")) {
                    Object object = DefaultGroovyMethods.getAt((Map)((Map)ScriptBytecodeAdapter.castToType((Object)this.createdActivities.get(), Map.class)), (Object)org.getId());
                    activity = (Activity)ScriptBytecodeAdapter.castToType((Object)object, Activity.class);
                } else {
                    Activity activity2;
                    List copiedAttachments = (List)ScriptBytecodeAdapter.castToType((Object)this.attachments.get(), List.class);
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)i, (Object)0) && DefaultTypeTransformation.booleanUnbox((Object)this.newAttachments.get())) {
                        List list;
                        public final class _closure25
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure25(Object _outerInstance, Object _thisObject) {
                                super(_outerInstance, _thisObject);
                            }

                            public Object doCall(Object it) {
                                return ((ActivityRepo)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ActivityRepo.class)).getAttachmentRepo().copy((Attachment)ScriptBytecodeAdapter.asType((Object)it, Attachment.class));
                            }

                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            public Object call() {
                                return this.doCall(null);
                            }

                            @Generated
                            public Object doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure25.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        copiedAttachments = list = DefaultGroovyMethods.collect((Iterable)((Iterable)ScriptBytecodeAdapter.castToType((Object)this.attachments.get(), Iterable.class)), (Closure)new _closure25((Object)this, this.getThisObject()));
                    }
                    activity = activity2 = ((ActivityRepo)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ActivityRepo.class)).createActivity(DefaultGroovyMethods.toString(this.activityData.get().get("name")), org, (Map)ScriptBytecodeAdapter.castToType(this.activityData.get().get("task"), Map.class), copiedAttachments, entityName, ShortTypeHandling.castToString((Object)this.source.get()));
                    Activity activity3 = activity;
                    ScriptBytecodeAdapter.invokeMethodN(__tt__insertMassActivity_closure17.class, (Object)this.createdActivities.get(), (String)"putAt", (Object[])new Object[]{ScriptBytecodeAdapter.createPojoWrapper((Object)org.getId(), Long.class), activity3});
                }
                Long linkedId = (Long)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.getAt((Object)target, (String)"id"), Long.class);
                ((ActivityRepo)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ActivityRepo.class)).getActivityLinkRepo().create(linkedId, entityName, (Persistable)activity);
                return ((List)this.activities.get()).add(activity);
            }

            public Object call(Object target, Object i) {
                return this.doCall(target, i);
            }

            @Generated
            public Map getCreatedActivities() {
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.createdActivities.get(), Map.class);
            }

            @Generated
            public List getAttachments() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.attachments.get(), List.class);
            }

            @Generated
            public boolean getNewAttachments() {
                return DefaultTypeTransformation.booleanUnbox((Object)this.newAttachments.get());
            }

            @Generated
            public Map getActivityData() {
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.activityData.get(), Map.class);
            }

            @Generated
            public String getSource() {
                return ShortTypeHandling.castToString((Object)this.source.get());
            }

            @Generated
            public List getActivities() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.activities.get(), List.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __tt__insertMassActivity_closure17.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.eachWithIndex((List)targets, (Closure)new __tt__insertMassActivity_closure17(this, this, createdActivities, attachments, newAttachments2, activityData2, source2, activities));
        return (List)activities.get();
    }

    protected Activity $tt__createActivity(String text, Org org, Map task, List<Attachment> attachments, String entityName, String source, TransactionStatus transactionStatus) {
        Activity activity = new Activity();
        Org org2 = org;
        activity.setOrg(org2);
        String string = text;
        activity.setName(string);
        String string2 = entityName;
        activity.setSource(string2);
        SourceType sourceType = SourceType.App;
        activity.setSourceType(sourceType);
        Reference activity2 = new Reference((Object)activity);
        this.generateId((Persistable)((Activity)activity2.get()));
        if (DefaultTypeTransformation.booleanUnbox((Object)task)) {
            Task task2 = this.createActivityTask(task);
            ((Activity)activity2.get()).setTask(task2);
            Activity.Kind kind = ((Activity)activity2.get()).getTask().getTaskType().getKind();
            ((Activity)activity2.get()).setKind(kind);
        } else {
            this.addNote((Activity)activity2.get(), text);
            this.updateNameSummary((Activity)activity2.get());
        }
        List<Attachment> list = attachments;
        public final class __tt__createActivity_closure18
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference activity;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __tt__createActivity_closure18(Object _outerInstance, Object _thisObject, Reference activity) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.activity = reference = activity;
            }

            public Object doCall(Object attachment) {
                return AttachmentLink.create((Persistable)ScriptBytecodeAdapter.castToType((Object)this.activity.get(), Persistable.class), (Attachment)ScriptBytecodeAdapter.castToType((Object)attachment, Attachment.class));
            }

            @Generated
            public Activity getActivity() {
                return (Activity)ScriptBytecodeAdapter.castToType((Object)this.activity.get(), Activity.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __tt__createActivity_closure18.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        List list2 = list != null ? DefaultGroovyMethods.each(list, (Closure)new __tt__createActivity_closure18(this, this, activity2)) : null;
        return ((Activity)activity2.get()).persist();
    }

    protected Task $tt__createActivityTask(Map taskData, TransactionStatus transactionStatus) {
        TaskType taskType = TaskType.get((Long)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.getAt(taskData.get("taskType"), (String)"id"), Long.class));
        Task task = new Task();
        task.bind(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"taskType", taskType, "userId", (Long)ScriptBytecodeAdapter.asType(DefaultTypeTransformation.booleanUnbox(taskData.get("user")) ? DefaultGroovyMethods.getAt(taskData.get("user"), (String)"id") : null, Long.class), "dueDate", taskData.get("dueDate"), "priority", taskData.get("priority"), "state", DefaultTypeTransformation.booleanUnbox(taskData.get("state")) ? taskData.get("state") : Task.State.Open, "status", TaskStatus.getOPEN()}));
        return task;
    }

    protected Activity $tt__createTodo(Org org, Long userId, String name, String linkedEntity, List<Long> linkedIds, LocalDateTime dueDate, TransactionStatus transactionStatus) {
        Activity activity = this.create(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"org", org, "name", name, "kind", Activity.Kind.Todo}));
        if (DefaultTypeTransformation.booleanUnbox(linkedIds)) {
            Long linkedId = null;
            Iterator<Long> iterator = linkedIds.iterator();
            while (iterator.hasNext()) {
                String string;
                Long l;
                Activity activity2;
                linkedId = (Long)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Long.class);
                ActivityLink activityLink = new ActivityLink();
                activityLink.setActivity(activity2);
                activityLink.setLinkedId(l);
                activityLink.setLinkedEntity(string);
                ActivityLink activityLink2 = activityLink;
                activityLink2.persist();
            }
        }
        Task task = new Task();
        TaskType taskType = TaskType.getTODO();
        task.setTaskType(taskType);
        Long l = userId;
        task.setUserId(l);
        LocalDateTime localDateTime = dueDate;
        task.setDueDate(localDateTime);
        TaskStatus taskStatus = TaskStatus.getOPEN();
        task.setStatus(taskStatus);
        Task task2 = task;
        activity.setTask(task2);
        activity.persist();
        return activity;
    }

    protected boolean $tt__hasActivityWithAttachments(Persistable entity, TransactionStatus transactionStatus) {
        DetachedCriteria<Activity> laQuery = this.linkedActivityCriteria(entity);
        public final class __tt__hasActivityWithAttachments_closure19
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __tt__hasActivityWithAttachments_closure19(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                ((AbstractDetachedCriteria)this.getDelegate()).setAlias("attachLink");
                ((MangoDetachedCriteria)this.getDelegate()).eqProperty("linkedId", "act.id");
                return ((MangoDetachedCriteria)this.getDelegate()).eq("linkedEntity", (Object)"Activity");
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __tt__hasActivityWithAttachments_closure19.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        MangoDetachedCriteria<AttachmentLink> attachExists = AttachmentLink.query(new __tt__hasActivityWithAttachments_closure19(this, this));
        return DefaultTypeTransformation.booleanUnbox((Object)laQuery.exists((QueryableCriteria)attachExists.id()).count());
    }

    protected List $tt__listByLinked(Long linkedId, String linkedEntity, Map params, TransactionStatus transactionStatus) {
        Pager pager = new Pager(params);
        DetachedCriteria<Activity> crit = this.getActivityByLinkedCriteria(linkedId, linkedEntity, DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.asType(params.get("custArea"), Boolean.TYPE)));
        crit.order("createdDate", "desc");
        List activityList = crit.list(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"max", pager.getMax(), "offset", pager.getOffset()}));
        return activityList;
    }

    protected Activity $tt__copy(Activity fromAct, Activity toAct, TransactionStatus transactionStatus) {
        List<Attachment> list;
        Reference toAct2 = new Reference((Object)toAct);
        if (fromAct == null) {
            return (Activity)ScriptBytecodeAdapter.castToType(null, Activity.class);
        }
        GormUtils.copyDomain((Object)((Activity)toAct2.get()), (Object)fromAct, (Map)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"createdBy", DefaultGroovyMethods.getAt((Object)fromAct, (String)"createdBy"), "editedBy", DefaultGroovyMethods.getAt((Object)fromAct, (String)"editedBy")}));
        Object object = GormUtils.copyDomain(ActivityNote.class, (Object)fromAct.getNote(), (Map)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"activity", (Activity)toAct2.get()}), (boolean)false);
        ((Activity)toAct2.get()).setNote((ActivityNote)ScriptBytecodeAdapter.castToType((Object)object, ActivityNote.class));
        Object object2 = GormUtils.copyDomain(Task.class, (Object)fromAct.getTask(), (Map)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"activity", (Activity)toAct2.get()}), (boolean)false);
        ((Activity)toAct2.get()).setTask((Task)ScriptBytecodeAdapter.castToType((Object)object2, Task.class));
        if (DefaultTypeTransformation.booleanUnbox((Object)fromAct.getTemplate())) {
            Attachment attachment = this.attachmentRepo.copy(fromAct.getTemplate());
            ((Activity)toAct2.get()).setTemplate(attachment);
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)((Activity)toAct2.get()).getId())) {
            Long l = this.generateId();
            ((Activity)toAct2.get()).setId(l);
        }
        public final class __tt__copy_closure20
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference toAct;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __tt__copy_closure20(Object _outerInstance, Object _thisObject, Reference toAct) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.toAct = reference = toAct;
            }

            public Object doCall(Attachment attachment) {
                Attachment attachCopy = ((ActivityRepo)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ActivityRepo.class)).getAttachmentRepo().copy(attachment);
                if (DefaultTypeTransformation.booleanUnbox((Object)attachCopy)) {
                    return AttachmentLink.create((Persistable)ScriptBytecodeAdapter.castToType((Object)this.toAct.get(), Persistable.class), attachCopy);
                }
                return null;
            }

            public Object call(Attachment attachment) {
                return this.doCall(attachment);
            }

            @Generated
            public Activity getToAct() {
                return (Activity)ScriptBytecodeAdapter.castToType((Object)this.toAct.get(), Activity.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __tt__copy_closure20.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        List list2 = (list = fromAct.getAttachments()) != null ? DefaultGroovyMethods.each(list, (Closure)new __tt__copy_closure20(this, this, toAct2)) : null;
        ActivityContact.getRepo().copyRelated((Persistable)fromAct, (Persistable)((Activity)toAct2.get()));
        this.activityLinkRepo.copyLinked((Persistable)fromAct, (Persistable)((Activity)toAct2.get()));
        ((Activity)toAct2.get()).persist();
        TagLink.getRepo().copyTags((Persistable)fromAct, (Persistable)((Activity)toAct2.get()));
        return (Activity)toAct2.get();
    }

    protected Result $tt__copyToOrg(Org fromOrg, Org toOrg, TransactionStatus transactionStatus) {
        Reference toOrg2 = new Reference((Object)toOrg);
        Reference results = new Reference((Object)ApiResults.OK());
        List<Activity> activities = Activity.findAllWhere(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"org", fromOrg}));
        public final class __tt__copyToOrg_closure21
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference toOrg;
            private /* synthetic */ Reference results;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __tt__copyToOrg_closure21(Object _outerInstance, Object _thisObject, Reference toOrg, Reference results) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.toOrg = reference2 = toOrg;
                this.results = reference = results;
            }

            public Object doCall(Activity activity) {
                block8: {
                    ActivityRepo activityRepo = (ActivityRepo)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ActivityRepo.class);
                    Activity activity2 = new Activity();
                    Object object = this.toOrg.get();
                    activity2.setOrg((Org)ScriptBytecodeAdapter.castToType((Object)object, Org.class));
                    Activity copy = activityRepo.copy(activity, activity2);
                    if (!DefaultTypeTransformation.booleanUnbox((Object)copy)) break block8;
                    LinkedHashMap queryParams = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"edDate", DefaultGroovyMethods.getAt((Object)activity, (String)"editedDate"), "crDate", DefaultGroovyMethods.getAt((Object)activity, (String)"createdDate"), "newid", copy.getId()}), LinkedHashMap.class);
                    Integer n = Activity.executeUpdate((CharSequence)"update Activity act set act.editedDate=:edDate, act.createdDate=:crDate where act.id=:newid ", queryParams);
                    return n;
                }
                Object var7_7 = null;
                try {
                    return var7_7;
                }
                catch (Exception e) {
                    List list = DefaultGroovyMethods.leftShift((List)((List)ScriptBytecodeAdapter.castToType((Object)this.results.get(), List.class)), (Object)((ActivityRepo)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ActivityRepo.class)).getProblemHandler().handleException((Throwable)ScriptBytecodeAdapter.castToType((Object)e, Throwable.class)));
                    return list;
                }
            }

            public Object call(Activity activity) {
                return this.doCall(activity);
            }

            @Generated
            public Org getToOrg() {
                return (Org)ScriptBytecodeAdapter.castToType((Object)this.toOrg.get(), Org.class);
            }

            @Generated
            public ApiResults getResults() {
                return (ApiResults)ScriptBytecodeAdapter.castToType((Object)this.results.get(), ApiResults.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __tt__copyToOrg_closure21.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(activities, (Closure)new __tt__copyToOrg_closure21(this, this, toOrg2, results));
        return (ApiResults)results.get();
    }

    public static /* synthetic */ ActivityLinkRepo pfaccess$0(ActivityRepo $that) {
        return $that.getActivityLinkRepo();
    }

    public static /* synthetic */ AttachmentRepo pfaccess$1(ActivityRepo $that) {
        return $that.getAttachmentRepo();
    }

    public static /* synthetic */ SecService pfaccess$2(ActivityRepo $that) {
        return $that.getSecService();
    }

    public static /* synthetic */ ProblemHandler pfaccess$3(ActivityRepo $that) {
        return $that.getProblemHandler();
    }

    @Generated
    public ActivityNote addNote(Activity act, String body) {
        return this.addNote(act, body, "plain");
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @Generated
    public List<Activity> insertMassActivity(List targets, Map activityData, String source) {
        void var3_3;
        void var2_2;
        Reference targets2 = new Reference((Object)targets);
        Reference activityData2 = new Reference((Object)var2_2);
        Reference source2 = new Reference((Object)var3_3);
        return this.insertMassActivity((List)targets2.get(), (Map)activityData2.get(), (String)source2.get(), false);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @Generated
    public List<Activity> insertMassActivity(List targets, Map activityData) {
        void var2_2;
        Reference targets2 = new Reference((Object)targets);
        Reference activityData2 = new Reference((Object)var2_2);
        return this.insertMassActivity((List)targets2.get(), (Map)activityData2.get(), null, false);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @Generated
    public Activity createActivity(String text, Org org, Map task, List<Attachment> attachments, String entityName) {
        void var3_3;
        void var2_2;
        Reference text2 = new Reference((Object)text);
        Reference org2 = new Reference((Object)var2_2);
        Reference task2 = new Reference((Object)var3_3);
        Reference attachments2 = new Reference(attachments);
        Reference entityName2 = new Reference((Object)entityName);
        return this.createActivity((String)text2.get(), (Org)org2.get(), (Map)task2.get(), (List)attachments2.get(), (String)entityName2.get(), null);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @Generated
    public Activity createTodo(Org org, Long userId, String name, String linkedEntity, List<Long> linkedIds) {
        void var3_3;
        void var2_2;
        Reference org2 = new Reference((Object)org);
        Reference userId2 = new Reference((Object)var2_2);
        Reference name2 = new Reference((Object)var3_3);
        Reference linkedEntity2 = new Reference((Object)linkedEntity);
        Reference linkedIds2 = new Reference(linkedIds);
        return this.createTodo((Org)org2.get(), (Long)userId2.get(), (String)name2.get(), (String)linkedEntity2.get(), (List)linkedIds2.get(), LocalDateTime.now());
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @Generated
    public Activity createTodo(Org org, Long userId, String name, String linkedEntity) {
        void var3_3;
        void var2_2;
        Reference org2 = new Reference((Object)org);
        Reference userId2 = new Reference((Object)var2_2);
        Reference name2 = new Reference((Object)var3_3);
        Reference linkedEntity2 = new Reference((Object)linkedEntity);
        return this.createTodo((Org)org2.get(), (Long)userId2.get(), (String)name2.get(), (String)linkedEntity2.get(), null, LocalDateTime.now());
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @Generated
    public Activity createTodo(Org org, Long userId, String name) {
        void var3_3;
        void var2_2;
        Reference org2 = new Reference((Object)org);
        Reference userId2 = new Reference((Object)var2_2);
        Reference name2 = new Reference((Object)var3_3);
        return this.createTodo((Org)org2.get(), (Long)userId2.get(), (String)name2.get(), null, null, LocalDateTime.now());
    }

    @Generated
    public DetachedCriteria<Activity> linkedActivityCriteria(Persistable linkedEntity) {
        Reference linkedEntity2 = new Reference((Object)linkedEntity);
        return this.linkedActivityCriteria((Persistable)linkedEntity2.get(), null);
    }

    /*
     * WARNING - void declaration
     */
    @Generated
    public DetachedCriteria<Activity> getActivityByLinkedCriteria(Long linkedId, String linkedEntity) {
        void var2_2;
        Reference linkedId2 = new Reference((Object)linkedId);
        Reference linkedEntity2 = new Reference((Object)var2_2);
        return this.getActivityByLinkedCriteria((Long)linkedId2.get(), (String)linkedEntity2.get(), false);
    }

    /*
     * WARNING - void declaration
     */
    @Generated
    protected List $tt__insertMassActivity(List targets, Map activityData, String source, TransactionStatus transactionStatus) {
        void var3_3;
        Reference activityData2 = new Reference((Object)activityData);
        Reference source2 = new Reference((Object)var3_3);
        return this.$tt__insertMassActivity(targets, (Map)activityData2.get(), (String)source2.get(), false, transactionStatus);
    }

    @Generated
    protected List $tt__insertMassActivity(List targets, Map activityData, TransactionStatus transactionStatus) {
        Reference activityData2 = new Reference((Object)activityData);
        return this.$tt__insertMassActivity(targets, (Map)activityData2.get(), null, false, transactionStatus);
    }

    @Generated
    protected Activity $tt__createActivity(String text, Org org, Map task, List<Attachment> attachments, String entityName, TransactionStatus transactionStatus) {
        return this.$tt__createActivity(text, org, task, attachments, entityName, null, transactionStatus);
    }

    @Generated
    protected Activity $tt__createTodo(Org org, Long userId, String name, String linkedEntity, List<Long> linkedIds, TransactionStatus transactionStatus) {
        return this.$tt__createTodo(org, userId, name, linkedEntity, linkedIds, LocalDateTime.now(), transactionStatus);
    }

    @Generated
    protected Activity $tt__createTodo(Org org, Long userId, String name, String linkedEntity, TransactionStatus transactionStatus) {
        return this.$tt__createTodo(org, userId, name, linkedEntity, null, LocalDateTime.now(), transactionStatus);
    }

    @Generated
    protected Activity $tt__createTodo(Org org, Long userId, String name, TransactionStatus transactionStatus) {
        return this.$tt__createTodo(org, userId, name, null, null, LocalDateTime.now(), transactionStatus);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ActivityRepo.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    @Generated
    public ActivityLinkRepo getActivityLinkRepo() {
        return this.activityLinkRepo;
    }

    @Generated
    public void setActivityLinkRepo(ActivityLinkRepo activityLinkRepo) {
        this.activityLinkRepo = activityLinkRepo;
    }

    @Generated
    public AttachmentRepo getAttachmentRepo() {
        return this.attachmentRepo;
    }

    @Generated
    public void setAttachmentRepo(AttachmentRepo attachmentRepo) {
        this.attachmentRepo = attachmentRepo;
    }

    @Generated
    public SecService getSecService() {
        return this.secService;
    }

    @Generated
    public void setSecService(SecService secService) {
        this.secService = secService;
    }

    @Generated
    public ProblemHandler getProblemHandler() {
        return this.problemHandler;
    }

    @Generated
    public void setProblemHandler(ProblemHandler problemHandler) {
        this.problemHandler = problemHandler;
    }

    @Generated
    public List<String> getToOneAssociations() {
        return this.toOneAssociations;
    }

    @Generated
    public void setToOneAssociations(List<String> list) {
        this.toOneAssociations = list;
    }
}

