/*
 * Decompiled with CFR 0.152.
 */
package yakworks.rally.attachment;

import grails.plugin.viewtools.AppResourceLoader;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.FileNotFoundException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import yakworks.rally.attachment.model.Attachment;

@Service
@Lazy
public class AttachmentSupport
implements GroovyObject {
    public static final String ATTACHMENTS_LOCATION_KEY = "attachments.location";
    @Autowired(required=false)
    private AppResourceLoader appResourceLoader;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public AttachmentSupport() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public Path createFileFromTempFile(Long id, String fileName, String tempFileName, String locationKey) {
        Path attachmentFile = this.getAttachmentsPath(id, fileName, locationKey);
        Path tempFile = this.getTempPath().resolve(tempFileName);
        if (!Files.exists(tempFile, new LinkOption[0])) {
            throw (Throwable)new FileNotFoundException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{tempFile}, new String[]{"Could not find temp file: ", ""})));
        }
        return Files.move(tempFile, attachmentFile, new CopyOption[0]);
    }

    public Path createFileFromBytes(Long id, String fileName, byte[] bytes, String locationKey) {
        Path attachmentFile = this.getAttachmentsPath(id, fileName, locationKey);
        return Files.write(attachmentFile, bytes, new OpenOption[0]);
    }

    public Path createFileFromSource(Long id, String fileName, Path sourceFile, String locationKey) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)fileName)) {
            String string;
            fileName = string = sourceFile.getFileName().toString();
        }
        Path attachmentFile = this.getAttachmentsPath(id, fileName, locationKey);
        return Files.copy(sourceFile, attachmentFile, new CopyOption[0]);
    }

    public Path getAttachmentsPath(Long id, String fileName, String locationKey) {
        String attachFileName = AttachmentSupport.concatFileNameId(fileName, id);
        return this.getAttachmentsPath(locationKey).resolve(attachFileName);
    }

    public Path getAttachmentsPath(String locationKey) {
        Path rootPath = this.appResourceLoader.getLocation(locationKey).toPath();
        Path attachmentPath = rootPath.resolve(AttachmentSupport.getMonthDir());
        if (!Files.exists(attachmentPath, new LinkOption[0])) {
            Files.createDirectories(attachmentPath, new FileAttribute[0]);
        }
        return attachmentPath;
    }

    public String getRelativePath(Path file, String locationKey) {
        Path rootPath = this.appResourceLoader.getLocation(locationKey).toPath();
        Path relativePath = rootPath.relativize(file);
        return relativePath.toString();
    }

    public Path getTempPath() {
        return this.appResourceLoader.getTempDir().toPath();
    }

    public Path createTempFile(String fileName, Object data) {
        return this.appResourceLoader.createTempFile(fileName, data).toPath();
    }

    public Path getFile(String location, String locationKey) {
        Path rootPath = this.appResourceLoader.getLocation(locationKey).toPath();
        Path attachmentPath = rootPath.resolve(location);
        return attachmentPath;
    }

    public boolean deleteFile(String location, String locationKey) {
        Path attachedFile = this.getFile(location, locationKey);
        if (DefaultTypeTransformation.booleanUnbox((Object)attachedFile)) {
            return Files.deleteIfExists(attachedFile);
        }
        return DefaultTypeTransformation.booleanUnbox(null);
    }

    public Resource getResource(Attachment attachment) {
        Object v0;
        String string;
        Path path = this.getFile(attachment.getLocation(), DefaultTypeTransformation.booleanUnbox((Object)(string = attachment.getLocationKey())) ? string : ATTACHMENTS_LOCATION_KEY);
        if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{path, Files.exists(path, new LinkOption[0]) ? "exists." : "does not exist."}, new String[]{"File location is ", " which ", ""})));
            v0 = null;
        } else {
            v0 = null;
        }
        return new FileSystemResource(path);
    }

    public String getDownloadUrl(Attachment attachment) {
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{attachment.getId()}, new String[]{"/attachment/download/", ""}));
    }

    public static String getMonthDir() {
        return LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM"));
    }

    public static String concatFileNameId(String fileName, Long id) {
        String extension = FilenameUtils.getExtension((String)fileName);
        if (DefaultTypeTransformation.booleanUnbox((Object)extension)) {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{extension}, new String[]{".", ""});
            extension = ShortTypeHandling.castToString((Object)gStringImpl);
        }
        String baseName = FilenameUtils.getBaseName((String)fileName);
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{baseName, id, extension}, new String[]{"", "_", "", ""}));
    }

    public static Map mergeMultipartFileParams(MultipartFile multipartFile, Map params) {
        Object v = params.get("name");
        Object object = DefaultTypeTransformation.booleanUnbox(v) ? v : multipartFile.getOriginalFilename();
        ScriptBytecodeAdapter.invokeMethodN(AttachmentSupport.class, (Object)params, (String)"putAt", (Object[])new Object[]{"name", object});
        String string = multipartFile.getContentType();
        ScriptBytecodeAdapter.invokeMethodN(AttachmentSupport.class, (Object)params, (String)"putAt", (Object[])new Object[]{"mimeType", string});
        byte[] byArray = multipartFile.getBytes();
        ScriptBytecodeAdapter.invokeMethodN(AttachmentSupport.class, (Object)params, (String)"putAt", (Object[])new Object[]{"bytes", byArray});
        String string2 = FilenameUtils.getExtension((String)multipartFile.getOriginalFilename());
        ScriptBytecodeAdapter.invokeMethodN(AttachmentSupport.class, (Object)params, (String)"putAt", (Object[])new Object[]{"extension", string2});
        return params;
    }

    @Generated
    public Path createFileFromTempFile(Long id, String fileName, String tempFileName) {
        return this.createFileFromTempFile(id, fileName, tempFileName, ATTACHMENTS_LOCATION_KEY);
    }

    @Generated
    public Path createFileFromBytes(Long id, String fileName, byte ... bytes) {
        return this.createFileFromBytes(id, fileName, bytes, ATTACHMENTS_LOCATION_KEY);
    }

    @Generated
    public Path createFileFromSource(Long id, String fileName, Path sourceFile) {
        return this.createFileFromSource(id, fileName, sourceFile, ATTACHMENTS_LOCATION_KEY);
    }

    @Generated
    public Path getAttachmentsPath(Long id, String fileName) {
        return this.getAttachmentsPath(id, fileName, ATTACHMENTS_LOCATION_KEY);
    }

    @Generated
    public Path getAttachmentsPath() {
        return this.getAttachmentsPath(ATTACHMENTS_LOCATION_KEY);
    }

    @Generated
    public String getRelativePath(Path file) {
        return this.getRelativePath(file, ATTACHMENTS_LOCATION_KEY);
    }

    @Generated
    public Path getFile(String location) {
        return this.getFile(location, ATTACHMENTS_LOCATION_KEY);
    }

    @Generated
    public boolean deleteFile(String location) {
        return this.deleteFile(location, ATTACHMENTS_LOCATION_KEY);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AttachmentSupport.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"yakworks.rally.attachment.AttachmentSupport");
    }

    @Generated
    public AppResourceLoader getAppResourceLoader() {
        return this.appResourceLoader;
    }

    @Generated
    public void setAppResourceLoader(AppResourceLoader appResourceLoader) {
        this.appResourceLoader = appResourceLoader;
    }
}

