/*
 * Decompiled with CFR 0.152.
 */
package yakworks.rally.orgs.repo;

import gorm.tools.databinding.BindAction;
import gorm.tools.model.Persistable;
import gorm.tools.model.SourceType;
import gorm.tools.problem.ValidationProblem;
import gorm.tools.repository.GormRepo;
import gorm.tools.repository.PersistArgs;
import gorm.tools.repository.events.AfterRemoveEvent;
import gorm.tools.repository.events.BeforeBindEvent;
import gorm.tools.repository.events.BeforeRemoveEvent;
import gorm.tools.repository.events.RepoListener;
import gorm.tools.repository.model.LongIdGormRepo;
import gorm.tools.validation.Rejector;
import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.datastore.gorm.GormValidateable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.validation.Errors;
import yakworks.rally.orgs.OrgMemberService;
import yakworks.rally.orgs.model.Contact;
import yakworks.rally.orgs.model.Location;
import yakworks.rally.orgs.model.Org;
import yakworks.rally.orgs.model.OrgSource;
import yakworks.rally.orgs.model.OrgType;
import yakworks.rally.orgs.repo.ContactRepo;
import yakworks.rally.orgs.repo.LocationRepo;
import yakworks.rally.orgs.repo.OrgSourceRepo;
import yakworks.rally.orgs.repo.OrgTagRepo;

public abstract class AbstractOrgRepo
extends LongIdGormRepo<Org> {
    @Autowired(required=false)
    private LocationRepo locationRepo;
    @Autowired(required=false)
    private ContactRepo contactRepo;
    @Autowired(required=false)
    private OrgTagRepo orgTagRepo;
    @Autowired(required=false)
    private OrgSourceRepo orgSourceRepo;
    @Autowired(required=false)
    private OrgMemberService orgMemberService;
    private List<String> toOneAssociations;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    @Generated
    public AbstractOrgRepo() {
        List list;
        this.toOneAssociations = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{"flex", "info", "calc", "member"});
    }

    @RepoListener
    public void beforeValidate(Org org, Errors errors) {
        if (org.isNew()) {
            Rejector.validateNotNull((GormValidateable)org, (Errors)errors, (String)"type");
        }
    }

    @RepoListener
    public void beforeBind(Org org, Map data, BeforeBindEvent be) {
        if (be.isBindCreate()) {
            OrgType orgType = this.getOrgTypeFromData(data);
            org.setType(orgType);
            if (DefaultTypeTransformation.booleanUnbox(data.get("id"))) {
                Long l = (Long)ScriptBytecodeAdapter.asType(data.get("id"), Long.class);
                org.setId(l);
            } else {
                this.generateId((Persistable)org);
            }
        }
    }

    public void doBeforePersistWithData(Org org, PersistArgs args) {
        Object v;
        Map data = args.getData();
        if (ScriptBytecodeAdapter.compareEqual((Object)args.getBindAction(), (Object)BindAction.Create)) {
            this.verifyNumAndOrgSource(org, data);
            this.orgMemberService.setupMember(org, (Map)ScriptBytecodeAdapter.asType(data.remove("member"), Map.class));
        }
        if (DefaultTypeTransformation.booleanUnbox(data.get("location"))) {
            this.createOrUpdatePrimaryLocation(org, (Map)ScriptBytecodeAdapter.asType(data.get("location"), Map.class));
        }
        Object contactData = DefaultTypeTransformation.booleanUnbox(v = data.get("contact")) ? v : data.get("keyContact");
        if (DefaultTypeTransformation.booleanUnbox(contactData)) {
            this.createOrUpdatePrimaryContact(org, (Map)ScriptBytecodeAdapter.asType(contactData, Map.class));
        }
    }

    public void doAfterPersistWithData(Org org, PersistArgs args) {
        Map data = args.getData();
        if (DefaultTypeTransformation.booleanUnbox(data.get("locations"))) {
            this.persistManyList(org, (GormRepo)Location.getRepo(), (List)ScriptBytecodeAdapter.asType(data.get("locations"), List.class));
        }
        if (DefaultTypeTransformation.booleanUnbox(data.get("contacts"))) {
            this.persistManyList(org, (GormRepo)Contact.getRepo(), (List)ScriptBytecodeAdapter.asType(data.get("contacts"), List.class));
        }
        if (DefaultTypeTransformation.booleanUnbox(data.get("tags"))) {
            this.orgTagRepo.addOrRemove((Persistable)org, data.get("tags"));
        }
    }

    public void persistToOneAssociations(Org org, List<String> associations) {
        Contact contact;
        super.persistToOneAssociations((Object)org, associations);
        Location location = org.getLocation();
        Boolean bl = location != null ? Boolean.valueOf(location.isNewOrDirty()) : null;
        if (bl == null ? false : bl) {
            org.getLocation().persist();
        }
        Boolean bl2 = (contact = org.getContact()) != null ? Boolean.valueOf(contact.isNewOrDirty()) : null;
        if (bl2 == null ? false : bl2) {
            org.getContact().persist();
        }
    }

    public void persistManyList(Org org, GormRepo assocRepo, List<Map> assocList) {
        Reference org2 = new Reference((Object)org);
        if (!DefaultTypeTransformation.booleanUnbox(assocList)) {
            return;
        }
        public final class _persistManyList_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference org;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _persistManyList_closure1(Object _outerInstance, Object _thisObject, Reference org) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.org = reference = org;
            }

            public Object doCall(Object it) {
                Object object = ((Org)this.org.get()).getId();
                ScriptBytecodeAdapter.invokeMethodN(_persistManyList_closure1.class, (Object)it, (String)"putAt", (Object[])new Object[]{"orgId", object});
                return object;
            }

            @Generated
            public Org getOrg() {
                return (Org)ScriptBytecodeAdapter.castToType((Object)this.org.get(), Org.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _persistManyList_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(assocList, (Closure)new _persistManyList_closure1((Object)this, (Object)this, org2));
        assocRepo.createOrUpdate(assocList);
    }

    @RepoListener
    public void beforeRemove(Org org, BeforeRemoveEvent e) {
        OrgSource orgSource = org.getSource();
        if (ScriptBytecodeAdapter.compareEqual((Object)(orgSource != null ? orgSource.getSourceType() : null), (Object)SourceType.ERP)) {
            LinkedHashMap args = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", new GStringImpl(new Object[]{org.getName(), SourceType.ERP}, new String[]{"Org: ", ", source:", ""})}), LinkedHashMap.class);
            throw (Throwable)ValidationProblem.of((String)"error.delete.externalSource", (Object)args).entity((Object)org).toException();
        }
        this.orgTagRepo.remove((Persistable)org);
        this.contactRepo.removeAll(org);
    }

    @RepoListener
    public void afterRemove(Org org, AfterRemoveEvent e) {
        Location.query(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"orgId", org.getId()})).deleteAll();
        Contact.query(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"orgId", org.getId()})).deleteAll();
        OrgSource.query(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"orgId", org.getId()})).deleteAll();
    }

    public boolean verifyNumAndOrgSource(Org org, Map data) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)org.getNum()) || !DefaultTypeTransformation.booleanUnbox((Object)((Object)org.getType()))) {
            return false;
        }
        OrgSource orgSource = OrgSource.getRepo().createSource(org, data);
        org.setSource(orgSource);
        return DefaultTypeTransformation.booleanUnbox((Object)org.getSource().persist());
    }

    public Contact createOrUpdatePrimaryContact(Org org, Map data) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)data)) {
            return (Contact)ScriptBytecodeAdapter.castToType(null, Contact.class);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)org.getContact())) {
            Long cid = (Long)ScriptBytecodeAdapter.asType(data.get("id"), Long.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)cid) && ScriptBytecodeAdapter.compareNotEqual((Object)org.getContact().getId(), (Object)cid)) {
                Contact contact = Contact.get(cid);
                org.setContact(contact);
                return org.getContact();
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)cid)) {
                Object object = org.getContact().getId();
                ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)data, (String)"id");
            }
        }
        boolean bl = true;
        ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)data, (String)"isPrimary");
        Object object = org.getId();
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)data, (String)"orgId");
        Object object2 = this.contactRepo.createOrUpdate(data);
        org.setContact((Contact)ScriptBytecodeAdapter.castToType((Object)object2, Contact.class));
        return org.getContact();
    }

    public Location createOrUpdatePrimaryLocation(Org org, Map data) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)data)) {
            return (Location)ScriptBytecodeAdapter.castToType(null, Location.class);
        }
        Object object = org.getId();
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)data, (String)"orgId");
        Object object2 = this.locationRepo.createOrUpdate(data);
        org.setLocation((Location)ScriptBytecodeAdapter.castToType((Object)object2, Location.class));
        return org.getLocation();
    }

    public OrgType getOrgTypeFromData(Map data) {
        if (DefaultTypeTransformation.booleanUnbox(data.get("type"))) {
            return this.coerceOrgType(data.get("type"));
        }
        if (DefaultTypeTransformation.booleanUnbox(data.get("orgTypeId"))) {
            return OrgType.get((Long)ScriptBytecodeAdapter.asType(data.get("orgTypeId"), Long.class));
        }
        return (OrgType)ShortTypeHandling.castToEnum(null, OrgType.class);
    }

    public OrgType coerceOrgType(Object orgTypeObj) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)orgTypeObj)) {
            return (OrgType)ShortTypeHandling.castToEnum(null, OrgType.class);
        }
        if (orgTypeObj instanceof Map) {
            return OrgType.get((Long)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.getAt((Map)((Map)ScriptBytecodeAdapter.asType((Object)orgTypeObj, Map.class)), (Object)"id"), Long.class));
        }
        if (orgTypeObj instanceof OrgType) {
            return (OrgType)((Object)ScriptBytecodeAdapter.asType((Object)orgTypeObj, OrgType.class));
        }
        if (orgTypeObj instanceof String) {
            return OrgType.get(orgTypeObj);
        }
        return (OrgType)ShortTypeHandling.castToEnum(null, OrgType.class);
    }

    public OrgSource createSource(Org org, SourceType sourceType) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)org.getId())) {
            this.generateId((Persistable)org);
        }
        return OrgSource.getRepo().createSource(org, sourceType);
    }

    public Org lookup(Map data) {
        Org org = null;
        Long oid = null;
        OrgType orgType = this.coerceOrgType(data.get("type"));
        if (DefaultTypeTransformation.booleanUnbox(data.get("org"))) {
            Object object = DefaultGroovyMethods.getAt(data.get("org"), (String)"source");
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)data, (String)"source");
            Object object2 = DefaultGroovyMethods.getAt(data.get("org"), (String)"sourceId");
            ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)data, (String)"sourceId");
        }
        if (data.get("source") == null && DefaultTypeTransformation.booleanUnbox(data.get("sourceId"))) {
            Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"sourceId", data.get("sourceId")});
            ScriptBytecodeAdapter.setProperty((Object)map, null, (Object)data, (String)"source");
        }
        if (DefaultTypeTransformation.booleanUnbox(data.get("source")) && DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.getAt(data.get("source"), (String)"sourceId"))) {
            Map source = (Map)ScriptBytecodeAdapter.asType(data.get("source"), Map.class);
            if (!DefaultTypeTransformation.booleanUnbox((Object)((Object)orgType)) && DefaultTypeTransformation.booleanUnbox(source.get("orgType"))) {
                OrgType orgType2;
                orgType = orgType2 = OrgType.get(source.get("orgType"));
            }
            if (orgType != null) {
                Long l;
                oid = l = this.orgSourceRepo.findOrgIdBySourceIdAndOrgType((String)ScriptBytecodeAdapter.asType(source.get("sourceId"), String.class), orgType);
                if (DefaultTypeTransformation.booleanUnbox((Object)oid)) {
                    Object object = this.get(oid);
                    org = (Org)ScriptBytecodeAdapter.castToType((Object)object, Org.class);
                }
            } else {
                List<Long> res = this.orgSourceRepo.findOrgIdBySourceId((String)ScriptBytecodeAdapter.asType(source.get("sourceId"), String.class));
                List<Long> list = res;
                if (ScriptBytecodeAdapter.compareEqual((Object)(list != null ? Integer.valueOf(list.size()) : null), (Object)1)) {
                    Object object = DefaultGroovyMethods.getAt(res, (int)0);
                    oid = (Long)ScriptBytecodeAdapter.castToType((Object)object, Long.class);
                } else if (res.size() > 1) {
                    throw (Throwable)new DataRetrievalFailureException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{source.get("sourceId")}, new String[]{"Multiple Orgs found for sourceId: ", ", lookup key must return a unique Org"})));
                }
            }
            Object object = this.get(oid);
            org = (Org)ScriptBytecodeAdapter.castToType((Object)object, Org.class);
        } else if (DefaultTypeTransformation.booleanUnbox(data.get("num"))) {
            String num = (String)ScriptBytecodeAdapter.asType(data.get("num"), String.class);
            List<Org> orgsForNum = orgType != null ? Org.findAllWhere(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"num", num, "type", orgType})) : Org.findAllWhere(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"num", num}));
            List<Org> list = orgsForNum;
            if (ScriptBytecodeAdapter.compareEqual((Object)(list != null ? Integer.valueOf(list.size()) : null), (Object)1)) {
                Org org2;
                org = org2 = (Org)DefaultGroovyMethods.getAt(orgsForNum, (int)0);
            } else if (orgsForNum.size() > 1) {
                throw (Throwable)new DataRetrievalFailureException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{data.get("num")}, new String[]{"Multiple Orgs found for num: ", ", lookup key must return a unique Org"})));
            }
        }
        return org;
    }

    @Generated
    public OrgSource createSource(Org org) {
        return this.createSource(org, SourceType.App);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != AbstractOrgRepo.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public LocationRepo getLocationRepo() {
        return this.locationRepo;
    }

    @Generated
    public void setLocationRepo(LocationRepo locationRepo) {
        this.locationRepo = locationRepo;
    }

    @Generated
    public ContactRepo getContactRepo() {
        return this.contactRepo;
    }

    @Generated
    public void setContactRepo(ContactRepo contactRepo) {
        this.contactRepo = contactRepo;
    }

    @Generated
    public OrgTagRepo getOrgTagRepo() {
        return this.orgTagRepo;
    }

    @Generated
    public void setOrgTagRepo(OrgTagRepo orgTagRepo) {
        this.orgTagRepo = orgTagRepo;
    }

    @Generated
    public OrgSourceRepo getOrgSourceRepo() {
        return this.orgSourceRepo;
    }

    @Generated
    public void setOrgSourceRepo(OrgSourceRepo orgSourceRepo) {
        this.orgSourceRepo = orgSourceRepo;
    }

    @Generated
    public OrgMemberService getOrgMemberService() {
        return this.orgMemberService;
    }

    @Generated
    public void setOrgMemberService(OrgMemberService orgMemberService) {
        this.orgMemberService = orgMemberService;
    }

    @Generated
    public List<String> getToOneAssociations() {
        return this.toOneAssociations;
    }

    @Generated
    public void setToOneAssociations(List<String> list) {
        this.toOneAssociations = list;
    }
}

