/*
 * Decompiled with CFR 0.152.
 */
package yakworks.rally.eventlog;

import gorm.tools.beans.Pager;
import grails.core.GrailsApplication;
import grails.gorm.transactions.GrailsTransactionTemplate;
import grails.gorm.transactions.Transactional;
import grails.util.Metadata;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.SoftReference;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.datastore.gorm.GormEnhancer;
import org.grails.datastore.gorm.internal.RuntimeSupport;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.query.api.Criteria;
import org.grails.datastore.mapping.transactions.CustomizableRollbackTransactionAttribute;
import org.grails.datastore.mapping.transactions.TransactionCapableDatastore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Propagation;
import yakworks.rally.eventlog.EventLog;

@Service
@Lazy
public class EventLogger
implements GroovyObject {
    private static final int MAX_MESSAGE_SIZE = 3998;
    @Value(value="${nine.eventLog.purgeDays:0}")
    private int purgeDays;
    @Value(value="${nine.eventLog.searchDays:7}")
    private int searchDays;
    @Value(value="${info.app.name}")
    private String appName;
    @Inject
    private GrailsApplication grailsApplication;
    private static final transient Logger log;
    protected PlatformTransactionManager $transactionManager;
    protected Datastore $targetDatastore;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public EventLogger() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @PostConstruct
    public void init() {
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.appName)) {
            String string;
            this.appName = string = Metadata.getCurrent().getApplicationName();
        }
    }

    public EventLog error(String message) {
        return this.log(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"message", message, "priority", EventLog.ERROR_INT}));
    }

    public EventLog error(String message, Throwable throwable) {
        return this.log(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"message", message, "throwable", throwable, "priority", EventLog.ERROR_INT}));
    }

    public EventLog error(Map params) {
        int n = EventLog.ERROR_INT;
        ScriptBytecodeAdapter.invokeMethodN(EventLogger.class, (Object)params, (String)"putAt", (Object[])new Object[]{"priority", n});
        return this.log(params);
    }

    public EventLog info(String message) {
        return this.log(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"message", message, "priority", EventLog.INFO_INT}));
    }

    public EventLog info(Map params) {
        int n = EventLog.INFO_INT;
        ScriptBytecodeAdapter.invokeMethodN(EventLogger.class, (Object)params, (String)"putAt", (Object[])new Object[]{"priority", n});
        return this.log(params);
    }

    public EventLog warn(String message) {
        return this.log(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"message", message, "priority", EventLog.WARN_INT}));
    }

    public EventLog warn(Map params) {
        int n = EventLog.WARN_INT;
        ScriptBytecodeAdapter.invokeMethodN(EventLogger.class, (Object)params, (String)"putAt", (Object[])new Object[]{"priority", n});
        return this.log(params);
    }

    public EventLog log(Map params) {
        EventLog eventLog = this.logTransactional(params);
        try {
            return eventLog;
        }
        catch (Exception e) {
            Object v0;
            if (log.isErrorEnabled()) {
                log.error(e.getMessage(), (Throwable)ScriptBytecodeAdapter.castToType((Object)e, Throwable.class));
                v0 = null;
            } else {
                v0 = null;
            }
            EventLog eventLog2 = (EventLog)ScriptBytecodeAdapter.castToType(v0, EventLog.class);
            return eventLog2;
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    private EventLog logTransactional(Map params) {
        Reference params2 = new Reference((Object)params);
        CustomizableRollbackTransactionAttribute $transactionAttribute = new CustomizableRollbackTransactionAttribute();
        int n = Propagation.REQUIRES_NEW.value();
        $transactionAttribute.setPropagationBehavior(n);
        String string = "yakworks.rally.eventlog.EventLogger.logTransactional";
        $transactionAttribute.setName(string);
        GrailsTransactionTemplate $transactionTemplate = new GrailsTransactionTemplate(this.getTransactionManager(), $transactionAttribute);
        public final class _logTransactional_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference params;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _logTransactional_closure1(Object _outerInstance, Object _thisObject, Reference params) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.params = reference = params;
            }

            public EventLog doCall(TransactionStatus transactionStatus) {
                return (EventLog)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethodSafe((Object)((EventLogger)this.getThisObject()), (String)"$tt__logTransactional", (Object)new Object[]{this.params.get(), transactionStatus}), EventLog.class);
            }

            @Generated
            public EventLog call(TransactionStatus transactionStatus) {
                return this.doCall(transactionStatus);
            }

            @Generated
            public Map getParams() {
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.params.get(), Map.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _logTransactional_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (EventLog)$transactionTemplate.execute((Closure)new _logTransactional_closure1(this, this, params2));
    }

    public static String convertStackTrace(Throwable throwable) {
        StringWriter writer = new StringWriter();
        PrintWriter printer = new PrintWriter(writer);
        throwable.printStackTrace(printer);
        printer.flush();
        writer.flush();
        String str = ShortTypeHandling.castToString((Object)writer);
        if (str.length() > MAX_MESSAGE_SIZE) {
            return str.substring(0, MAX_MESSAGE_SIZE);
        }
        return str;
    }

    public List<EventLog> getEventList(boolean isSummaryOnly) {
        return this.getEventList(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"isSummaryOnly", isSummaryOnly}));
    }

    public List<EventLog> getEventList(Map params) {
        Reference params2 = new Reference((Object)params);
        CallSite[] callSiteArray = EventLogger.$getCallSiteArray();
        Pager pager = (Pager)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(Pager.class, (Object)((Map)params2.get())), Pager.class);
        Criteria criteria = (Criteria)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].call(EventLog.class), Criteria.class);
        Reference searchDate = new Reference(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(LocalDateTime.class), (Object)this.searchDays)));
        public final class _getEventList_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference searchDate;
            private /* synthetic */ Reference params;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getEventList_closure2(Object _outerInstance, Object _thisObject, Reference searchDate, Reference params) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _getEventList_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.searchDate = reference2 = searchDate;
                this.params = reference = params;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getEventList_closure2.$getCallSiteArray();
                if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    if (DefaultTypeTransformation.intUnbox((Object)callSiteArray[0].callGroovyObjectGetProperty((Object)this)) > 0) {
                        callSiteArray[1].callCurrent((GroovyObject)this, (Object)"createdDate", this.searchDate.get());
                    }
                } else if (DefaultTypeTransformation.intUnbox((Object)callSiteArray[2].callGroovyObjectGetProperty((Object)this)) > 0) {
                    callSiteArray[3].callCurrent((GroovyObject)this, (Object)"createdDate", this.searchDate.get());
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[4].callGetProperty(this.params.get()))) {
                    callSiteArray[5].callCurrent((GroovyObject)this, (Object)"action", (Object)"summary");
                }
                return callSiteArray[6].callCurrent((GroovyObject)this, (Object)"createdDate", (Object)"desc");
            }

            @Generated
            public Object getSearchDate() {
                CallSite[] callSiteArray = _getEventList_closure2.$getCallSiteArray();
                return this.searchDate.get();
            }

            @Generated
            public Map getParams() {
                CallSite[] callSiteArray = _getEventList_closure2.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.params.get(), Map.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _getEventList_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getEventList_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "searchDays";
                stringArray[1] = "gt";
                stringArray[2] = "searchDays";
                stringArray[3] = "gt";
                stringArray[4] = "isSummaryOnly";
                stringArray[5] = "eq";
                stringArray[6] = "order";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[7];
                _getEventList_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getEventList_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getEventList_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        List events = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[5].call((Object)criteria, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"max", callSiteArray[6].callGroovyObjectGetProperty((Object)pager), "offset", callSiteArray[7].callGroovyObjectGetProperty((Object)pager)}), (Object)new _getEventList_closure2(this, this, searchDate, params2)), List.class);
        return events;
    }

    public Long eventCount() {
        return (Long)ScriptBytecodeAdapter.castToType((Object)this.getEventList().size(), Long.class);
    }

    public void purgeEvents() {
        public final class _purgeEvents_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference cutoff;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _purgeEvents_closure3(Object _outerInstance, Object _thisObject, Reference cutoff) {
                Reference reference;
                CallSite[] callSiteArray = _purgeEvents_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.cutoff = reference = cutoff;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _purgeEvents_closure3.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"createdDate", this.cutoff.get());
            }

            @Generated
            public Object getCutoff() {
                CallSite[] callSiteArray = _purgeEvents_closure3.$getCallSiteArray();
                return this.cutoff.get();
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _purgeEvents_closure3.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _purgeEvents_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "le";
                return new CallSiteArray(_purgeEvents_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _purgeEvents_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        CallSite[] callSiteArray = EventLogger.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (this.purgeDays > 0) {
                Reference cutoff = new Reference(callSiteArray[8].call(callSiteArray[9].call(LocalDateTime.class), (Object)this.purgeDays));
                callSiteArray[10].call(cutoff.get());
                if (DefaultTypeTransformation.booleanUnbox((Object)cutoff.get())) {
                    ScriptBytecodeAdapter.invokeMethod0SpreadSafe(EventLogger.class, (Object)callSiteArray[11].call(callSiteArray[12].call(EventLog.class), (Object)new _purgeEvents_closure3(this, this, cutoff)), (String)"delete");
                }
            }
        } else if (this.purgeDays > 0) {
            Reference cutoff = new Reference(callSiteArray[13].call(callSiteArray[14].call(LocalDateTime.class), (Object)this.purgeDays));
            callSiteArray[15].call(cutoff.get());
            if (DefaultTypeTransformation.booleanUnbox((Object)cutoff.get())) {
                ScriptBytecodeAdapter.invokeMethod0SpreadSafe(EventLogger.class, (Object)callSiteArray[16].call(callSiteArray[17].call(EventLog.class), (Object)new _purgeEvents_closure3(this, this, cutoff)), (String)"delete");
            }
        }
    }

    public PlatformTransactionManager getTransactionManager() {
        if (this.$transactionManager != null) {
            return this.$transactionManager;
        }
        return GormEnhancer.findSingleTransactionManager();
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        PlatformTransactionManager platformTransactionManager;
        this.$transactionManager = platformTransactionManager = transactionManager;
    }

    @Autowired(required=false)
    public void setTargetDatastore(Datastore ... datastores) {
        Datastore datastore;
        this.$targetDatastore = datastore = RuntimeSupport.findDefaultDatastore((Datastore[])datastores);
        if (RuntimeSupport.findDefaultDatastore((Datastore[])datastores) != null) {
            PlatformTransactionManager platformTransactionManager;
            this.$transactionManager = platformTransactionManager = ((TransactionCapableDatastore)ScriptBytecodeAdapter.castToType((Object)RuntimeSupport.findDefaultDatastore((Datastore[])datastores), TransactionCapableDatastore.class)).getTransactionManager();
        }
    }

    protected Datastore getTargetDatastore(String connectionName) {
        if (this.$targetDatastore != null) {
            return (Datastore)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodN(EventLogger.class, (Object)this.$targetDatastore, (String)"getDatastoreForConnection", (Object[])new Object[]{connectionName}), Datastore.class);
        }
        return (Datastore)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodN(EventLogger.class, (Object)GormEnhancer.findSingleDatastore(), (String)"getDatastoreForConnection", (Object[])new Object[]{connectionName}), Datastore.class);
    }

    protected Datastore getTargetDatastore() {
        if (this.$targetDatastore != null) {
            return this.$targetDatastore;
        }
        return GormEnhancer.findSingleDatastore();
    }

    protected EventLog $tt__logTransactional(Map params, TransactionStatus transactionStatus) {
        EventLog row = new EventLog();
        row.bind(params);
        String string = row.getAppName();
        String string2 = DefaultTypeTransformation.booleanUnbox((Object)string) ? string : this.appName;
        row.setAppName(string2);
        String message = ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt((Map)params, (Object)"message"));
        String string3 = message;
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)(string3 != null ? Integer.valueOf(StringGroovyMethods.size((CharSequence)string3)) : null), (Object)MAX_MESSAGE_SIZE)) {
            String string4 = message.substring(0, MAX_MESSAGE_SIZE);
            row.setMessage(string4);
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)row.getStackTrace()) && DefaultTypeTransformation.booleanUnbox(params.get("exception"))) {
            String string5 = EventLogger.convertStackTrace((Throwable)ScriptBytecodeAdapter.castToType(params.get("exception"), Throwable.class));
            row.setStackTrace(string5);
        } else if (DefaultTypeTransformation.booleanUnbox(params.get("throwable"))) {
            String string6 = EventLogger.convertStackTrace((Throwable)ScriptBytecodeAdapter.castToType(params.get("throwable"), Throwable.class));
            row.setStackTrace(string6);
        }
        return row.persist(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"flush", true}));
    }

    @Generated
    public List<EventLog> getEventList() {
        CallSite[] callSiteArray = EventLogger.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.getEventList(false);
        }
        return this.getEventList(false);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != EventLogger.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"yakworks.rally.eventlog.EventLogger");
    }

    @Generated
    public static int getMAX_MESSAGE_SIZE() {
        return MAX_MESSAGE_SIZE;
    }

    @Generated
    public int getPurgeDays() {
        return this.purgeDays;
    }

    @Generated
    public void setPurgeDays(int n) {
        this.purgeDays = n;
    }

    @Generated
    public int getSearchDays() {
        return this.searchDays;
    }

    @Generated
    public void setSearchDays(int n) {
        this.searchDays = n;
    }

    @Generated
    public String getAppName() {
        return this.appName;
    }

    @Generated
    public void setAppName(String string) {
        this.appName = string;
    }

    @Generated
    public GrailsApplication getGrailsApplication() {
        return this.grailsApplication;
    }

    @Generated
    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "of";
        stringArray[1] = "createCriteria";
        stringArray[2] = "clearTime";
        stringArray[3] = "minusDays";
        stringArray[4] = "now";
        stringArray[5] = "list";
        stringArray[6] = "max";
        stringArray[7] = "offset";
        stringArray[8] = "minusDays";
        stringArray[9] = "now";
        stringArray[10] = "clearTime";
        stringArray[11] = "list";
        stringArray[12] = "createCriteria";
        stringArray[13] = "minusDays";
        stringArray[14] = "now";
        stringArray[15] = "clearTime";
        stringArray[16] = "list";
        stringArray[17] = "createCriteria";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[18];
        EventLogger.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(EventLogger.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = EventLogger.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

