/*
 * Decompiled with CFR 0.152.
 */
package yakworks.rally.activity.repo;

import gorm.tools.databinding.BindAction;
import gorm.tools.mango.MangoDetachedCriteria;
import gorm.tools.mango.api.QueryArgs;
import gorm.tools.model.Persistable;
import gorm.tools.problem.ProblemHandler;
import gorm.tools.repository.GormRepository;
import gorm.tools.repository.PersistArgs;
import gorm.tools.repository.events.AfterBindEvent;
import gorm.tools.repository.events.BeforeBindEvent;
import gorm.tools.repository.events.BeforePersistEvent;
import gorm.tools.repository.events.BeforeRemoveEvent;
import gorm.tools.repository.events.RepoListener;
import gorm.tools.repository.model.LongIdGormRepo;
import grails.artefact.Artefact;
import grails.gorm.DetachedCriteria;
import grails.gorm.transactions.GrailsTransactionTemplate;
import grails.gorm.transactions.ReadOnly;
import grails.gorm.transactions.Transactional;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.lang.ref.SoftReference;
import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.JoinType;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.datastore.gorm.GormEnhancer;
import org.grails.datastore.gorm.internal.RuntimeSupport;
import org.grails.datastore.gorm.query.criteria.AbstractDetachedCriteria;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.query.api.QueryableCriteria;
import org.grails.datastore.mapping.transactions.CustomizableRollbackTransactionAttribute;
import org.grails.datastore.mapping.transactions.TransactionCapableDatastore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import yakworks.commons.lang.Validate;
import yakworks.rally.activity.model.Activity;
import yakworks.rally.activity.model.ActivityContact;
import yakworks.rally.activity.model.ActivityLink;
import yakworks.rally.activity.model.ActivityNote;
import yakworks.rally.activity.model.Task;
import yakworks.rally.activity.model.TaskStatus;
import yakworks.rally.activity.model.TaskType;
import yakworks.rally.activity.repo.ActivityLinkRepo;
import yakworks.rally.attachment.model.Attachment;
import yakworks.rally.attachment.model.AttachmentLink;
import yakworks.rally.attachment.repo.AttachmentRepo;
import yakworks.rally.orgs.model.Org;
import yakworks.rally.tag.model.TagLink;
import yakworks.security.user.CurrentUser;

@GormRepository
@Artefact(value="Repository")
@Component
public class ActivityRepo
extends LongIdGormRepo<Activity> {
    @Autowired(required=false)
    private ActivityLinkRepo activityLinkRepo;
    @Autowired(required=false)
    private AttachmentRepo attachmentRepo;
    @Autowired(required=false)
    private CurrentUser currentUser;
    @Autowired(required=false)
    private ProblemHandler problemHandler;
    protected PlatformTransactionManager $transactionManager;
    protected Datastore $targetDatastore;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public ActivityRepo() {
    }

    @RepoListener
    public void beforeValidate(Activity activity) {
        this.updateNameSummary(activity);
    }

    @RepoListener
    public void beforeBind(Activity activity, Map data, BeforeBindEvent e) {
        this.fixUpTaskParams(data);
        if (e.isBindUpdate() && DefaultTypeTransformation.booleanUnbox((Object)activity.getNote()) && DefaultTypeTransformation.booleanUnbox(data.get("name"))) {
            Object v = data.get("name");
            activity.getNote().setBody(ShortTypeHandling.castToString(v));
            activity.getNote().persist();
        }
    }

    @RepoListener
    public void afterBind(Activity activity, Map data, AfterBindEvent e) {
        this.assignOrg(activity, data);
    }

    @RepoListener
    public void beforeRemove(Activity activity, BeforeRemoveEvent e) {
        if (DefaultTypeTransformation.booleanUnbox((Object)activity.getNote())) {
            ActivityNote note = activity.getNote();
            Object var4_4 = null;
            activity.setNote((ActivityNote)ScriptBytecodeAdapter.castToType(var4_4, ActivityNote.class));
            activity.persist(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"flush", true}));
            note.delete();
        }
        TagLink.remove((Persistable)activity);
        AttachmentLink.getRepo().remove((Persistable)activity);
        ActivityLink.getRepo().remove(activity);
        ActivityContact.getRepo().remove((Persistable)activity);
    }

    @RepoListener
    public void beforePersist(Activity activity, BeforePersistEvent e) {
        if (DefaultTypeTransformation.booleanUnbox((Object)e.getData())) {
            Map data = e.getData();
            this.addRelatedDomainsToActivity(activity, data);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)activity.getTask())) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)activity.getTask().getStatus())) {
                TaskStatus taskStatus = TaskStatus.getOPEN();
                activity.getTask().setStatus(taskStatus);
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)activity.getTask().getTaskType())) {
                TaskType taskType = TaskType.getTODO();
                activity.getTask().setTaskType(taskType);
            }
        }
    }

    public void doAfterPersistWithData(Activity activity, PersistArgs args) {
        BindAction bindAction;
        Map data = args.getData();
        if (DefaultTypeTransformation.booleanUnbox(data.get("attachments"))) {
            this.doAttachments(activity, data.get("attachments"));
        }
        if (DefaultTypeTransformation.booleanUnbox(data.get("contacts"))) {
            ActivityContact.addOrRemove(activity, data.get("contacts"));
        }
        if (DefaultTypeTransformation.booleanUnbox(data.get("tags"))) {
            TagLink.addOrRemoveTags((Persistable)activity, data.get("tags"));
        }
        Boolean bl = (bindAction = args.getBindAction()) != null ? Boolean.valueOf(bindAction.isCreate()) : null;
        if (bl == null ? false : bl) {
            if (DefaultTypeTransformation.booleanUnbox(data.get("linkedId")) && DefaultTypeTransformation.booleanUnbox(data.get("linkedEntity"))) {
                this.activityLinkRepo.create((Long)ScriptBytecodeAdapter.asType(data.get("linkedId"), Long.class), (String)ScriptBytecodeAdapter.asType(data.get("linkedEntity"), String.class), (Persistable)activity);
            } else if (DefaultTypeTransformation.booleanUnbox(data.get("links"))) {
                ValueRecorder valueRecorder = new ValueRecorder();
                try {
                    Map map = data;
                    valueRecorder.record((Object)map, 8);
                    Object v = map.get("links");
                    valueRecorder.record(v, 13);
                    boolean bl2 = v instanceof List;
                    valueRecorder.record((Object)bl2, 19);
                    if (bl2) {
                        valueRecorder.clear();
                    } else {
                        ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert data.links instanceof List<Map>", (ValueRecorder)valueRecorder), null);
                    }
                }
                catch (Throwable throwable) {
                    valueRecorder.clear();
                    throw throwable;
                }
                this.doLinks(activity, (List)ScriptBytecodeAdapter.asType(data.get("links"), List.class));
            }
        }
    }

    public MangoDetachedCriteria<Activity> query(QueryArgs queryArgs, @DelegatesTo(value=MangoDetachedCriteria.class) Closure closure) {
        Map crit = queryArgs.getCriteria();
        DetachedCriteria tagExistsCrit = null;
        DetachedCriteria<ActivityLink> actLinkExists = null;
        if (DefaultTypeTransformation.booleanUnbox(crit.get("tags")) || DefaultTypeTransformation.booleanUnbox(crit.get("tagIds"))) {
            DetachedCriteria detachedCriteria;
            LinkedHashMap tagCriteriaMap = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"tags", crit.remove("tags"), "tagIds", crit.remove("tagIds")}), LinkedHashMap.class);
            tagExistsCrit = detachedCriteria = TagLink.getExistsCriteria(tagCriteriaMap, Activity.class, "activity_.id");
        }
        if (DefaultTypeTransformation.booleanUnbox(crit.get("linkedId")) && DefaultTypeTransformation.booleanUnbox(crit.get("linkedEntity"))) {
            DetachedCriteria<ActivityLink> detachedCriteria;
            Long linkedId = (Long)ScriptBytecodeAdapter.asType(crit.remove("linkedId"), Long.class);
            String linkedEntity = (String)ScriptBytecodeAdapter.asType(crit.remove("linkedEntity"), String.class);
            actLinkExists = detachedCriteria = this.getActivityLinkCriteria(linkedId, linkedEntity);
        }
        MangoDetachedCriteria detCrit = this.getMangoQuery().query(Activity.class, queryArgs, closure);
        if (tagExistsCrit != null) {
            detCrit.exists((QueryableCriteria)tagExistsCrit.id());
        }
        if (actLinkExists != null) {
            detCrit.exists((QueryableCriteria)actLinkExists.id());
        }
        return detCrit;
    }

    public void assignOrg(Activity activity, Map data) {
        if (!DefaultTypeTransformation.booleanUnbox(data.get("orgId"))) {
            if (DefaultTypeTransformation.booleanUnbox(data.get("org")) && data.get("org") instanceof Map) {
                Object object = Org.getRepo().findWithData((Map)ScriptBytecodeAdapter.asType(data.get("org"), Map.class));
                activity.setOrg((Org)ScriptBytecodeAdapter.castToType((Object)object, Org.class));
            } else if (DefaultTypeTransformation.booleanUnbox(data.get("org")) && data.get("org") instanceof Org) {
                Org org = (Org)ScriptBytecodeAdapter.castToType(data.get("org"), Org.class);
                activity.setOrg(org);
            }
        }
    }

    public void updateNameSummary(Activity activity) {
        String string = activity.getName();
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)(string != null ? Integer.valueOf(string.length()) : null), (Object)255)) {
            String string2 = StringUtils.abbreviate((String)activity.getName(), (int)255);
            activity.setName(string2);
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)activity.getKind()), (Object)((Object)Activity.Kind.Note)) && DefaultTypeTransformation.booleanUnbox((Object)activity.getNote())) {
            int endChar = activity.getNote().getBody().trim().length();
            String string3 = endChar > 255 ? StringGroovyMethods.plus((String)activity.getNote().getBody().trim().substring(0, 251), (CharSequence)" ...") : activity.getNote().getBody().trim();
            activity.setName(string3);
        }
    }

    public void addRelatedDomainsToActivity(Activity activity, Map data) {
        String string;
        String string2;
        Map task = (Map)ScriptBytecodeAdapter.asType(data.get("task"), Map.class);
        if (!DefaultTypeTransformation.booleanUnbox(data.get("kind")) && DefaultTypeTransformation.booleanUnbox(task == null ? null : task.get("dueDate"))) {
            Activity.Kind kind = Activity.Kind.Todo;
            activity.setKind(kind);
        }
        String name = (string2 = (String)ScriptBytecodeAdapter.asType(data.get("name"), String.class)) != null ? string2.trim() : null;
        if (!DefaultTypeTransformation.booleanUnbox((Object)activity.getNote()) && ScriptBytecodeAdapter.compareGreaterThan((Object)((string = name) != null ? Integer.valueOf(string.length()) : null), (Object)255)) {
            this.addNote(activity, name);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)activity.getNote()) && !DefaultTypeTransformation.booleanUnbox((Object)activity.getNote().getBody()) && DefaultTypeTransformation.booleanUnbox(data.get("name"))) {
            Object v = data.get("name");
            activity.getNote().setBody(ShortTypeHandling.castToString(v));
        }
    }

    public void doAttachments(Activity activity, Object attData) {
        Reference activity2 = new Reference((Object)activity);
        List attachments = this.attachmentRepo.createOrUpdate((List)ScriptBytecodeAdapter.asType((Object)attData, List.class));
        public final class _doAttachments_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference activity;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _doAttachments_closure1(Object _outerInstance, Object _thisObject, Reference activity) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.activity = reference = activity;
            }

            public AttachmentLink doCall(Attachment attachment) {
                return AttachmentLink.create((Persistable)ScriptBytecodeAdapter.castToType((Object)this.activity.get(), Persistable.class), attachment);
            }

            @Generated
            public AttachmentLink call(Attachment attachment) {
                return this.doCall(attachment);
            }

            @Generated
            public Activity getActivity() {
                return (Activity)ScriptBytecodeAdapter.castToType((Object)this.activity.get(), Activity.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _doAttachments_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((List)attachments, (Closure)new _doAttachments_closure1((Object)this, (Object)this, activity2));
        ((Activity)activity2.get()).setHasAttachments(true);
    }

    public void doLinks(Activity activity, List<Map> links) {
        Reference activity2 = new Reference((Object)activity);
        public final class _doLinks_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference activity;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _doLinks_closure2(Object _outerInstance, Object _thisObject, Reference activity) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.activity = reference = activity;
            }

            public ActivityLink doCall(Object link) {
                return (ActivityLink)ScriptBytecodeAdapter.castToType((Object)((ActivityRepo)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ActivityRepo.class))).getActivityLinkRepo().create((Long)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.getAt((Map)((Map)ScriptBytecodeAdapter.castToType((Object)link, Map.class)), (Object)"linkedId"), Long.class), (String)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.getAt((Map)((Map)ScriptBytecodeAdapter.castToType((Object)link, Map.class)), (Object)"linkedEntity"), String.class), (Persistable)ScriptBytecodeAdapter.castToType((Object)this.activity.get(), Persistable.class)), ActivityLink.class);
            }

            @Generated
            public Activity getActivity() {
                return (Activity)ScriptBytecodeAdapter.castToType((Object)this.activity.get(), Activity.class);
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _doLinks_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(links, (Closure)new _doLinks_closure2((Object)this, (Object)this, activity2));
    }

    public ActivityNote addNote(Activity act, String body, String contentType) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)act.getNote())) {
            ActivityNote activityNote = new ActivityNote();
            act.setNote(activityNote);
        }
        String string = body;
        act.getNote().setBody(string);
        String string2 = contentType;
        act.getNote().setContentType(string2);
        return act.getNote();
    }

    public void completeTask(Task task, Long completedById) {
        Validate.notNull((Object)completedById, (String)"[completedById]");
        task.bind(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"status", TaskStatus.getCOMPLETE(), "state", (Integer)ScriptBytecodeAdapter.asType((Object)TaskStatus.getCOMPLETE().getId(), Integer.class), "completedDate", LocalDateTime.now(), "completedBy", completedById}));
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public Activity createTodo(Org org, Long userId, String name, String linkedEntity, List<Long> linkedIds, LocalDateTime dueDate) {
        void var3_3;
        void var2_2;
        Reference org2 = new Reference((Object)org);
        Reference userId2 = new Reference((Object)var2_2);
        Reference name2 = new Reference((Object)var3_3);
        Reference linkedEntity2 = new Reference((Object)linkedEntity);
        Reference linkedIds2 = new Reference(linkedIds);
        Reference dueDate2 = new Reference((Object)dueDate);
        CustomizableRollbackTransactionAttribute $transactionAttribute = new CustomizableRollbackTransactionAttribute();
        String string = "yakworks.rally.activity.repo.ActivityRepo.createTodo";
        $transactionAttribute.setName(string);
        GrailsTransactionTemplate $transactionTemplate = new GrailsTransactionTemplate(this.getTransactionManager(), $transactionAttribute);
        public final class _createTodo_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference org;
            private /* synthetic */ Reference userId;
            private /* synthetic */ Reference name;
            private /* synthetic */ Reference linkedEntity;
            private /* synthetic */ Reference linkedIds;
            private /* synthetic */ Reference dueDate;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _createTodo_closure3(Object _outerInstance, Object _thisObject, Reference org, Reference userId, Reference name, Reference linkedEntity, Reference linkedIds, Reference dueDate) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                Reference reference6;
                this.org = reference6 = org;
                this.userId = reference5 = userId;
                this.name = reference4 = name;
                this.linkedEntity = reference3 = linkedEntity;
                this.linkedIds = reference2 = linkedIds;
                this.dueDate = reference = dueDate;
            }

            public Activity doCall(TransactionStatus transactionStatus) {
                return (Activity)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethodSafe((Object)((Object)((ActivityRepo)((Object)this.getThisObject()))), (String)"$tt__createTodo", (Object)new Object[]{this.org.get(), this.userId.get(), this.name.get(), this.linkedEntity.get(), this.linkedIds.get(), this.dueDate.get(), transactionStatus}), Activity.class);
            }

            @Generated
            public Activity call(TransactionStatus transactionStatus) {
                return this.doCall(transactionStatus);
            }

            @Generated
            public Org getOrg() {
                return (Org)ScriptBytecodeAdapter.castToType((Object)this.org.get(), Org.class);
            }

            @Generated
            public Long getUserId() {
                return (Long)ScriptBytecodeAdapter.castToType((Object)this.userId.get(), Long.class);
            }

            @Generated
            public String getName() {
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            @Generated
            public String getLinkedEntity() {
                return ShortTypeHandling.castToString((Object)this.linkedEntity.get());
            }

            @Generated
            public List getLinkedIds() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.linkedIds.get(), List.class);
            }

            @Generated
            public LocalDateTime getDueDate() {
                return (LocalDateTime)ScriptBytecodeAdapter.castToType((Object)this.dueDate.get(), LocalDateTime.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createTodo_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (Activity)$transactionTemplate.execute((Closure)new _createTodo_closure3((Object)this, (Object)this, org2, userId2, name2, linkedEntity2, linkedIds2, dueDate2));
    }

    public void fixUpTaskParams(Map params) {
        Map taskParams = (Map)ScriptBytecodeAdapter.asType(params.get("task"), Map.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)taskParams) || taskParams.get("dueDate") == null) {
            params.remove("task");
        }
    }

    /*
     * WARNING - void declaration
     */
    @ReadOnly
    public boolean hasActivityWithAttachments(Persistable<Long> linkedEntity, Activity.Kind kind) {
        void var2_2;
        Reference linkedEntity2 = new Reference(linkedEntity);
        Reference kind2 = new Reference((Object)var2_2);
        CustomizableRollbackTransactionAttribute $transactionAttribute = new CustomizableRollbackTransactionAttribute();
        Boolean bl = Boolean.TRUE;
        $transactionAttribute.setReadOnly(DefaultTypeTransformation.booleanUnbox((Object)bl));
        String string = "yakworks.rally.activity.repo.ActivityRepo.hasActivityWithAttachments";
        $transactionAttribute.setName(string);
        GrailsTransactionTemplate $transactionTemplate = new GrailsTransactionTemplate(this.getTransactionManager(), $transactionAttribute);
        public final class _hasActivityWithAttachments_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference linkedEntity;
            private /* synthetic */ Reference kind;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _hasActivityWithAttachments_closure4(Object _outerInstance, Object _thisObject, Reference linkedEntity, Reference kind) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.linkedEntity = reference2 = linkedEntity;
                this.kind = reference = kind;
            }

            public Boolean doCall(TransactionStatus transactionStatus) {
                return (Boolean)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethodSafe((Object)((Object)((ActivityRepo)((Object)this.getThisObject()))), (String)"$tt__hasActivityWithAttachments", (Object)new Object[]{this.linkedEntity.get(), this.kind.get(), transactionStatus}), Boolean.class);
            }

            @Generated
            public Boolean call(TransactionStatus transactionStatus) {
                return this.doCall(transactionStatus);
            }

            @Generated
            public Persistable getLinkedEntity() {
                return (Persistable)ScriptBytecodeAdapter.castToType((Object)this.linkedEntity.get(), Persistable.class);
            }

            @Generated
            public Activity.Kind getKind() {
                return (Activity.Kind)ShortTypeHandling.castToEnum((Object)this.kind.get(), Activity.Kind.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _hasActivityWithAttachments_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultTypeTransformation.booleanUnbox((Object)$transactionTemplate.execute((Closure)new _hasActivityWithAttachments_closure4((Object)this, (Object)this, linkedEntity2, kind2)));
    }

    /*
     * WARNING - void declaration
     */
    public DetachedCriteria<ActivityLink> getActivityLinkCriteria(Long linkedId, String linkedEntity) {
        void var2_2;
        Reference linkedId2 = new Reference((Object)linkedId);
        Reference linkedEntity2 = new Reference((Object)var2_2);
        public final class _getActivityLinkCriteria_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference linkedId;
            private /* synthetic */ Reference linkedEntity;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getActivityLinkCriteria_closure5(Object _outerInstance, Object _thisObject, Reference linkedId, Reference linkedEntity) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.linkedId = reference2 = linkedId;
                this.linkedEntity = reference = linkedEntity;
            }

            public MangoDetachedCriteria doCall(Object it) {
                ((MangoDetachedCriteria)this.getDelegate()).eqProperty("activity.id", "activity_.id");
                ((MangoDetachedCriteria)this.getDelegate()).eq("linkedId", this.linkedId.get());
                return ((MangoDetachedCriteria)this.getDelegate()).eq("linkedEntity", this.linkedEntity.get());
            }

            @Generated
            public Long getLinkedId() {
                return (Long)ScriptBytecodeAdapter.castToType((Object)this.linkedId.get(), Long.class);
            }

            @Generated
            public String getLinkedEntity() {
                return ShortTypeHandling.castToString((Object)this.linkedEntity.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public MangoDetachedCriteria doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getActivityLinkCriteria_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return ActivityLink.query(new _getActivityLinkCriteria_closure5((Object)this, (Object)this, linkedId2, linkedEntity2));
    }

    @Deprecated
    public DetachedCriteria<Activity> zzzgetActivityByLinkedCriteria(Long linkedId, String linkedEntity, boolean custArea) {
        Reference custArea2 = new Reference((Object)custArea);
        Reference actLinkExists = new Reference(this.getActivityLinkCriteria(linkedId, linkedEntity));
        public final class _zzzgetActivityByLinkedCriteria_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference actLinkExists;
            private /* synthetic */ Reference custArea;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _zzzgetActivityByLinkedCriteria_closure6(Object _outerInstance, Object _thisObject, Reference actLinkExists, Reference custArea) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.actLinkExists = reference2 = actLinkExists;
                this.custArea = reference = custArea;
            }

            public DetachedCriteria doCall(Object it) {
                ((AbstractDetachedCriteria)this.getDelegate()).setAlias("activity_");
                ((AbstractDetachedCriteria)this.getDelegate()).createAlias("task", "task");
                ((DetachedCriteria)this.getDelegate()).join("task", JoinType.LEFT);
                ((DetachedCriteria)this.getDelegate()).exists((QueryableCriteria)((DetachedCriteria)this.actLinkExists.get()).id());
                public final class _closure9
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure9(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public MangoDetachedCriteria doCall(Object it) {
                        ((MangoDetachedCriteria)((Closure)this.getOwner()).getDelegate()).isNull("task");
                        return ((MangoDetachedCriteria)((Closure)this.getOwner()).getDelegate()).le("task.state", (Object)1);
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public MangoDetachedCriteria doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure9.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                ((DetachedCriteria)this.getDelegate()).or((Closure)new _closure9((Object)this, this.getThisObject()));
                public final class _closure10
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference custArea;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure10(Object _outerInstance, Object _thisObject, Reference custArea) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.custArea = reference = custArea;
                    }

                    public DetachedCriteria doCall(Object it) {
                        ((MangoDetachedCriteria)((Closure)this.getOwner()).getDelegate()).eq("visibleTo", (Object)Activity.VisibleTo.Everyone);
                        if (!DefaultTypeTransformation.booleanUnbox((Object)this.custArea.get())) {
                            ((MangoDetachedCriteria)((Closure)this.getOwner()).getDelegate()).ne("visibleTo", (Object)Activity.VisibleTo.Owner);
                            public final class _closure11
                            extends Closure
                            implements GeneratedClosure {
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;

                                public _closure11(Object _outerInstance, Object _thisObject) {
                                    super(_outerInstance, _thisObject);
                                }

                                public MangoDetachedCriteria doCall(Object it) {
                                    ((MangoDetachedCriteria)((Closure)((Closure)this.getOwner()).getOwner()).getDelegate()).eq("visibleTo", (Object)Activity.VisibleTo.Owner);
                                    return ((MangoDetachedCriteria)((Closure)((Closure)this.getOwner()).getOwner()).getDelegate()).eq("createdBy", (Object)((ActivityRepo)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ActivityRepo.class))).getCurrentUser().getUserId());
                                }

                                @Generated
                                public Object call(Object args) {
                                    return this.doCall(args);
                                }

                                @Generated
                                public Object call() {
                                    return this.doCall(null);
                                }

                                @Generated
                                public MangoDetachedCriteria doCall() {
                                    return this.doCall(null);
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _closure11.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }
                            }
                            return ((DetachedCriteria)((Closure)this.getOwner()).getDelegate()).and((Closure)new _closure11((Object)this, this.getThisObject()));
                        }
                        return (DetachedCriteria)ScriptBytecodeAdapter.castToType(null, DetachedCriteria.class);
                    }

                    @Generated
                    public boolean getCustArea() {
                        return DefaultTypeTransformation.booleanUnbox((Object)this.custArea.get());
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public DetachedCriteria doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure10.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                return ((DetachedCriteria)this.getDelegate()).or((Closure)new _closure10((Object)this, this.getThisObject(), this.custArea));
            }

            @Generated
            public Object getActLinkExists() {
                return this.actLinkExists.get();
            }

            @Generated
            public boolean getCustArea() {
                return DefaultTypeTransformation.booleanUnbox((Object)this.custArea.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public DetachedCriteria doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _zzzgetActivityByLinkedCriteria_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return Activity.query(new _zzzgetActivityByLinkedCriteria_closure6((Object)this, (Object)this, actLinkExists, custArea2));
    }

    public PlatformTransactionManager getTransactionManager() {
        if (this.$transactionManager != null) {
            return this.$transactionManager;
        }
        return GormEnhancer.findSingleTransactionManager();
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        PlatformTransactionManager platformTransactionManager;
        this.$transactionManager = platformTransactionManager = transactionManager;
    }

    @Autowired(required=false)
    public void setTargetDatastore(Datastore ... datastores) {
        Datastore datastore;
        this.$targetDatastore = datastore = RuntimeSupport.findDefaultDatastore((Datastore[])datastores);
        if (RuntimeSupport.findDefaultDatastore((Datastore[])datastores) != null) {
            PlatformTransactionManager platformTransactionManager;
            this.$transactionManager = platformTransactionManager = ((TransactionCapableDatastore)ScriptBytecodeAdapter.castToType((Object)RuntimeSupport.findDefaultDatastore((Datastore[])datastores), TransactionCapableDatastore.class)).getTransactionManager();
        }
    }

    protected Datastore getTargetDatastore(String connectionName) {
        if (this.$targetDatastore != null) {
            return (Datastore)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodN(ActivityRepo.class, (Object)this.$targetDatastore, (String)"getDatastoreForConnection", (Object[])new Object[]{connectionName}), Datastore.class);
        }
        return (Datastore)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodN(ActivityRepo.class, (Object)GormEnhancer.findSingleDatastore(), (String)"getDatastoreForConnection", (Object[])new Object[]{connectionName}), Datastore.class);
    }

    protected Datastore getTargetDatastore() {
        if (this.$targetDatastore != null) {
            return this.$targetDatastore;
        }
        return GormEnhancer.findSingleDatastore();
    }

    protected Activity $tt__createTodo(Org org, Long userId, String name, String linkedEntity, List<Long> linkedIds, LocalDateTime dueDate, TransactionStatus transactionStatus) {
        Activity activity = (Activity)ScriptBytecodeAdapter.castToType((Object)this.create(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"org", org, "name", name, "kind", Activity.Kind.Todo})), Activity.class);
        if (DefaultTypeTransformation.booleanUnbox(linkedIds)) {
            Long linkedId = null;
            Iterator<Long> iterator = linkedIds.iterator();
            while (iterator.hasNext()) {
                String string;
                Long l;
                Activity activity2;
                linkedId = (Long)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Long.class);
                ActivityLink activityLink = new ActivityLink();
                activityLink.setActivity(activity2);
                activityLink.setLinkedId(l);
                activityLink.setLinkedEntity(string);
                ActivityLink activityLink2 = activityLink;
                activityLink2.persist();
            }
        }
        Task task = new Task();
        TaskType taskType = TaskType.getTODO();
        task.setTaskType(taskType);
        Long l = userId;
        task.setUserId(l);
        LocalDateTime localDateTime = dueDate;
        task.setDueDate(localDateTime);
        TaskStatus taskStatus = TaskStatus.getOPEN();
        task.setStatus(taskStatus);
        Task task2 = task;
        activity.setTask(task2);
        activity.persist();
        return activity;
    }

    protected boolean $tt__hasActivityWithAttachments(Persistable<Long> linkedEntity, Activity.Kind kind, TransactionStatus transactionStatus) {
        Reference kind2 = new Reference((Object)kind);
        Reference actLinkExists = new Reference(this.getActivityLinkCriteria((Long)ScriptBytecodeAdapter.castToType((Object)linkedEntity.getId(), Long.class), linkedEntity.getClass().getSimpleName()));
        public final class __tt__hasActivityWithAttachments_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference kind;
            private /* synthetic */ Reference actLinkExists;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __tt__hasActivityWithAttachments_closure7(Object _outerInstance, Object _thisObject, Reference kind, Reference actLinkExists) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.kind = reference2 = kind;
                this.actLinkExists = reference = actLinkExists;
            }

            public DetachedCriteria doCall(Object it) {
                ((AbstractDetachedCriteria)this.getDelegate()).setAlias("activity_");
                if (this.kind.get() != null) {
                    ((MangoDetachedCriteria)this.getDelegate()).eq("kind", this.kind.get());
                }
                return ((DetachedCriteria)this.getDelegate()).exists((QueryableCriteria)((DetachedCriteria)this.actLinkExists.get()).id());
            }

            @Generated
            public Activity.Kind getKind() {
                return (Activity.Kind)ShortTypeHandling.castToEnum((Object)this.kind.get(), Activity.Kind.class);
            }

            @Generated
            public Object getActLinkExists() {
                return this.actLinkExists.get();
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public DetachedCriteria doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __tt__hasActivityWithAttachments_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        MangoDetachedCriteria<Activity> laQuery = Activity.query(new __tt__hasActivityWithAttachments_closure7((Object)this, (Object)this, kind2, actLinkExists));
        public final class __tt__hasActivityWithAttachments_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __tt__hasActivityWithAttachments_closure8(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public MangoDetachedCriteria doCall(Object it) {
                ((AbstractDetachedCriteria)this.getDelegate()).setAlias("attachLink");
                ((MangoDetachedCriteria)this.getDelegate()).eqProperty("linkedId", "activity_.id");
                return ((MangoDetachedCriteria)this.getDelegate()).eq("linkedEntity", (Object)"Activity");
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public MangoDetachedCriteria doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __tt__hasActivityWithAttachments_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        MangoDetachedCriteria<AttachmentLink> attachExists = AttachmentLink.query(new __tt__hasActivityWithAttachments_closure8((Object)this, (Object)this));
        return DefaultTypeTransformation.booleanUnbox((Object)laQuery.exists((QueryableCriteria)attachExists.id()).count());
    }

    public static /* synthetic */ ActivityLinkRepo pfaccess$0(ActivityRepo $that) {
        return $that.activityLinkRepo;
    }

    public static /* synthetic */ CurrentUser pfaccess$1(ActivityRepo $that) {
        return $that.currentUser;
    }

    @Generated
    public ActivityNote addNote(Activity act, String body) {
        CallSite[] callSiteArray = ActivityRepo.$getCallSiteArray();
        return this.addNote(act, body, "plain");
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @Generated
    public Activity createTodo(Org org, Long userId, String name, String linkedEntity, List<Long> linkedIds) {
        void var3_3;
        void var2_2;
        Reference org2 = new Reference((Object)org);
        Reference userId2 = new Reference((Object)var2_2);
        Reference name2 = new Reference((Object)var3_3);
        Reference linkedEntity2 = new Reference((Object)linkedEntity);
        Reference linkedIds2 = new Reference(linkedIds);
        CallSite[] callSiteArray = ActivityRepo.$getCallSiteArray();
        return this.createTodo((Org)org2.get(), (Long)userId2.get(), (String)name2.get(), (String)linkedEntity2.get(), (List)linkedIds2.get(), (LocalDateTime)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(LocalDateTime.class), LocalDateTime.class));
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @Generated
    public Activity createTodo(Org org, Long userId, String name, String linkedEntity) {
        void var3_3;
        void var2_2;
        Reference org2 = new Reference((Object)org);
        Reference userId2 = new Reference((Object)var2_2);
        Reference name2 = new Reference((Object)var3_3);
        Reference linkedEntity2 = new Reference((Object)linkedEntity);
        CallSite[] callSiteArray = ActivityRepo.$getCallSiteArray();
        return this.createTodo((Org)org2.get(), (Long)userId2.get(), (String)name2.get(), (String)linkedEntity2.get(), null, (LocalDateTime)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].call(LocalDateTime.class), LocalDateTime.class));
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @Generated
    public Activity createTodo(Org org, Long userId, String name) {
        void var3_3;
        void var2_2;
        Reference org2 = new Reference((Object)org);
        Reference userId2 = new Reference((Object)var2_2);
        Reference name2 = new Reference((Object)var3_3);
        CallSite[] callSiteArray = ActivityRepo.$getCallSiteArray();
        return this.createTodo((Org)org2.get(), (Long)userId2.get(), (String)name2.get(), null, null, (LocalDateTime)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].call(LocalDateTime.class), LocalDateTime.class));
    }

    @ReadOnly
    @Generated
    public boolean hasActivityWithAttachments(Persistable<Long> linkedEntity) {
        Reference linkedEntity2 = new Reference(linkedEntity);
        CallSite[] callSiteArray = ActivityRepo.$getCallSiteArray();
        return this.hasActivityWithAttachments((Persistable<Long>)((Persistable)linkedEntity2.get()), null);
    }

    @Deprecated
    @Generated
    public DetachedCriteria<Activity> zzzgetActivityByLinkedCriteria(Long linkedId, String linkedEntity) {
        CallSite[] callSiteArray = ActivityRepo.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.zzzgetActivityByLinkedCriteria(linkedId, linkedEntity, false);
        }
        return this.zzzgetActivityByLinkedCriteria(linkedId, linkedEntity, false);
    }

    @Generated
    protected Activity $tt__createTodo(Org org, Long userId, String name, String linkedEntity, List<Long> linkedIds, TransactionStatus transactionStatus) {
        CallSite[] callSiteArray = ActivityRepo.$getCallSiteArray();
        return this.$tt__createTodo(org, userId, name, linkedEntity, linkedIds, (LocalDateTime)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].call(LocalDateTime.class), LocalDateTime.class), transactionStatus);
    }

    @Generated
    protected Activity $tt__createTodo(Org org, Long userId, String name, String linkedEntity, TransactionStatus transactionStatus) {
        CallSite[] callSiteArray = ActivityRepo.$getCallSiteArray();
        return this.$tt__createTodo(org, userId, name, linkedEntity, null, (LocalDateTime)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].call(LocalDateTime.class), LocalDateTime.class), transactionStatus);
    }

    @Generated
    protected Activity $tt__createTodo(Org org, Long userId, String name, TransactionStatus transactionStatus) {
        CallSite[] callSiteArray = ActivityRepo.$getCallSiteArray();
        return this.$tt__createTodo(org, userId, name, null, null, (LocalDateTime)ScriptBytecodeAdapter.castToType((Object)callSiteArray[5].call(LocalDateTime.class), LocalDateTime.class), transactionStatus);
    }

    @Generated
    protected boolean $tt__hasActivityWithAttachments(Persistable<Long> linkedEntity, TransactionStatus transactionStatus) {
        CallSite[] callSiteArray = ActivityRepo.$getCallSiteArray();
        return this.$tt__hasActivityWithAttachments(linkedEntity, null, transactionStatus);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != ActivityRepo.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public ActivityLinkRepo getActivityLinkRepo() {
        return this.activityLinkRepo;
    }

    @Generated
    public void setActivityLinkRepo(ActivityLinkRepo activityLinkRepo) {
        this.activityLinkRepo = activityLinkRepo;
    }

    @Generated
    public AttachmentRepo getAttachmentRepo() {
        return this.attachmentRepo;
    }

    @Generated
    public void setAttachmentRepo(AttachmentRepo attachmentRepo) {
        this.attachmentRepo = attachmentRepo;
    }

    @Generated
    public CurrentUser getCurrentUser() {
        return this.currentUser;
    }

    @Generated
    public void setCurrentUser(CurrentUser currentUser) {
        this.currentUser = currentUser;
    }

    @Generated
    public ProblemHandler getProblemHandler() {
        return this.problemHandler;
    }

    @Generated
    public void setProblemHandler(ProblemHandler problemHandler) {
        this.problemHandler = problemHandler;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "now";
        stringArray[1] = "now";
        stringArray[2] = "now";
        stringArray[3] = "now";
        stringArray[4] = "now";
        stringArray[5] = "now";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[6];
        ActivityRepo.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ActivityRepo.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ActivityRepo.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

