/*
 * Decompiled with CFR 0.152.
 */
package yakworks.rally.attachment.repo;

import gorm.tools.databinding.BindAction;
import gorm.tools.mango.MangoDetachedCriteria;
import gorm.tools.mango.api.QueryArgs;
import gorm.tools.model.Persistable;
import gorm.tools.repository.GormRepository;
import gorm.tools.repository.PersistArgs;
import gorm.tools.repository.events.AfterBindEvent;
import gorm.tools.repository.events.BeforeBindEvent;
import gorm.tools.repository.events.BeforeRemoveEvent;
import gorm.tools.repository.events.RepoListener;
import gorm.tools.repository.model.LongIdGormRepo;
import gorm.tools.validation.Rejector;
import grails.artefact.Artefact;
import grails.gorm.DetachedCriteria;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.lang.ref.SoftReference;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.grails.datastore.gorm.GormValidateable;
import org.grails.datastore.mapping.query.api.QueryableCriteria;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;
import yakworks.commons.io.PathTools;
import yakworks.rally.attachment.AttachmentSupport;
import yakworks.rally.attachment.model.Attachment;
import yakworks.rally.attachment.model.FileData;
import yakworks.rally.attachment.repo.AttachmentLinkRepo;
import yakworks.rally.tag.model.TagLink;

@GormRepository
@Artefact(value="Repository")
@Component
public class AttachmentRepo
extends LongIdGormRepo<Attachment> {
    public static final String ATTACHMENT_LOCATION_KEY = "attachments.location";
    @Autowired(required=false)
    private AttachmentSupport attachmentSupport;
    @Autowired(required=false)
    private AttachmentLinkRepo attachmentLinkRepo;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public AttachmentRepo() {
    }

    public void bindAndCreate(Attachment attachment, Map data, PersistArgs args) {
        try {
            this.bindAndSave(attachment, data, BindAction.Create, args);
        }
        catch (Exception e) {
            Path attachedFile = (Path)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.getAt((Map)data, (Object)"attachedFile"), Path.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)attachedFile)) {
                Files.deleteIfExists(attachedFile);
            }
            throw (Throwable)e;
        }
    }

    public void doAfterPersistWithData(Attachment attachment, PersistArgs args) {
        Map data = args.getData();
        if (DefaultTypeTransformation.booleanUnbox(data.get("tags"))) {
            TagLink.addOrRemoveTags((Persistable)attachment, data.get("tags"));
        }
    }

    @RepoListener
    public void beforeBind(Attachment attachment, Map p, BeforeBindEvent ev) {
        if (ev.isBindCreate()) {
            this.generateId((Persistable)attachment);
            if (!DefaultTypeTransformation.booleanUnbox(p.get("name"))) {
                Object v = p.get("originalFileName");
                ScriptBytecodeAdapter.setProperty(v, null, (Object)p, (String)"name");
            }
            if (!DefaultTypeTransformation.booleanUnbox(p.get("name"))) {
                Rejector.of((GormValidateable)attachment).withNotNullError("name");
                return;
            }
            if (!DefaultTypeTransformation.booleanUnbox(p.get("mimeType"))) {
                String string = PathTools.extractMimeType((String)((String)ScriptBytecodeAdapter.asType(p.get("name"), String.class)));
                ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)p, (String)"mimeType");
            }
            if (!DefaultTypeTransformation.booleanUnbox(p.get("extension"))) {
                String string = PathTools.getExtension((String)((String)ScriptBytecodeAdapter.asType(p.get("name"), String.class)));
                ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)p, (String)"extension");
            }
            if (DefaultTypeTransformation.booleanUnbox(p.get("isCreditFile"))) {
                String string = "attachments.creditFiles.location";
                ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)p, (String)"locationKey");
            }
        }
        if (ev.isBindUpdate() && DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.getAt((Map)p, (Object)"fileData.data")) && DefaultGroovyMethods.getAt((Map)p, (Object)"fileData.data") instanceof String) {
            String fdata = (String)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.getAt((Map)p, (Object)"fileData.data"), String.class);
            int n = DefaultGroovyMethods.size((byte[])fdata.getBytes());
            ScriptBytecodeAdapter.setProperty((Object)n, null, (Object)p, (String)"contentLength");
            byte[] byArray = fdata.getBytes();
            ScriptBytecodeAdapter.invokeMethodN(AttachmentRepo.class, (Object)p, (String)"putAt", (Object[])new Object[]{"fileData.data", byArray});
        }
    }

    @RepoListener
    public void afterBind(Attachment attachment, Map p, AfterBindEvent ev) {
        if (ev.isBindCreate()) {
            Boolean bl = attachment.hasErrors();
            if (bl == null ? false : bl) {
                return;
            }
            Path attachedFile = this.createFile(attachment, p);
            if (DefaultTypeTransformation.booleanUnbox((Object)attachedFile)) {
                Path path = attachedFile;
                ScriptBytecodeAdapter.setProperty((Object)path, null, (Object)p, (String)"attachedFile");
                String string = this.attachmentSupport.getRelativePath(attachedFile, attachment.getLocationKey());
                attachment.setLocation(string);
                long l = Files.size(attachedFile);
                attachment.setContentLength(l);
            } else {
                FileData fileData = attachment.getFileData();
                if (DefaultTypeTransformation.booleanUnbox((Object)(fileData != null ? fileData.getData() : null))) {
                    int n = DefaultGroovyMethods.size((byte[])attachment.getFileData().getData());
                    attachment.setContentLength((Long)ScriptBytecodeAdapter.castToType((Object)n, Long.class));
                }
            }
        }
    }

    @RepoListener
    public void beforeRemove(Attachment attachment, BeforeRemoveEvent e) {
        if (DefaultTypeTransformation.booleanUnbox((Object)attachment.getLocation())) {
            this.attachmentSupport.deleteFile(attachment.getLocation(), attachment.getLocationKey());
        }
        this.attachmentLinkRepo.remove((Persistable)attachment);
        TagLink.remove((Persistable)attachment);
    }

    public MangoDetachedCriteria<Attachment> query(QueryArgs queryArgs, @DelegatesTo(value=MangoDetachedCriteria.class) Closure closure) {
        Map criteriaMap = queryArgs.getqCriteria();
        DetachedCriteria tagExistsCrit = TagLink.getExistsCriteria(criteriaMap, Attachment.class, "attachment_.id");
        MangoDetachedCriteria detCrit = this.getMangoQuery().query(Attachment.class, queryArgs, closure);
        if (tagExistsCrit != null) {
            detCrit.exists((QueryableCriteria)tagExistsCrit.id());
        }
        return detCrit;
    }

    public void removeAttachment(Persistable entity, Attachment attachment) {
        this.attachmentLinkRepo.remove(entity, (Persistable)attachment);
        attachment.remove();
    }

    public Path createFile(Attachment attachment, Map p) {
        String fileName = (String)ScriptBytecodeAdapter.asType(p.get("name"), String.class);
        if (DefaultTypeTransformation.booleanUnbox(p.get("tempFileName"))) {
            return this.attachmentSupport.createFileFromTempFile((Long)ScriptBytecodeAdapter.castToType((Object)attachment.getId(), Long.class), fileName, (String)ScriptBytecodeAdapter.asType(p.get("tempFileName"), String.class), attachment.getLocationKey());
        }
        if (DefaultTypeTransformation.booleanUnbox(p.get("sourcePath"))) {
            return this.attachmentSupport.createFileFromSource((Long)ScriptBytecodeAdapter.castToType((Object)attachment.getId(), Long.class), fileName, (Path)ScriptBytecodeAdapter.asType(p.get("sourcePath"), Path.class), attachment.getLocationKey());
        }
        if (DefaultTypeTransformation.booleanUnbox(p.get("multipartFile"))) {
            MultipartFile multipartFile = (MultipartFile)ScriptBytecodeAdapter.asType(p.get("multipartFile"), MultipartFile.class);
            Path tempFile = this.attachmentSupport.createTempFile(fileName, null);
            multipartFile.transferTo(tempFile);
            return this.attachmentSupport.createFileFromTempFile((Long)ScriptBytecodeAdapter.castToType((Object)attachment.getId(), Long.class), fileName, tempFile.getFileName().toString(), attachment.getLocationKey());
        }
        if (DefaultTypeTransformation.booleanUnbox(p.get("bytes")) && p.get("bytes") instanceof byte[]) {
            return this.attachmentSupport.createFileFromBytes((Long)ScriptBytecodeAdapter.castToType((Object)attachment.getId(), Long.class), fileName, (byte[])ScriptBytecodeAdapter.asType(p.get("bytes"), byte[].class), attachment.getLocationKey());
        }
        return (Path)ScriptBytecodeAdapter.castToType(null, Path.class);
    }

    public Attachment create(MultipartFile multipartFile, Map params) {
        String string = multipartFile.getOriginalFilename();
        ScriptBytecodeAdapter.invokeMethodN(AttachmentRepo.class, (Object)params, (String)"putAt", (Object[])new Object[]{"name", string});
        MultipartFile multipartFile2 = multipartFile;
        ScriptBytecodeAdapter.invokeMethodN(AttachmentRepo.class, (Object)params, (String)"putAt", (Object[])new Object[]{"multipartFile", multipartFile2});
        return (Attachment)ScriptBytecodeAdapter.castToType((Object)this.create(params), Attachment.class);
    }

    public Attachment create(Path sourcePath, String name, Map data) {
        Path path = sourcePath;
        ScriptBytecodeAdapter.invokeMethodN(AttachmentRepo.class, (Object)data, (String)"putAt", (Object[])new Object[]{"sourcePath", path});
        String string = name;
        ScriptBytecodeAdapter.invokeMethodN(AttachmentRepo.class, (Object)data, (String)"putAt", (Object[])new Object[]{"name", string});
        return (Attachment)ScriptBytecodeAdapter.castToType((Object)this.create(data), Attachment.class);
    }

    public Resource getResource(Attachment attachment) {
        return this.attachmentSupport.getResource(attachment);
    }

    public Path getFile(Attachment attachment) {
        return this.attachmentSupport.getFile(attachment.getLocation(), attachment.getLocationKey());
    }

    public String getDownloadUrl(Attachment attachment) {
        return this.attachmentSupport.getDownloadUrl(attachment);
    }

    public Attachment copy(Attachment source) {
        Reference source2 = new Reference((Object)source);
        if ((Attachment)source2.get() == null) {
            return (Attachment)ScriptBytecodeAdapter.castToType(null, Attachment.class);
        }
        Reference params = new Reference((Object)((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class)));
        public final class _copy_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference params;
            private /* synthetic */ Reference source;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _copy_closure1(Object _outerInstance, Object _thisObject, Reference params, Reference source) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.params = reference2 = params;
                this.source = reference = source;
            }

            public Object doCall(String prop) {
                Object object = DefaultGroovyMethods.getAt((Object)this.source.get(), (String)prop);
                ScriptBytecodeAdapter.invokeMethodN(_copy_closure1.class, (Object)this.params.get(), (String)"putAt", (Object[])new Object[]{prop, object});
                return object;
            }

            @Generated
            public Object call(String prop) {
                return this.doCall(prop);
            }

            @Generated
            public Map getParams() {
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.params.get(), Map.class);
            }

            @Generated
            public Attachment getSource() {
                return (Attachment)ScriptBytecodeAdapter.castToType((Object)this.source.get(), Attachment.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _copy_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((List)ScriptBytecodeAdapter.createList((Object[])new Object[]{"name", "description", "mimeType", "kind", "subject", "locationKey"}), (Closure)new _copy_closure1((Object)this, (Object)this, params, source2));
        if (DefaultTypeTransformation.booleanUnbox((Object)((Attachment)source2.get()).getLocation())) {
            Path path = this.getFile((Attachment)source2.get());
            ScriptBytecodeAdapter.setProperty((Object)path, null, (Object)((LinkedHashMap)params.get()), (String)"sourcePath");
        } else {
            FileData fileData = ((Attachment)source2.get()).getFileData();
            if (DefaultTypeTransformation.booleanUnbox((Object)(fileData != null ? fileData.getData() : null))) {
                Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"data", ((Attachment)source2.get()).getFileData().getData()});
                ScriptBytecodeAdapter.setProperty((Object)map, null, (Object)((LinkedHashMap)params.get()), (String)"fileData");
            }
        }
        Attachment copy = (Attachment)ScriptBytecodeAdapter.castToType((Object)this.create((LinkedHashMap)params.get()), Attachment.class);
        return copy;
    }

    @Generated
    public Attachment create(Path sourcePath, String name) {
        CallSite[] callSiteArray = AttachmentRepo.$getCallSiteArray();
        return this.create(sourcePath, name, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != AttachmentRepo.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"yakworks.rally.attachment.repo.AttachmentRepo");
    }

    @Generated
    public AttachmentSupport getAttachmentSupport() {
        return this.attachmentSupport;
    }

    @Generated
    public void setAttachmentSupport(AttachmentSupport attachmentSupport) {
        this.attachmentSupport = attachmentSupport;
    }

    @Generated
    public AttachmentLinkRepo getAttachmentLinkRepo() {
        return this.attachmentLinkRepo;
    }

    @Generated
    public void setAttachmentLinkRepo(AttachmentLinkRepo attachmentLinkRepo) {
        this.attachmentLinkRepo = attachmentLinkRepo;
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[]{};
        return new CallSiteArray(AttachmentRepo.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = AttachmentRepo.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

