/*
 * Decompiled with CFR 0.152.
 */
package yakworks.rally.orgs.repo;

import gorm.tools.databinding.BindAction;
import gorm.tools.mango.MangoDetachedCriteria;
import gorm.tools.mango.api.QueryArgs;
import gorm.tools.model.Persistable;
import gorm.tools.repository.GormRepo;
import gorm.tools.repository.GormRepository;
import gorm.tools.repository.PersistArgs;
import gorm.tools.repository.events.AfterBindEvent;
import gorm.tools.repository.events.AfterPersistEvent;
import gorm.tools.repository.events.BeforeRemoveEvent;
import gorm.tools.repository.events.RepoListener;
import gorm.tools.repository.model.LongIdGormRepo;
import gorm.tools.utils.GormUtils;
import grails.artefact.Artefact;
import grails.gorm.DetachedCriteria;
import grails.gorm.transactions.GrailsTransactionTemplate;
import grails.gorm.transactions.Transactional;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.lang.IntRange;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import jakarta.annotation.Nullable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.datastore.gorm.GormEnhancer;
import org.grails.datastore.gorm.internal.RuntimeSupport;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.query.api.QueryableCriteria;
import org.grails.datastore.mapping.transactions.CustomizableRollbackTransactionAttribute;
import org.grails.datastore.mapping.transactions.TransactionCapableDatastore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import yakworks.api.problem.data.DataProblemCodes;
import yakworks.commons.extensions.MapExtensions;
import yakworks.commons.map.Maps;
import yakworks.rally.activity.model.ActivityContact;
import yakworks.rally.orgs.model.Contact;
import yakworks.rally.orgs.model.ContactEmail;
import yakworks.rally.orgs.model.ContactFlex;
import yakworks.rally.orgs.model.ContactPhone;
import yakworks.rally.orgs.model.ContactSource;
import yakworks.rally.orgs.model.Location;
import yakworks.rally.orgs.model.Org;
import yakworks.rally.orgs.repo.ContactSourceRepo;
import yakworks.rally.orgs.repo.LocationRepo;
import yakworks.rally.tag.model.TagLink;
import yakworks.security.gorm.model.AppUser;

@GormRepository
@Artefact(value="Repository")
@Component
public class ContactRepo
extends LongIdGormRepo<Contact> {
    private static final String IS_PRIMARY = "isPrimary";
    @Inject
    @Nullable
    private LocationRepo locationRepo;
    @Inject
    @Nullable
    private ContactSourceRepo contactSourceRepo;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    protected PlatformTransactionManager $transactionManager;
    protected Datastore $targetDatastore;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public ContactRepo() {
    }

    @RepoListener
    public void beforeValidate(Contact contact) {
        this.setupNameProps(contact);
    }

    @RepoListener
    public void beforeRemove(Contact contact, BeforeRemoveEvent e) {
        AppUser user = contact.getUser();
        String hasRefName = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)user)) {
            String string;
            hasRefName = string = "User";
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)Org.query(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"contact", contact})).count())) {
            String string;
            hasRefName = string = "Org primary contact";
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)ActivityContact.getRepo().count((Persistable)contact))) {
            String string;
            hasRefName = string = "ActivityContact";
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)hasRefName)) {
            LinkedHashMap refArgs = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"stamp", new GStringImpl(new Object[]{contact.getName(), contact.getId()}, new String[]{"Contact: ", ", id: ", ""}), "other", hasRefName}), LinkedHashMap.class);
            throw (Throwable)DataProblemCodes.ReferenceKey.withArgs((Map)refArgs).toException();
        }
        TagLink.remove((Persistable)contact);
        Location.query(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"contact", contact})).deleteAll();
        ContactSource.query(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"contactId", contact.getId()})).deleteAll();
    }

    public void doBeforePersistWithData(Contact contact, PersistArgs args) {
        Map data = args.getData();
        if (ScriptBytecodeAdapter.compareEqual((Object)args.getBindAction(), (Object)BindAction.Create)) {
            this.setupSource(contact, data);
        }
        if (DefaultTypeTransformation.booleanUnbox(data.get("location"))) {
            this.createOrUpdateLocation(contact, (Map)ScriptBytecodeAdapter.asType(data.get("location"), Map.class));
        }
    }

    public void setupSource(Contact contact, Map data) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)contact.getId())) {
            Long l = this.generateId();
            contact.setId(l);
        }
        ContactSource contactSource = ContactSource.getRepo().createSource(contact, data);
        contact.setSource(contactSource);
    }

    public Contact lookup(Map data) {
        Contact contact;
        Contact contact2 = null;
        if (data == null) {
            Map map;
            data = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        }
        String sourceId = ShortTypeHandling.castToString((Object)Maps.value((Map)data, (String)"sourceId"));
        if (data.get("source") == null && DefaultTypeTransformation.booleanUnbox((Object)sourceId)) {
            Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"sourceId", sourceId});
            ScriptBytecodeAdapter.setProperty((Object)map, null, (Object)data, (String)"source");
        }
        if (DefaultTypeTransformation.booleanUnbox(data.get("source")) && DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.getAt(data.get("source"), (String)"sourceId"))) {
            Long cid = this.contactSourceRepo.findContactIdBySourceId((String)ScriptBytecodeAdapter.asType((Object)Maps.value((Map)data, (String)"source.sourceId"), String.class));
            if (DefaultTypeTransformation.booleanUnbox((Object)cid)) {
                return (Contact)ScriptBytecodeAdapter.castToType((Object)this.get(cid), Contact.class);
            }
        } else if (DefaultTypeTransformation.booleanUnbox(data.get("num"))) {
            String num = ShortTypeHandling.castToString((Object)Maps.value((Map)data, (String)"num"));
            List<Contact> contactForNum = Contact.findAllWhere(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"num", num}));
            List<Contact> list = contactForNum;
            if (ScriptBytecodeAdapter.compareEqual((Object)(list != null ? Integer.valueOf(list.size()) : null), (Object)1)) {
                Object object = DefaultGroovyMethods.getAt(contactForNum, (int)0);
                contact2 = (Contact)ScriptBytecodeAdapter.castToType((Object)object, Contact.class);
            } else if (contactForNum.size() > 1) {
                throw (Throwable)new DataRetrievalFailureException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{data.get("num")}, new String[]{"Multiple Contacts found for num: ", ", lookup key must return a unique Contact"})));
            }
        }
        return (Contact)ScriptBytecodeAdapter.castToType((Object)this.load((contact = contact2) != null ? contact.getId() : null), Contact.class);
    }

    @RepoListener
    public void afterBind(Contact contact, Map data, AfterBindEvent e) {
        this.assignOrg(contact, data);
    }

    @RepoListener
    public void afterPersist(Contact contact, AfterPersistEvent e) {
        Location location = contact.getLocation();
        Boolean bl = location != null ? Boolean.valueOf(location.hasChanged()) : null;
        if (bl == null ? false : bl) {
            contact.getLocation().persist();
        }
        this.syncChangesToUser(contact);
    }

    public void doAfterPersistWithData(Contact contact, PersistArgs args) {
        Map data = args.getData();
        if (MapExtensions.getBoolean((Map)data, (Object)IS_PRIMARY)) {
            Org org = Org.get(contact.getOrgId());
            Contact contact2 = contact;
            org.setContact(contact2);
            org.persist();
        }
        if (DefaultTypeTransformation.booleanUnbox(data.get("locations"))) {
            super.persistToManyData((Object)contact, (GormRepo)Location.getRepo(), (List)ScriptBytecodeAdapter.asType(data.get("locations"), List.class), "contact");
        }
        if (DefaultTypeTransformation.booleanUnbox(data.get("phones"))) {
            super.persistToManyData((Object)contact, ContactPhone.getRepo(), (List)ScriptBytecodeAdapter.asType(data.get("phones"), List.class), "contact");
        }
        if (DefaultTypeTransformation.booleanUnbox(data.get("emails"))) {
            super.persistToManyData((Object)contact, ContactEmail.getRepo(), (List)ScriptBytecodeAdapter.asType(data.get("emails"), List.class), "contact");
        }
        if (data.get("tags") != null) {
            TagLink.addOrRemoveTags((Persistable)contact, data.get("tags"));
        }
    }

    public MangoDetachedCriteria<Contact> query(QueryArgs queryArgs, @DelegatesTo(value=MangoDetachedCriteria.class) Closure closure) {
        Map criteriaMap = queryArgs.getqCriteria();
        DetachedCriteria tagExistsCrit = TagLink.getExistsCriteria(criteriaMap, Contact.class, "contact_.id");
        MangoDetachedCriteria detCrit = this.getMangoQuery().query(Contact.class, queryArgs, closure);
        if (tagExistsCrit != null) {
            detCrit.exists((QueryableCriteria)tagExistsCrit.id());
        }
        return detCrit;
    }

    public void removeAll(Org org) {
        this.gormStaticApi().executeUpdate((CharSequence)"DELETE FROM Contact WHERE org=:org", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"org", org}));
    }

    public void syncChangesToUser(Contact contact) {
        AppUser user = contact.getUser();
        if (DefaultTypeTransformation.booleanUnbox((Object)user)) {
            if (contact.hasChanged("email")) {
                String string = contact.getEmail();
                user.setEmail(string);
            }
            if (contact.hasChanged("name") && ScriptBytecodeAdapter.compareNotEqual((Object)contact.getUser().getName(), (Object)contact.getName())) {
                String string = contact.getName();
                user.setName(string);
            }
            if (user.hasChanged()) {
                user.persist();
            }
        }
    }

    public void setupNameProps(Contact c) {
        if (c.isNew() && !DefaultTypeTransformation.booleanUnbox((Object)c.getFirstName()) && DefaultTypeTransformation.booleanUnbox((Object)c.getName())) {
            String string = c.getName();
            c.setFirstName(string);
        }
        this.concatName(c);
    }

    public void concatName(Contact c) {
        String string = c.getFirstName();
        String string2 = StringGroovyMethods.plus((String)(DefaultTypeTransformation.booleanUnbox((Object)string) ? string : ""), (CharSequence)" ");
        String string3 = c.getLastName();
        String fullName = StringGroovyMethods.plus((String)string2, (CharSequence)(DefaultTypeTransformation.booleanUnbox((Object)string3) ? string3 : "")).trim();
        String string4 = StringGroovyMethods.size((CharSequence)fullName) > 50 ? StringGroovyMethods.getAt((String)fullName, (IntRange)new IntRange(true, 0, 49)) : fullName;
        c.setName(string4);
    }

    public void assignOrg(Contact contact, Map data) {
        if (!DefaultTypeTransformation.booleanUnbox(data.get("orgId"))) {
            if (DefaultTypeTransformation.booleanUnbox(data.get("org")) && data.get("org") instanceof Map) {
                Object object = Org.getRepo().findWithData((Map)ScriptBytecodeAdapter.asType(data.get("org"), Map.class));
                Long l = object != null ? ((Org)object).getId() : null;
                contact.setOrgId(l);
            } else if (DefaultTypeTransformation.booleanUnbox(data.get("org")) && data.get("org") instanceof Org) {
                Long l = ((Org)ScriptBytecodeAdapter.castToType(data.get("org"), Org.class)).getId();
                contact.setOrgId(l);
            }
        }
    }

    public Location createOrUpdateLocation(Contact contact, Map data) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)data)) {
            return (Location)ScriptBytecodeAdapter.castToType(null, Location.class);
        }
        Long l = contact.getOrgId();
        ScriptBytecodeAdapter.setProperty((Object)l, null, (Object)data, (String)"orgId");
        Contact contact2 = contact;
        ScriptBytecodeAdapter.setProperty((Object)contact2, null, (Object)data, (String)"contact");
        Object object = this.locationRepo.createOrUpdateItem(data);
        contact.setLocation((Location)ScriptBytecodeAdapter.castToType((Object)object, Location.class));
        return contact.getLocation();
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public AppUser buildUserFromContact(Contact contact, String password) {
        void var2_2;
        Reference contact2 = new Reference((Object)contact);
        Reference password2 = new Reference((Object)var2_2);
        CustomizableRollbackTransactionAttribute $transactionAttribute = new CustomizableRollbackTransactionAttribute();
        String string = "yakworks.rally.orgs.repo.ContactRepo.buildUserFromContact";
        $transactionAttribute.setName(string);
        GrailsTransactionTemplate $transactionTemplate = new GrailsTransactionTemplate(this.getTransactionManager(), $transactionAttribute);
        public final class _buildUserFromContact_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference contact;
            private /* synthetic */ Reference password;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildUserFromContact_closure1(Object _outerInstance, Object _thisObject, Reference contact, Reference password) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.contact = reference2 = contact;
                this.password = reference = password;
            }

            public AppUser doCall(TransactionStatus transactionStatus) {
                return (AppUser)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethodSafe((Object)((Object)((ContactRepo)((Object)this.getThisObject()))), (String)"$tt__buildUserFromContact", (Object)new Object[]{this.contact.get(), this.password.get(), transactionStatus}), AppUser.class);
            }

            @Generated
            public AppUser call(TransactionStatus transactionStatus) {
                return this.doCall(transactionStatus);
            }

            @Generated
            public Contact getContact() {
                return (Contact)ScriptBytecodeAdapter.castToType((Object)this.contact.get(), Contact.class);
            }

            @Generated
            public String getPassword() {
                return ShortTypeHandling.castToString((Object)this.password.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildUserFromContact_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (AppUser)$transactionTemplate.execute((Closure)new _buildUserFromContact_closure1((Object)this, (Object)this, contact2, password2));
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public Contact copy(Contact from, Contact toContat) {
        void var2_2;
        Reference from2 = new Reference((Object)from);
        Reference toContat2 = new Reference((Object)var2_2);
        CustomizableRollbackTransactionAttribute $transactionAttribute = new CustomizableRollbackTransactionAttribute();
        String string = "yakworks.rally.orgs.repo.ContactRepo.copy";
        $transactionAttribute.setName(string);
        GrailsTransactionTemplate $transactionTemplate = new GrailsTransactionTemplate(this.getTransactionManager(), $transactionAttribute);
        public final class _copy_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference from;
            private /* synthetic */ Reference toContat;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _copy_closure2(Object _outerInstance, Object _thisObject, Reference from, Reference toContat) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.from = reference2 = from;
                this.toContat = reference = toContat;
            }

            public Contact doCall(TransactionStatus transactionStatus) {
                return (Contact)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethodSafe((Object)((Object)((ContactRepo)((Object)this.getThisObject()))), (String)"$tt__copy", (Object)new Object[]{this.from.get(), this.toContat.get(), transactionStatus}), Contact.class);
            }

            @Generated
            public Contact call(TransactionStatus transactionStatus) {
                return this.doCall(transactionStatus);
            }

            @Generated
            public Contact getFrom() {
                return (Contact)ScriptBytecodeAdapter.castToType((Object)this.from.get(), Contact.class);
            }

            @Generated
            public Contact getToContat() {
                return (Contact)ScriptBytecodeAdapter.castToType((Object)this.toContat.get(), Contact.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _copy_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (Contact)$transactionTemplate.execute((Closure)new _copy_closure2((Object)this, (Object)this, from2, toContat2));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != ContactRepo.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public PlatformTransactionManager getTransactionManager() {
        if (this.$transactionManager != null) {
            return this.$transactionManager;
        }
        return GormEnhancer.findSingleTransactionManager();
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        PlatformTransactionManager platformTransactionManager;
        this.$transactionManager = platformTransactionManager = transactionManager;
    }

    @Autowired(required=false)
    public void setTargetDatastore(Datastore ... datastores) {
        Datastore datastore;
        this.$targetDatastore = datastore = RuntimeSupport.findDefaultDatastore((Datastore[])datastores);
        if (RuntimeSupport.findDefaultDatastore((Datastore[])datastores) != null) {
            PlatformTransactionManager platformTransactionManager;
            this.$transactionManager = platformTransactionManager = ((TransactionCapableDatastore)ScriptBytecodeAdapter.castToType((Object)RuntimeSupport.findDefaultDatastore((Datastore[])datastores), TransactionCapableDatastore.class)).getTransactionManager();
        }
    }

    protected Datastore getTargetDatastore(String connectionName) {
        if (this.$targetDatastore != null) {
            return (Datastore)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodN(ContactRepo.class, (Object)this.$targetDatastore, (String)"getDatastoreForConnection", (Object[])new Object[]{connectionName}), Datastore.class);
        }
        return (Datastore)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodN(ContactRepo.class, (Object)GormEnhancer.findSingleDatastore(), (String)"getDatastoreForConnection", (Object[])new Object[]{connectionName}), Datastore.class);
    }

    protected Datastore getTargetDatastore() {
        if (this.$targetDatastore != null) {
            return this.$targetDatastore;
        }
        return GormEnhancer.findSingleDatastore();
    }

    protected AppUser $tt__buildUserFromContact(Contact contact, String password, TransactionStatus transactionStatus) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)contact.getUser())) {
            AppUser appUser = new AppUser();
            String string = contact.getEmail();
            appUser.setUsername(string);
            String string2 = contact.getEmail();
            appUser.setEmail(string2);
            AppUser user = appUser;
            String string3 = password;
            user.setPassword(string3);
            Long l = contact.getId();
            user.setId(l);
            AppUser appUser2 = user;
            contact.setUser(appUser2);
            user.persist();
        }
        return contact.getUser();
    }

    protected Contact $tt__copy(Contact from, Contact toContat, TransactionStatus transactionStatus) {
        Reference toContat2 = new Reference((Object)toContat);
        if (from == null) {
            return (Contact)ScriptBytecodeAdapter.castToType(null, Contact.class);
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)((Contact)toContat2.get()).getId())) {
            Long l = Contact.getRepo().generateId();
            ((Contact)toContat2.get()).setId(l);
        }
        GormUtils.copyDomain((Object)((Contact)toContat2.get()), (Object)from);
        Object object = GormUtils.copyDomain(ContactFlex.class, (Object)ContactFlex.get((Long)ScriptBytecodeAdapter.asType((Object)from.getFlexId(), Long.class)), (Map)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"contact", (Contact)toContat2.get()}));
        ((Contact)toContat2.get()).setFlex((ContactFlex)ScriptBytecodeAdapter.castToType((Object)object, ContactFlex.class));
        if (DefaultTypeTransformation.booleanUnbox(from.getPhones())) {
            public final class __tt__copy_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference toContat;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public __tt__copy_closure3(Object _outerInstance, Object _thisObject, Reference toContat) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.toContat = reference = toContat;
                }

                public Contact doCall(ContactPhone p) {
                    return ((Contact)this.toContat.get()).addToPhones(GormUtils.copyDomain(ContactPhone.class, (Object)p, (Map)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"contact", this.toContat.get()})));
                }

                @Generated
                public Contact call(ContactPhone p) {
                    return this.doCall(p);
                }

                @Generated
                public Contact getToContat() {
                    return (Contact)ScriptBytecodeAdapter.castToType((Object)this.toContat.get(), Contact.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != __tt__copy_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each(from.getPhones(), (Closure)new __tt__copy_closure3((Object)this, (Object)this, toContat2));
        }
        if (DefaultTypeTransformation.booleanUnbox(from.getEmails())) {
            public final class __tt__copy_closure4
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference toContat;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public __tt__copy_closure4(Object _outerInstance, Object _thisObject, Reference toContat) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.toContat = reference = toContat;
                }

                public Contact doCall(ContactEmail e) {
                    return ((Contact)this.toContat.get()).addToEmails(GormUtils.copyDomain(ContactEmail.class, (Object)e, (Map)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"contact", this.toContat.get()})));
                }

                @Generated
                public Contact call(ContactEmail e) {
                    return this.doCall(e);
                }

                @Generated
                public Contact getToContat() {
                    return (Contact)ScriptBytecodeAdapter.castToType((Object)this.toContat.get(), Contact.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != __tt__copy_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each(from.getEmails(), (Closure)new __tt__copy_closure4((Object)this, (Object)this, toContat2));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)from.getSource())) {
            ContactSource source = (ContactSource)ScriptBytecodeAdapter.castToType((Object)GormUtils.copyDomain(ContactSource.class, (Object)from.getSource(), (Map)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"contactId", ((Contact)toContat2.get()).getId()})), ContactSource.class);
            source.persist();
            ContactSource contactSource = source;
            ((Contact)toContat2.get()).setSource(contactSource);
        }
        if (DefaultTypeTransformation.booleanUnbox(from.getLocations())) {
            public final class __tt__copy_closure5
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference toContat;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public __tt__copy_closure5(Object _outerInstance, Object _thisObject, Reference toContat) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.toContat = reference = toContat;
                }

                public Location doCall(Location l) {
                    Location c = (Location)ScriptBytecodeAdapter.castToType((Object)GormUtils.copyDomain(Location.class, (Object)l, (Map)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"org", ((Contact)this.toContat.get()).getOrg(), "contact", this.toContat.get()})), Location.class);
                    return c.persist();
                }

                @Generated
                public Location call(Location l) {
                    return this.doCall(l);
                }

                @Generated
                public Contact getToContat() {
                    return (Contact)ScriptBytecodeAdapter.castToType((Object)this.toContat.get(), Contact.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != __tt__copy_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each(from.getLocations(), (Closure)new __tt__copy_closure5((Object)this, (Object)this, toContat2));
        }
        return ((Contact)toContat2.get()).persist();
    }

    @Generated
    public LocationRepo getLocationRepo() {
        return this.locationRepo;
    }

    @Generated
    public void setLocationRepo(LocationRepo locationRepo) {
        this.locationRepo = locationRepo;
    }

    @Generated
    public ContactSourceRepo getContactSourceRepo() {
        return this.contactSourceRepo;
    }

    @Generated
    public void setContactSourceRepo(ContactSourceRepo contactSourceRepo) {
        this.contactSourceRepo = contactSourceRepo;
    }
}

