/*
 * Decompiled with CFR 0.152.
 */
package yakworks.rally.common;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import yakworks.commons.io.ZipUtils;
import yakworks.commons.lang.Validate;
import yakworks.etl.csv.CSVPathKeyMapReader;
import yakworks.etl.csv.CsvToMapTransformer;
import yakworks.rally.attachment.model.Attachment;

@Service
@Lazy
public class DefaultCsvToMapTransformer
implements CsvToMapTransformer,
GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public DefaultCsvToMapTransformer() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public List<Map> process(Map params) {
        Object v5;
        InputStream ins;
        List<Map> rows;
        block22: {
            Long attachmentId = (Long)ScriptBytecodeAdapter.asType(params.get("attachmentId"), Long.class);
            Object v = params.get("dataFilename");
            String dataFilename = ShortTypeHandling.castToString(DefaultTypeTransformation.booleanUnbox(v) ? v : "data.csv");
            Object v2 = params.get("headerPathDelimiter");
            String headerPathDelimiter = ShortTypeHandling.castToString(DefaultTypeTransformation.booleanUnbox(v2) ? v2 : ".");
            rows = null;
            ins = this.getInputStream(attachmentId, dataFilename);
            Throwable __$$primaryExc0 = null;
            try {
                try {
                    List<Map> list;
                    rows = list = this.processRows(ins, headerPathDelimiter);
                }
                catch (Throwable __$$t0) {
                    Throwable throwable;
                    __$$primaryExc0 = throwable = __$$t0;
                    throw __$$t0;
                }
                if (!(__$$primaryExc0 != null)) break block22;
            }
            catch (Throwable throwable) {
                if (__$$primaryExc0 != null) {
                    try {
                        Object v0;
                        InputStream inputStream = ins;
                        if (inputStream != null) {
                            inputStream.close();
                            v0 = null;
                        }
                        v0 = null;
                    }
                    catch (Throwable __$$suppressedExc0) {
                        Object v1;
                        Throwable throwable2 = __$$primaryExc0;
                        if (throwable2 != null) {
                            throwable2.addSuppressed(__$$suppressedExc0);
                            v1 = null;
                        }
                        v1 = null;
                    }
                } else {
                    Object v22;
                    InputStream inputStream = ins;
                    if (inputStream != null) {
                        inputStream.close();
                        v22 = null;
                    } else {
                        v22 = null;
                    }
                }
                throw throwable;
            }
            try {
                Object v3;
                InputStream inputStream = ins;
                if (inputStream != null) {
                    inputStream.close();
                    v3 = null;
                }
                v3 = null;
            }
            catch (Throwable __$$suppressedExc0) {
                Object v4;
                Throwable throwable = __$$primaryExc0;
                if (throwable != null) {
                    throwable.addSuppressed(__$$suppressedExc0);
                    v4 = null;
                }
                v4 = null;
            }
        }
        InputStream inputStream = ins;
        if (inputStream != null) {
            inputStream.close();
            v5 = null;
        } else {
            v5 = null;
        }
        return rows;
    }

    public InputStream getInputStream(Long attachmentId, String dataFileName) {
        Attachment attachment = Attachment.get(attachmentId);
        Validate.notNull((Object)attachment, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{attachmentId}, new String[]{"Attachment not found : ", ""})));
        Resource res = attachment.getResource();
        Validate.notNull((Object)res);
        File file = res.getFile();
        InputStream ins = null;
        if (ScriptBytecodeAdapter.compareEqual((Object)attachment.getExtension(), (Object)"zip")) {
            InputStream inputStream = ZipUtils.getZipEntryInputStream((File)file, (String)dataFileName);
            ins = inputStream;
            Validate.notNull((Object)ins, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{dataFileName}, new String[]{"", " not found in zip"})));
        } else {
            BufferedInputStream bufferedInputStream;
            ins = bufferedInputStream = ResourceGroovyMethods.newInputStream((File)file);
        }
        return ins;
    }

    public List<Map<String, Object>> processRows(InputStream dataIn, String delim) {
        CSVPathKeyMapReader dataRowsReader = CSVPathKeyMapReader.of((Reader)new InputStreamReader(dataIn)).pathDelimiter(delim);
        return dataRowsReader.readAllRows();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DefaultCsvToMapTransformer.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"yakworks.rally.common.DefaultCsvToMapTransformer");
    }
}

