/*
 * Decompiled with CFR 0.152.
 */
package yakworks.rally.attachment;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import jakarta.annotation.Nullable;
import java.beans.Transient;
import java.io.FileNotFoundException;
import java.lang.ref.SoftReference;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import javax.inject.Inject;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import yakworks.commons.io.PathTools;
import yakworks.rally.attachment.model.Attachment;
import yakworks.spring.AppResourceLoader;

@Service
@Lazy
public class AttachmentSupport
implements GroovyObject {
    public static final String ATTACHMENTS_LOCATION_KEY = "attachments.location";
    @Inject
    @Nullable
    private AppResourceLoader appResourceLoader;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public AttachmentSupport() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public Path createFileFromTempFile(Long id, String fileName, String tempFileName, String locationKey) {
        Path attachmentFile = this.getAttachmentsPath(id, fileName, locationKey);
        Path tempFile = this.getTempPath().resolve(tempFileName);
        if (!Files.exists(tempFile, new LinkOption[0])) {
            throw (Throwable)new FileNotFoundException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{tempFile}, new String[]{"Could not find temp file: ", ""})));
        }
        return Files.move(tempFile, attachmentFile, new CopyOption[0]);
    }

    public Path createFileFromBytes(Long id, String fileName, byte[] bytes, String locationKey) {
        Path attachmentFile = this.getAttachmentsPath(id, fileName, locationKey);
        return Files.write(attachmentFile, bytes, new OpenOption[0]);
    }

    public Path createFileFromSource(Long id, String fileName, Path sourceFile, String locationKey) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)fileName)) {
            String string;
            fileName = string = sourceFile.getFileName().toString();
        }
        Path attachmentFile = this.getAttachmentsPath(id, fileName, locationKey);
        return Files.copy(sourceFile, attachmentFile, new CopyOption[0]);
    }

    private Path getAttachmentsPath(Long id, String fileName, String locationKey) {
        String attachFileName = AttachmentSupport.concatFileNameId(fileName, id);
        return this.getAttachmentsPath(locationKey).resolve(attachFileName);
    }

    private Path getAttachmentsPath(String locationKey) {
        Path rootPath = this.appResourceLoader.getPath(locationKey);
        Path attachmentPath = rootPath.resolve(AttachmentSupport.getMonthDir());
        if (!Files.exists(attachmentPath, new LinkOption[0])) {
            Files.createDirectories(attachmentPath, new FileAttribute[0]);
        }
        return attachmentPath;
    }

    public String getRelativePath(Path file, String locationKey) {
        Path rootPath = this.appResourceLoader.getPath(locationKey);
        Path relativePath = rootPath.relativize(file);
        return relativePath.toString();
    }

    private Path getTempPath() {
        return this.appResourceLoader.getTempDirectory();
    }

    public Path createTempFile(String fileName, Object data) {
        return this.appResourceLoader.createTempFile(fileName, data);
    }

    public Path getPath(String location, String locationKey) {
        Path rootPath = this.appResourceLoader.getPath(locationKey);
        Path attachmentPath = rootPath.resolve(location);
        return attachmentPath;
    }

    public boolean deleteFile(String location, String locationKey) {
        Path attachedFile = this.getPath(location, locationKey);
        if (DefaultTypeTransformation.booleanUnbox((Object)attachedFile)) {
            return Files.deleteIfExists(attachedFile);
        }
        return false;
    }

    public String getDownloadUrl(Attachment attachment) {
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{attachment.getId()}, new String[]{"/attachment/download/", ""}));
    }

    public boolean rimrafAttachmentsDirectory() {
        return this.appResourceLoader.deleteDirectory(ATTACHMENTS_LOCATION_KEY);
    }

    public static String getMonthDir() {
        return LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM"));
    }

    public static String concatFileNameId(String fileName, Long id) {
        String extension = PathTools.getExtension((String)fileName);
        if (DefaultTypeTransformation.booleanUnbox((Object)extension)) {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{extension}, new String[]{".", ""});
            extension = ShortTypeHandling.castToString((Object)gStringImpl);
        }
        String baseName = PathTools.getBaseName((String)fileName);
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{baseName, id, extension}, new String[]{"", "_", "", ""}));
    }

    public static Map mergeMultipartFileParams(MultipartFile multipartFile, Map params) {
        Object v = params.get("name");
        Object object = DefaultTypeTransformation.booleanUnbox(v) ? v : multipartFile.getOriginalFilename();
        ScriptBytecodeAdapter.invokeMethodN(AttachmentSupport.class, (Object)params, (String)"putAt", (Object[])new Object[]{"name", object});
        String string = multipartFile.getContentType();
        ScriptBytecodeAdapter.invokeMethodN(AttachmentSupport.class, (Object)params, (String)"putAt", (Object[])new Object[]{"mimeType", string});
        byte[] byArray = multipartFile.getBytes();
        ScriptBytecodeAdapter.invokeMethodN(AttachmentSupport.class, (Object)params, (String)"putAt", (Object[])new Object[]{"bytes", byArray});
        String string2 = PathTools.getExtension((String)multipartFile.getOriginalFilename());
        ScriptBytecodeAdapter.invokeMethodN(AttachmentSupport.class, (Object)params, (String)"putAt", (Object[])new Object[]{"extension", string2});
        return params;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AttachmentSupport.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public Path createFileFromTempFile(Long id, String fileName, String tempFileName) {
        CallSite[] callSiteArray = AttachmentSupport.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.createFileFromTempFile(id, fileName, tempFileName, ATTACHMENTS_LOCATION_KEY);
        }
        return this.createFileFromTempFile(id, fileName, tempFileName, ATTACHMENTS_LOCATION_KEY);
    }

    @Generated
    public Path createFileFromBytes(Long id, String fileName, byte ... bytes) {
        CallSite[] callSiteArray = AttachmentSupport.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.createFileFromBytes(id, fileName, bytes, ATTACHMENTS_LOCATION_KEY);
        }
        return this.createFileFromBytes(id, fileName, bytes, ATTACHMENTS_LOCATION_KEY);
    }

    @Generated
    public Path createFileFromSource(Long id, String fileName, Path sourceFile) {
        CallSite[] callSiteArray = AttachmentSupport.$getCallSiteArray();
        return this.createFileFromSource(id, fileName, sourceFile, ATTACHMENTS_LOCATION_KEY);
    }

    @Generated
    public String getRelativePath(Path file) {
        CallSite[] callSiteArray = AttachmentSupport.$getCallSiteArray();
        return this.getRelativePath(file, ATTACHMENTS_LOCATION_KEY);
    }

    @Generated
    public Path getPath(String location) {
        CallSite[] callSiteArray = AttachmentSupport.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.getPath(location, ATTACHMENTS_LOCATION_KEY);
        }
        return this.getPath(location, ATTACHMENTS_LOCATION_KEY);
    }

    @Generated
    public boolean deleteFile(String location) {
        CallSite[] callSiteArray = AttachmentSupport.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.deleteFile(location, ATTACHMENTS_LOCATION_KEY);
        }
        return this.deleteFile(location, ATTACHMENTS_LOCATION_KEY);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"yakworks.rally.attachment.AttachmentSupport");
    }

    @Generated
    public AppResourceLoader getAppResourceLoader() {
        return this.appResourceLoader;
    }

    @Generated
    public void setAppResourceLoader(AppResourceLoader appResourceLoader) {
        this.appResourceLoader = appResourceLoader;
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[]{};
        return new CallSiteArray(AttachmentSupport.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = AttachmentSupport.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

