/*
 * Decompiled with CFR 0.152.
 */
package yakworks.rally.mail.services;

import grails.gorm.transactions.GrailsTransactionTemplate;
import grails.gorm.transactions.Transactional;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.datastore.gorm.GormEnhancer;
import org.grails.datastore.gorm.internal.RuntimeSupport;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.transactions.CustomizableRollbackTransactionAttribute;
import org.grails.datastore.mapping.transactions.TransactionCapableDatastore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import yakworks.api.Result;
import yakworks.api.problem.GenericProblem;
import yakworks.api.problem.Problem;
import yakworks.api.problem.ThrowableProblem;
import yakworks.rally.attachment.model.Attachment;
import yakworks.rally.mail.EmailService;
import yakworks.rally.mail.EmailUtils;
import yakworks.rally.mail.model.ContentType;
import yakworks.rally.mail.model.MailMessage;

public class MailMessageSender
implements GroovyObject {
    @Inject
    private EmailService emailService;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    protected PlatformTransactionManager $transactionManager;
    protected Datastore $targetDatastore;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public MailMessageSender() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public Result send(MailMessage mailMessage) {
        ThrowableProblem result = null;
        try {
            EmailService.MailTo mailTo = this.convertMailMessage(mailMessage);
            this.validateMailMessage(mailTo);
            Result result2 = this.emailService.send(mailTo);
            result = result2;
        }
        catch (ThrowableProblem p) {
            ThrowableProblem throwableProblem;
            result = throwableProblem = p;
        }
        catch (Exception ex) {
            GenericProblem genericProblem = Problem.of((Throwable)ex);
            result = genericProblem;
        }
        try {
            this.updateMessageState(mailMessage, (Result)result);
        }
        catch (Exception pex) {
            log.error("Failed to update message state", (Throwable)ScriptBytecodeAdapter.castToType((Object)pex, Throwable.class));
            GenericProblem genericProblem = Problem.of((Throwable)((Throwable)ScriptBytecodeAdapter.castToType((Object)pex, Throwable.class)));
            result = genericProblem;
        }
        return result;
    }

    public void validateMailMessage(EmailService.MailTo mailTo) {
        EmailUtils.validateEmail(DefaultGroovyMethods.join(mailTo.getTo(), (String)","));
        EmailUtils.validateEmail(mailTo.getFrom());
        if (DefaultTypeTransformation.booleanUnbox((Object)mailTo.getReplyTo())) {
            EmailUtils.validateEmail(mailTo.getReplyTo());
        }
        if (DefaultTypeTransformation.booleanUnbox(mailTo.getCc())) {
            EmailUtils.validateEmail(DefaultGroovyMethods.join(mailTo.getCc(), (String)","));
        }
        if (DefaultTypeTransformation.booleanUnbox(mailTo.getBcc())) {
            EmailUtils.validateEmail(DefaultGroovyMethods.join(mailTo.getBcc(), (String)","));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    protected void updateMessageState(MailMessage mailMessage, Result result) {
        void var2_2;
        Reference mailMessage2 = new Reference((Object)mailMessage);
        Reference result2 = new Reference((Object)var2_2);
        CustomizableRollbackTransactionAttribute $transactionAttribute = new CustomizableRollbackTransactionAttribute();
        String string = "yakworks.rally.mail.services.MailMessageSender.updateMessageState";
        $transactionAttribute.setName(string);
        GrailsTransactionTemplate $transactionTemplate = new GrailsTransactionTemplate(this.getTransactionManager(), $transactionAttribute);
        public final class _updateMessageState_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference mailMessage;
            private /* synthetic */ Reference result;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _updateMessageState_closure1(Object _outerInstance, Object _thisObject, Reference mailMessage, Reference result) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.mailMessage = reference2 = mailMessage;
                this.result = reference = result;
            }

            public Object doCall(TransactionStatus transactionStatus) {
                return InvokerHelper.invokeMethodSafe((Object)((MailMessageSender)this.getThisObject()), (String)"$tt__updateMessageState", (Object)new Object[]{this.mailMessage.get(), this.result.get(), transactionStatus});
            }

            @Generated
            public Object call(TransactionStatus transactionStatus) {
                return this.doCall(transactionStatus);
            }

            @Generated
            public MailMessage getMailMessage() {
                return (MailMessage)ScriptBytecodeAdapter.castToType((Object)this.mailMessage.get(), MailMessage.class);
            }

            @Generated
            public Result getResult() {
                return (Result)ScriptBytecodeAdapter.castToType((Object)this.result.get(), Result.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateMessageState_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        $transactionTemplate.execute((Closure)new _updateMessageState_closure1(this, this, mailMessage2, result2));
    }

    public EmailService.MailTo convertMailMessage(MailMessage mailMessage) {
        EmailService.MailTo mailTo = new EmailService.MailTo();
        String string = mailMessage.getSendFrom();
        mailTo.setFrom(string);
        String string2 = mailMessage.getReplyTo();
        mailTo.setReplyTo(string2);
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{mailMessage.getSendTo()});
        mailTo.setTo(list);
        String string3 = mailMessage.getSubject();
        mailTo.setSubject(string3);
        EmailService.MailTo mailTo2 = mailTo;
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)mailMessage.getContentType()), (Object)((Object)ContentType.html))) {
            String string4 = mailMessage.getBody();
            mailTo2.setHtml(string4);
        } else {
            String string5 = mailMessage.getBody();
            mailTo2.setText(string5);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)mailMessage.getCc())) {
            List list2 = ScriptBytecodeAdapter.createList((Object[])new Object[]{mailMessage.getCc()});
            mailTo2.setCc(list2);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)mailMessage.getBcc())) {
            List list3 = ScriptBytecodeAdapter.createList((Object[])new Object[]{mailMessage.getBcc()});
            mailTo2.setCc(list3);
        }
        if (DefaultTypeTransformation.booleanUnbox(mailMessage.getAttachmentIds())) {
            Reference attachFiles = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
            public final class _convertMailMessage_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference attachFiles;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _convertMailMessage_closure2(Object _outerInstance, Object _thisObject, Reference attachFiles) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.attachFiles = reference = attachFiles;
                }

                public Boolean doCall(Long id) {
                    Attachment attach = Attachment.get(id);
                    if (!DefaultTypeTransformation.booleanUnbox((Object)attach)) {
                        throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{id}, new String[]{"Attachment id:[", "] does not exist"})));
                    }
                    return ((List)this.attachFiles.get()).add(attach.getResource().getFile());
                }

                @Generated
                public Boolean call(Long id) {
                    return this.doCall(id);
                }

                @Generated
                public List getAttachFiles() {
                    return (List)ScriptBytecodeAdapter.castToType((Object)this.attachFiles.get(), List.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _convertMailMessage_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each(mailMessage.getAttachmentIds(), (Closure)new _convertMailMessage_closure2(this, this, attachFiles));
            if (DefaultTypeTransformation.booleanUnbox((Object)((List)attachFiles.get()))) {
                List list4 = (List)attachFiles.get();
                mailTo2.setAttachments(list4);
            }
        }
        if (DefaultTypeTransformation.booleanUnbox(mailMessage.getTags())) {
            List<String> list5 = mailMessage.getTags();
            mailTo2.setTags(list5);
        }
        return mailTo2;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != MailMessageSender.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public PlatformTransactionManager getTransactionManager() {
        if (this.$transactionManager != null) {
            return this.$transactionManager;
        }
        return GormEnhancer.findSingleTransactionManager();
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        PlatformTransactionManager platformTransactionManager;
        this.$transactionManager = platformTransactionManager = transactionManager;
    }

    @Autowired(required=false)
    public void setTargetDatastore(Datastore ... datastores) {
        Datastore datastore;
        this.$targetDatastore = datastore = RuntimeSupport.findDefaultDatastore((Datastore[])datastores);
        if (RuntimeSupport.findDefaultDatastore((Datastore[])datastores) != null) {
            PlatformTransactionManager platformTransactionManager;
            this.$transactionManager = platformTransactionManager = ((TransactionCapableDatastore)ScriptBytecodeAdapter.castToType((Object)RuntimeSupport.findDefaultDatastore((Datastore[])datastores), TransactionCapableDatastore.class)).getTransactionManager();
        }
    }

    protected Datastore getTargetDatastore(String connectionName) {
        if (this.$targetDatastore != null) {
            return (Datastore)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodN(MailMessageSender.class, (Object)this.$targetDatastore, (String)"getDatastoreForConnection", (Object[])new Object[]{connectionName}), Datastore.class);
        }
        return (Datastore)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodN(MailMessageSender.class, (Object)GormEnhancer.findSingleDatastore(), (String)"getDatastoreForConnection", (Object[])new Object[]{connectionName}), Datastore.class);
    }

    protected Datastore getTargetDatastore() {
        if (this.$targetDatastore != null) {
            return this.$targetDatastore;
        }
        return GormEnhancer.findSingleDatastore();
    }

    protected void $tt__updateMessageState(MailMessage mailMessage, Result result, TransactionStatus transactionStatus) {
        if (result instanceof Problem) {
            MailMessage.MsgState msgState = MailMessage.MsgState.Error;
            mailMessage.setState(msgState);
            String string = result.getDetail();
            mailMessage.setMsgResponse(string);
        } else {
            Map payload = (Map)ScriptBytecodeAdapter.castToType((Object)result.getPayload(), Map.class);
            Object v = payload.get("id");
            mailMessage.setMessageId(ShortTypeHandling.castToString(v));
            LocalDateTime localDateTime = LocalDateTime.now();
            mailMessage.setSendDate(localDateTime);
            MailMessage.MsgState msgState = MailMessage.MsgState.Sent;
            mailMessage.setState(msgState);
        }
        mailMessage.persist();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"yakworks.rally.mail.services.MailMessageSender");
    }

    @Generated
    public EmailService getEmailService() {
        return this.emailService;
    }

    @Generated
    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }
}

