/*
 * Decompiled with CFR 0.152.
 */
package yakworks.rally.orgs.repo;

import gorm.tools.databinding.BindAction;
import gorm.tools.model.Persistable;
import gorm.tools.model.SourceType;
import gorm.tools.problem.ValidationProblem;
import gorm.tools.repository.GormRepo;
import gorm.tools.repository.PersistArgs;
import gorm.tools.repository.events.AfterBindEvent;
import gorm.tools.repository.events.AfterRemoveEvent;
import gorm.tools.repository.events.BeforeBindEvent;
import gorm.tools.repository.events.BeforeRemoveEvent;
import gorm.tools.repository.events.RepoListener;
import gorm.tools.repository.model.LongIdGormRepo;
import gorm.tools.utils.GormMetaUtils;
import gorm.tools.validation.Rejector;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.datastore.gorm.GormEntity;
import org.grails.datastore.gorm.GormValidateable;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.validation.Errors;
import yakworks.rally.config.OrgProps;
import yakworks.rally.orgs.OrgService;
import yakworks.rally.orgs.model.Company;
import yakworks.rally.orgs.model.Contact;
import yakworks.rally.orgs.model.Location;
import yakworks.rally.orgs.model.Org;
import yakworks.rally.orgs.model.OrgSource;
import yakworks.rally.orgs.model.OrgType;
import yakworks.rally.orgs.repo.ContactRepo;
import yakworks.rally.orgs.repo.LocationRepo;
import yakworks.rally.orgs.repo.OrgSourceRepo;
import yakworks.rally.orgs.repo.OrgTagRepo;
import yakworks.rally.orgs.repo.PartitionOrgRepo;

public abstract class AbstractOrgRepo
extends LongIdGormRepo<Org> {
    @Inject
    private LocationRepo locationRepo;
    @Inject
    private ContactRepo contactRepo;
    @Inject
    private OrgTagRepo orgTagRepo;
    @Inject
    private OrgSourceRepo orgSourceRepo;
    @Inject
    private OrgService orgService;
    @Inject
    private OrgProps orgProps;
    @Inject
    private PartitionOrgRepo partitionOrgRepo;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public AbstractOrgRepo() {
    }

    @RepoListener
    public void beforeValidate(Org org, Errors errors) {
        if (org.isNew()) {
            Rejector.validateNotNull((GormValidateable)org, (Errors)errors, (String)"type");
        }
    }

    public void ensureCompany(Org org) {
        if (org.getCompanyId() == null) {
            if (ScriptBytecodeAdapter.compareEqual((Object)((Object)org.getType()), (Object)((Object)OrgType.Company))) {
                Object object = org.getId();
                org.setCompanyId((Long)ScriptBytecodeAdapter.castToType((Object)object, Long.class));
            } else {
                Long l = Company.DEFAULT_COMPANY_ID;
                org.setCompanyId(l);
            }
        }
    }

    @RepoListener
    public void beforeBind(Org org, Map data, BeforeBindEvent be) {
        if (be.isBindCreate()) {
            OrgType orgType = this.getOrgTypeFromData(data);
            org.setType(orgType);
            if (DefaultTypeTransformation.booleanUnbox(data.get("id"))) {
                Long l = (Long)ScriptBytecodeAdapter.asType(data.get("id"), Long.class);
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)l, AbstractOrgRepo.class, (GroovyObject)org, (String)"id");
            } else {
                this.generateId((Persistable)org);
            }
        }
    }

    @RepoListener
    public void afterBind(Org org, Map data, AfterBindEvent e) {
        if (e.isBindCreate()) {
            this.ensureCompany(org);
        }
    }

    public void doBeforePersist(Org org, PersistArgs args) {
        if (DefaultTypeTransformation.booleanUnbox((Object)args.getBindAction()) && DefaultTypeTransformation.booleanUnbox((Object)args.getData())) {
            Object v;
            Map data = args.getData();
            if (ScriptBytecodeAdapter.compareEqual((Object)args.getBindAction(), (Object)BindAction.Create)) {
                OrgService orgService;
                this.verifyNumAndOrgSource(org, data);
                if (DefaultTypeTransformation.booleanUnbox((Object)((Object)org.getType())) && DefaultTypeTransformation.booleanUnbox((orgService = this.orgService) != null ? Boolean.valueOf(orgService.isOrgMemberEnabled()) : null)) {
                    this.orgService.setupMember(org, (Map)ScriptBytecodeAdapter.asType(data.remove("member"), Map.class));
                }
            }
            if (DefaultTypeTransformation.booleanUnbox(data.get("location"))) {
                this.createOrUpdatePrimaryLocation(org, (Map)ScriptBytecodeAdapter.asType(data.get("location"), Map.class));
            }
            Object contactData = DefaultTypeTransformation.booleanUnbox(v = data.get("contact")) ? v : data.get("keyContact");
            if (DefaultTypeTransformation.booleanUnbox(contactData)) {
                this.createOrUpdatePrimaryContact(org, (Map)ScriptBytecodeAdapter.asType(contactData, Map.class));
            }
        }
        this.partitionOrgCreateOrUpdate(org);
    }

    public void partitionOrgCreateOrUpdate(Org org) {
        if (DefaultTypeTransformation.booleanUnbox((Object)this.orgProps) && org.isOrgType(this.orgProps.getPartition().getType())) {
            this.partitionOrgRepo.createOrUpdate(org);
        }
    }

    public void doAfterPersist(Org org, PersistArgs args) {
        if (DefaultTypeTransformation.booleanUnbox((Object)args.getBindAction()) && DefaultTypeTransformation.booleanUnbox((Object)args.getData())) {
            Map data = args.getData();
            if (DefaultTypeTransformation.booleanUnbox(data.get("locations"))) {
                this.persistToManyWithOrgId(org, (GormRepo)Location.getRepo(), (List)ScriptBytecodeAdapter.asType(data.get("locations"), List.class));
            }
            if (DefaultTypeTransformation.booleanUnbox(data.get("contacts"))) {
                this.persistToManyWithOrgId(org, (GormRepo)Contact.getRepo(), (List)ScriptBytecodeAdapter.asType(data.get("contacts"), List.class));
            }
            if (data.get("tags") != null) {
                this.orgTagRepo.addOrRemove((Persistable)org, data.get("tags"));
            }
        }
    }

    public void persistToOneAssociations(Org org, List<String> associations) {
        super.persistToOneAssociations((Object)org, associations);
        if (GormMetaUtils.isNewOrDirty((GormEntity)org.getLocation())) {
            org.getLocation().persist();
        }
        if (GormMetaUtils.isNewOrDirty((GormEntity)org.getContact())) {
            org.getContact().persist();
        }
    }

    public void persistToManyWithOrgId(Org org, GormRepo assocRepo, List<Map> assocList) {
        Reference org2 = new Reference((Object)org);
        if (!DefaultTypeTransformation.booleanUnbox(assocList)) {
            return;
        }
        public final class _persistToManyWithOrgId_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _persistToManyWithOrgId_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Boolean doCall(Map it) {
                return it.size() > 0;
            }

            @Generated
            public Boolean call(Map it) {
                return this.doCall(it);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _persistToManyWithOrgId_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        assocList = DefaultGroovyMethods.findAll(assocList, (Closure)new _persistToManyWithOrgId_closure1((Object)this, (Object)this));
        public final class _persistToManyWithOrgId_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference org;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _persistToManyWithOrgId_closure2(Object _outerInstance, Object _thisObject, Reference org) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.org = reference = org;
            }

            public Long doCall(Object it) {
                Long l = ((Org)ScriptBytecodeAdapter.castToType((Object)this.org.get(), Org.class)).getId();
                ScriptBytecodeAdapter.invokeMethodN(_persistToManyWithOrgId_closure2.class, (Object)it, (String)"putAt", (Object[])new Object[]{"orgId", l});
                return l;
            }

            @Generated
            public Org getOrg() {
                return (Org)ScriptBytecodeAdapter.castToType((Object)this.org.get(), Org.class);
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Long doCall() {
                CallSite[] callSiteArray = _persistToManyWithOrgId_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _persistToManyWithOrgId_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_persistToManyWithOrgId_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _persistToManyWithOrgId_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        DefaultGroovyMethods.each((List)assocList, (Closure)new _persistToManyWithOrgId_closure2((Object)this, (Object)this, org2));
        assocRepo.createOrUpdate(assocList);
    }

    @RepoListener
    public void beforeRemove(Org org, BeforeRemoveEvent e) {
        OrgSource orgSource = org.getSource();
        if (ScriptBytecodeAdapter.compareEqual((Object)(orgSource != null ? orgSource.getSourceType() : null), (Object)SourceType.ERP)) {
            LinkedHashMap args = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", new GStringImpl(new Object[]{org.getName(), SourceType.ERP}, new String[]{"Org: ", ", source:", ""})}), LinkedHashMap.class);
            throw (Throwable)ValidationProblem.of((String)"error.delete.externalSource", (Object)args).entity((Object)org).toException();
        }
        this.orgTagRepo.remove((Persistable)org);
        this.contactRepo.removeAll(org);
        if (org.isOrgType(this.orgProps.getPartition().getType())) {
            this.partitionOrgRepo.removeById((Serializable)ScriptBytecodeAdapter.castToType((Object)org.getId(), Serializable.class), PersistArgs.defaults());
        }
    }

    @RepoListener
    public void afterRemove(Org org, AfterRemoveEvent e) {
        Location.query(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"orgId", org.getId()})).deleteAll();
        Contact.query(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"orgId", org.getId()})).deleteAll();
        OrgSource.query(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"orgId", org.getId()})).deleteAll();
    }

    public boolean verifyNumAndOrgSource(Org org, Map data) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)org.getNum()) || !(org.getType() != null)) {
            return false;
        }
        OrgSource orgSource = OrgSource.getRepo().createSource(org, data);
        org.setSource(orgSource);
        return DefaultTypeTransformation.booleanUnbox((Object)org.getSource().persist());
    }

    public Contact createOrUpdatePrimaryContact(Org org, Map data) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)data)) {
            return (Contact)ScriptBytecodeAdapter.castToType(null, Contact.class);
        }
        if (DefaultTypeTransformation.booleanUnbox(data.get("isPrimary"))) {
            Object var3_3 = null;
            ScriptBytecodeAdapter.setProperty(var3_3, null, (Object)data, (String)"isPrimary");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)org.getContact())) {
            Long cid = (Long)ScriptBytecodeAdapter.asType(data.get("id"), Long.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)cid) && ScriptBytecodeAdapter.compareNotEqual((Object)org.getContact().getId(), (Object)cid)) {
                Contact contact = Contact.load(cid);
                org.setContact(contact);
                return org.getContact();
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)cid)) {
                Long l = org.getContact().getId();
                ScriptBytecodeAdapter.setProperty((Object)l, null, (Object)data, (String)"id");
            }
        }
        data.remove("isPrimary");
        Long l = org.getId();
        ScriptBytecodeAdapter.setProperty((Object)l, null, (Object)data, (String)"orgId");
        Object object = this.contactRepo.upsert(data).getEntity();
        org.setContact((Contact)ScriptBytecodeAdapter.castToType((Object)object, Contact.class));
        return org.getContact();
    }

    public Location createOrUpdatePrimaryLocation(Org org, Map data) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)data)) {
            return (Location)ScriptBytecodeAdapter.castToType(null, Location.class);
        }
        Long l = org.getId();
        ScriptBytecodeAdapter.setProperty((Object)l, null, (Object)data, (String)"orgId");
        if (DefaultTypeTransformation.booleanUnbox((Object)org.getLocation()) && !DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.getAt((Map)data, (Object)"id"))) {
            Object object = org.getLocation().getId();
            ScriptBytecodeAdapter.invokeMethodN(AbstractOrgRepo.class, (Object)data, (String)"putAt", (Object[])new Object[]{"id", object});
        }
        Object object = this.locationRepo.upsert(data).getEntity();
        org.setLocation((Location)ScriptBytecodeAdapter.castToType((Object)object, Location.class));
        return org.getLocation();
    }

    public OrgType getOrgTypeFromData(Map data) {
        if (DefaultTypeTransformation.booleanUnbox(data.get("type"))) {
            return this.coerceOrgType(data.get("type"));
        }
        if (DefaultTypeTransformation.booleanUnbox(data.get("orgTypeId"))) {
            return OrgType.get((Long)ScriptBytecodeAdapter.asType(data.get("orgTypeId"), Long.class));
        }
        return (OrgType)ShortTypeHandling.castToEnum(null, OrgType.class);
    }

    public OrgType coerceOrgType(Object orgTypeObj) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)orgTypeObj)) {
            return (OrgType)ShortTypeHandling.castToEnum(null, OrgType.class);
        }
        if (orgTypeObj instanceof Map) {
            return OrgType.get((Long)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.getAt((Map)((Map)ScriptBytecodeAdapter.asType((Object)orgTypeObj, Map.class)), (Object)"id"), Long.class));
        }
        if (orgTypeObj instanceof OrgType) {
            return (OrgType)((Object)ScriptBytecodeAdapter.asType((Object)orgTypeObj, OrgType.class));
        }
        if (orgTypeObj instanceof String) {
            return OrgType.get(orgTypeObj);
        }
        return (OrgType)ShortTypeHandling.castToEnum(null, OrgType.class);
    }

    public OrgSource createSource(Org org, SourceType sourceType) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)org.getId())) {
            this.generateId((Persistable)org);
        }
        return OrgSource.getRepo().createSource(org, sourceType);
    }

    public Org lookup(Map data) {
        Org org = null;
        Long oid = null;
        OrgType orgType = this.coerceOrgType(data.get("type"));
        if (DefaultTypeTransformation.booleanUnbox(data.get("org"))) {
            Object object = DefaultGroovyMethods.getAt(data.get("org"), (String)"source");
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)data, (String)"source");
            Object object2 = DefaultGroovyMethods.getAt(data.get("org"), (String)"sourceId");
            ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)data, (String)"sourceId");
        }
        if (data.get("source") == null && DefaultTypeTransformation.booleanUnbox(data.get("sourceId"))) {
            Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"sourceId", data.get("sourceId")});
            ScriptBytecodeAdapter.setProperty((Object)map, null, (Object)data, (String)"source");
        }
        if (DefaultTypeTransformation.booleanUnbox(data.get("source")) && DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.getAt(data.get("source"), (String)"sourceId"))) {
            Map source = (Map)ScriptBytecodeAdapter.asType(data.get("source"), Map.class);
            if (!(orgType != null) && DefaultTypeTransformation.booleanUnbox(source.get("orgType"))) {
                orgType = OrgType.get(source.get("orgType"));
            }
            if (orgType != null) {
                oid = this.orgSourceRepo.findOrgIdBySourceIdAndOrgType((String)ScriptBytecodeAdapter.asType(source.get("sourceId"), String.class), orgType);
                if (DefaultTypeTransformation.booleanUnbox((Object)oid)) {
                    org = (Org)ScriptBytecodeAdapter.castToType((Object)this.get(oid), Org.class);
                }
            } else {
                List<Long> res = this.orgSourceRepo.findOrgIdBySourceId((String)ScriptBytecodeAdapter.asType(source.get("sourceId"), String.class));
                List<Long> list = res;
                if (ScriptBytecodeAdapter.compareEqual((Object)(list != null ? Integer.valueOf(list.size()) : null), (Object)1)) {
                    oid = (Long)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(res, (int)0), Long.class);
                } else if (res.size() > 1) {
                    throw (Throwable)new DataRetrievalFailureException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{source.get("sourceId")}, new String[]{"Multiple Orgs found for sourceId: ", ", lookup key must return a unique Org"})));
                }
            }
            org = (Org)ScriptBytecodeAdapter.castToType((Object)this.get(oid), Org.class);
        } else if (DefaultTypeTransformation.booleanUnbox(data.get("num"))) {
            String num = (String)ScriptBytecodeAdapter.asType(data.get("num"), String.class);
            List<Org> orgsForNum = orgType != null ? Org.findAllWhere(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"num", num, "type", orgType})) : Org.findAllWhere(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"num", num}));
            List<Org> list = orgsForNum;
            if (ScriptBytecodeAdapter.compareEqual((Object)(list != null ? Integer.valueOf(list.size()) : null), (Object)1)) {
                org = (Org)DefaultGroovyMethods.getAt(orgsForNum, (int)0);
            } else if (orgsForNum.size() > 1) {
                throw (Throwable)new DataRetrievalFailureException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{data.get("num")}, new String[]{"Multiple Orgs found for num: ", ", lookup key must return a unique Org"})));
            }
        }
        return org;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != AbstractOrgRepo.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public OrgSource createSource(Org org) {
        CallSite[] callSiteArray = AbstractOrgRepo.$getCallSiteArray();
        return this.createSource(org, (SourceType)ShortTypeHandling.castToEnum((Object)callSiteArray[0].callGetProperty(SourceType.class), SourceType.class));
    }

    @Generated
    public LocationRepo getLocationRepo() {
        return this.locationRepo;
    }

    @Generated
    public void setLocationRepo(LocationRepo locationRepo) {
        this.locationRepo = locationRepo;
    }

    @Generated
    public ContactRepo getContactRepo() {
        return this.contactRepo;
    }

    @Generated
    public void setContactRepo(ContactRepo contactRepo) {
        this.contactRepo = contactRepo;
    }

    @Generated
    public OrgTagRepo getOrgTagRepo() {
        return this.orgTagRepo;
    }

    @Generated
    public void setOrgTagRepo(OrgTagRepo orgTagRepo) {
        this.orgTagRepo = orgTagRepo;
    }

    @Generated
    public OrgSourceRepo getOrgSourceRepo() {
        return this.orgSourceRepo;
    }

    @Generated
    public void setOrgSourceRepo(OrgSourceRepo orgSourceRepo) {
        this.orgSourceRepo = orgSourceRepo;
    }

    @Generated
    public OrgService getOrgService() {
        return this.orgService;
    }

    @Generated
    public void setOrgService(OrgService orgService) {
        this.orgService = orgService;
    }

    @Generated
    public OrgProps getOrgProps() {
        return this.orgProps;
    }

    @Generated
    public void setOrgProps(OrgProps orgProps) {
        this.orgProps = orgProps;
    }

    @Generated
    public PartitionOrgRepo getPartitionOrgRepo() {
        return this.partitionOrgRepo;
    }

    @Generated
    public void setPartitionOrgRepo(PartitionOrgRepo partitionOrgRepo) {
        this.partitionOrgRepo = partitionOrgRepo;
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[1];
        stringArray[0] = "App";
        return new CallSiteArray(AbstractOrgRepo.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = AbstractOrgRepo.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

