/*
 * Decompiled with CFR 0.152.
 */
package yakworks.security.shiro;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.util.Set;
import org.apache.shiro.authc.AccountException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import yakworks.security.shiro.ShiroPermissionResolver;

public class SpringSecurityRealm
extends AuthorizingRealm
implements GroovyObject {
    private AuthenticationTrustResolver authenticationTrustResolver;
    private ShiroPermissionResolver shiroPermissionResolver;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public SpringSecurityRealm() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        if (principals == null) {
            throw (Throwable)new AuthorizationException("PrincipalCollection method argument cannot be null.");
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String username = ShortTypeHandling.castToString((Object)this.getAvailablePrincipal(principals));
        this.getCurrentUser(username, authentication);
        public final class _doGetAuthorizationInfo_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _doGetAuthorizationInfo_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ((GrantedAuthority)it).getAuthority();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _doGetAuthorizationInfo_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Set roleNames = (Set)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.collect((Iterable)authentication.getAuthorities(), (Closure)new _doGetAuthorizationInfo_closure1((Object)this, (Object)this)), Set.class);
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo(roleNames);
        Set<String> set = this.shiroPermissionResolver.resolvePermissions(username);
        info.setStringPermissions(set);
        if (log.isDebugEnabled()) {
            log.debug("AuthorizationInfo for user {}: {}", (Object)username, (Object)DefaultGroovyMethods.dump((Object)info));
        }
        return info;
    }

    protected UserDetails getCurrentUser(String username, Authentication authentication) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)authentication) || this.authenticationTrustResolver.isAnonymous(authentication)) {
            throw (Throwable)new AccountException("Not logged in or anonymous");
        }
        UserDetails user = (UserDetails)ScriptBytecodeAdapter.castToType((Object)authentication.getPrincipal(), UserDetails.class);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)user.getUsername(), (Object)username)) {
            throw (Throwable)new AccountException("Not logged in as expected user");
        }
        return user;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        UsernamePasswordToken upToken = (UsernamePasswordToken)ScriptBytecodeAdapter.castToType((Object)token, UsernamePasswordToken.class);
        String username = upToken.getUsername();
        if (username == null) {
            throw (Throwable)new AccountException("Null usernames are not allowed by this realm.");
        }
        UserDetails user = this.getCurrentUser(username, SecurityContextHolder.getContext().getAuthentication());
        return new SimpleAuthenticationInfo((Object)username, (Object)user.getPassword().toCharArray(), this.getName());
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != SpringSecurityRealm.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"yakworks.security.shiro.SpringSecurityRealm");
    }

    @Generated
    public AuthenticationTrustResolver getAuthenticationTrustResolver() {
        return this.authenticationTrustResolver;
    }

    @Generated
    public void setAuthenticationTrustResolver(AuthenticationTrustResolver authenticationTrustResolver) {
        this.authenticationTrustResolver = authenticationTrustResolver;
    }

    @Generated
    public ShiroPermissionResolver getShiroPermissionResolver() {
        return this.shiroPermissionResolver;
    }

    @Generated
    public void setShiroPermissionResolver(ShiroPermissionResolver shiroPermissionResolver) {
        this.shiroPermissionResolver = shiroPermissionResolver;
    }
}

