/*
 * Decompiled with CFR 0.152.
 */
package yakworks.i18n.icu;

import com.ibm.icu.text.MessageFormat;
import java.text.Format;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import yakworks.i18n.MsgContext;
import yakworks.i18n.icu.ICUBundleMessageSource;
import yakworks.i18n.icu.ICUMessageSource;

public class DefaultICUMessageSource
extends ICUBundleMessageSource
implements ICUMessageSource {
    public static final MessageFormat INVALID_MESSAGE_FORMAT = new MessageFormat("");
    private final Map<String, Map<Locale, MessageFormat>> messageFormatsPerMessage = new HashMap<String, Map<Locale, MessageFormat>>();

    public DefaultICUMessageSource() {
        this.setBasename("classpath:messages");
        this.setDefaultEncoding("UTF-8");
    }

    public String getMessage(String code, MsgContext msgCtx) {
        String msg = this.getMessageInternal(code, msgCtx);
        if (msg != null) {
            return msg;
        }
        String defaultMessage = msgCtx.getFallbackMessage();
        if (defaultMessage == null) {
            return this.getDefaultMessage(code);
        }
        return this.interpolate(defaultMessage, msgCtx);
    }

    protected String renderDefaultMessage(String defaultMessage, @Nullable Object[] args, Locale locale) {
        return this.interpolate(defaultMessage, (MsgContext)MsgContext.of((Object)args).locale(locale));
    }

    public Locale checkLocale(Locale locale) {
        return locale != null ? locale : this.getHolderLocale();
    }

    @Override
    public Locale getHolderLocale() {
        return LocaleContextHolder.getLocale();
    }

    @Nullable
    protected Locale getDefaultLocale() {
        return this.getHolderLocale();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String interpolate(String msg, MsgContext msgCtx) {
        Locale locale = this.checkLocale(msgCtx.getLocale());
        if (!this.isAlwaysUseMessageFormat() && ObjectUtils.isEmpty((Object)msgCtx)) {
            return msg;
        }
        MessageFormat messageFormat = null;
        MessageFormat messageFormat2 = this.messageFormatsPerMessage;
        synchronized (messageFormat2) {
            Map<Locale, MessageFormat> messageFormatsPerLocale = this.messageFormatsPerMessage.get(msg);
            if (messageFormatsPerLocale != null) {
                messageFormat = messageFormatsPerLocale.get(locale);
            } else {
                messageFormatsPerLocale = new HashMap<Locale, MessageFormat>();
                this.messageFormatsPerMessage.put(msg, messageFormatsPerLocale);
            }
            if (messageFormat == null) {
                try {
                    messageFormat = this.createMessageFormatICU(msg, locale);
                }
                catch (IllegalArgumentException ex) {
                    if (this.isAlwaysUseMessageFormat()) {
                        throw ex;
                    }
                    messageFormat = INVALID_MESSAGE_FORMAT;
                }
                messageFormatsPerLocale.put(locale, messageFormat);
            }
        }
        if (messageFormat == INVALID_MESSAGE_FORMAT) {
            return msg;
        }
        messageFormat2 = messageFormat;
        synchronized (messageFormat2) {
            return msgCtx.getArgs().formatWith((Format)messageFormat);
        }
    }

    @Nullable
    protected String getMessageInternal(@Nullable String code, @Nullable Object[] args, @Nullable Locale locale) {
        return this.getMessageInternal(code, (MsgContext)MsgContext.of((Object)args).locale(locale));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected String getMessageInternal(@Nullable String code, MsgContext msgCtx) {
        String commonMessage;
        Properties commonMessages;
        if (code == null) {
            return null;
        }
        msgCtx.locale(this.checkLocale(msgCtx.getLocale()));
        MsgContext msgCtxToUse = msgCtx;
        if (!this.isAlwaysUseMessageFormat() && msgCtx.getArgs().isEmpty()) {
            String message = this.resolveCodeWithoutArguments(code, msgCtx.getLocale());
            if (message != null) {
                return message;
            }
        } else {
            msgCtxToUse = this.resolveArguments(msgCtx);
            MessageFormat messageFormat = this.resolveCodeICU(code, msgCtx.getLocale());
            if (messageFormat != null) {
                MessageFormat messageFormat2 = messageFormat;
                synchronized (messageFormat2) {
                    return msgCtxToUse.getArgs().formatWith((Format)messageFormat);
                }
            }
        }
        if ((commonMessages = this.getCommonMessages()) != null && (commonMessage = commonMessages.getProperty(code)) != null) {
            return this.interpolate(commonMessage, msgCtx);
        }
        return null;
    }

    protected MsgContext resolveArguments(MsgContext msgCtx) {
        return (MsgContext)msgCtx.transform(item -> {
            if (item instanceof MessageSourceResolvable) {
                return this.getMessage((MessageSourceResolvable)item, msgCtx.getLocale());
            }
            return item;
        });
    }

    protected String formatMessage(String msg, @Nullable Object[] args, Locale locale) {
        throw new UnsupportedOperationException("Use formatMessage with ICUMessageArguments");
    }

    protected Object[] resolveArguments(@Nullable Object[] args, Locale locale) {
        throw new UnsupportedOperationException("caller methods should have been overriden");
    }
}

