/*
 * Decompiled with CFR 0.152.
 */
package yakworks.i18n.icu;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.lang.Nullable;
import org.springframework.util.DefaultPropertiesPersister;
import org.springframework.util.PropertiesPersister;
import org.springframework.util.StringUtils;

public class ICUBundleMessageSource
extends ReloadableResourceBundleMessageSource {
    private static final String PROPERTIES_SUFFIX = ".properties";
    private static final String XML_SUFFIX = ".xml";
    @Nullable
    private Properties fileEncodings;
    private boolean concurrentRefresh = true;
    private PropertiesPersister propertiesPersister = new DefaultPropertiesPersister();
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private final ConcurrentMap<String, PropertiesHolder> cachedProperties = new ConcurrentHashMap<String, PropertiesHolder>();
    private final ConcurrentMap<Locale, PropertiesHolder> cachedMergedProperties = new ConcurrentHashMap<Locale, PropertiesHolder>();

    @Nullable
    protected MessageFormat resolveCode(String code, Locale locale) {
        throw new UnsupportedOperationException("Use resolveCodeICU for ibm.icu");
    }

    @Nullable
    protected com.ibm.icu.text.MessageFormat resolveCodeICU(String code, Locale locale) {
        if (this.getCacheMillis() < 0L) {
            PropertiesHolder propHolder = this.getMergedProperties(locale);
            com.ibm.icu.text.MessageFormat result = propHolder.getMessageFormatICU(code, locale);
            if (result != null) {
                return result;
            }
        } else {
            for (String basename : this.getBasenameSet()) {
                List filenames = this.calculateAllFilenames(basename, locale);
                for (String filename : filenames) {
                    PropertiesHolder propHolder = this.getProperties(filename);
                    com.ibm.icu.text.MessageFormat result = propHolder.getMessageFormatICU(code, locale);
                    if (result == null) continue;
                    return result;
                }
            }
        }
        return null;
    }

    protected void mergePluginProperties(Locale locale, Properties mergedProps) {
    }

    protected PropertiesHolder getMergedProperties(Locale locale) {
        PropertiesHolder mergedHolder = (PropertiesHolder)((Object)this.cachedMergedProperties.get(locale));
        if (mergedHolder != null) {
            return mergedHolder;
        }
        Properties mergedProps = this.newProperties();
        this.mergePluginProperties(locale, mergedProps);
        long latestTimestamp = -1L;
        String[] basenames = StringUtils.toStringArray((Collection)this.getBasenameSet());
        for (int i = basenames.length - 1; i >= 0; --i) {
            List filenames = this.calculateAllFilenames(basenames[i], locale);
            for (int j = filenames.size() - 1; j >= 0; --j) {
                String filename = (String)filenames.get(j);
                PropertiesHolder propHolder = this.getProperties(filename);
                if (propHolder.getProperties() == null) continue;
                mergedProps.putAll((Map<?, ?>)propHolder.getProperties());
                if (propHolder.getFileTimestamp() <= latestTimestamp) continue;
                latestTimestamp = propHolder.getFileTimestamp();
            }
        }
        mergedHolder = new PropertiesHolder(mergedProps, latestTimestamp);
        PropertiesHolder existing = this.cachedMergedProperties.putIfAbsent(locale, mergedHolder);
        if (existing != null) {
            mergedHolder = existing;
        }
        return mergedHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertiesHolder getProperties(String filename) {
        PropertiesHolder existingHolder;
        PropertiesHolder propHolder = (PropertiesHolder)((Object)this.cachedProperties.get(filename));
        long originalTimestamp = -2L;
        if (propHolder != null) {
            originalTimestamp = propHolder.getRefreshTimestamp();
            if (originalTimestamp == -1L || originalTimestamp > System.currentTimeMillis() - this.getCacheMillis()) {
                return propHolder;
            }
        } else {
            propHolder = new PropertiesHolder();
            existingHolder = this.cachedProperties.putIfAbsent(filename, propHolder);
            if (existingHolder != null) {
                propHolder = existingHolder;
            }
        }
        if (this.concurrentRefresh && propHolder.getRefreshTimestamp() >= 0L) {
            if (!propHolder.refreshLock.tryLock()) {
                return propHolder;
            }
        } else {
            propHolder.refreshLock.lock();
        }
        try {
            existingHolder = (PropertiesHolder)((Object)this.cachedProperties.get(filename));
            if (existingHolder != null && existingHolder.getRefreshTimestamp() > originalTimestamp) {
                PropertiesHolder propertiesHolder = existingHolder;
                return propertiesHolder;
            }
            PropertiesHolder propertiesHolder = this.refreshPropertiesICU(filename, propHolder);
            return propertiesHolder;
        }
        finally {
            propHolder.refreshLock.unlock();
        }
    }

    public PropertiesHolder refreshPropertiesICU(String filename, @Nullable PropertiesHolder propHolder) {
        long refreshTimestamp = this.getCacheMillis() < 0L ? -1L : System.currentTimeMillis();
        Resource resource = this.resourceLoader.getResource(filename + PROPERTIES_SUFFIX);
        if (!resource.exists()) {
            resource = this.resourceLoader.getResource(filename + XML_SUFFIX);
        }
        if (resource.exists()) {
            long fileTimestamp = -1L;
            if (this.getCacheMillis() >= 0L) {
                try {
                    fileTimestamp = resource.lastModified();
                    if (propHolder != null && propHolder.getFileTimestamp() == fileTimestamp) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Re-caching properties for filename [" + filename + "] - file hasn't been modified"));
                        }
                        propHolder.setRefreshTimestamp(refreshTimestamp);
                        return propHolder;
                    }
                }
                catch (IOException ex) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)(resource + " could not be resolved in the file system - assuming that it hasn't changed"), (Throwable)ex);
                    }
                    fileTimestamp = -1L;
                }
            }
            try {
                Properties props = this.loadProperties(resource, filename);
                propHolder = new PropertiesHolder(props, fileTimestamp);
            }
            catch (IOException ex) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)("Could not parse properties file [" + resource.getFilename() + "]"), (Throwable)ex);
                }
                propHolder = new PropertiesHolder();
            }
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No properties file found for [" + filename + "] - neither plain properties nor XML"));
            }
            propHolder = new PropertiesHolder();
        }
        propHolder.setRefreshTimestamp(refreshTimestamp);
        this.cachedProperties.put(filename, propHolder);
        return propHolder;
    }

    public void clearCache() {
        this.logger.debug((Object)"Clearing entire resource bundle cache");
        this.cachedProperties.clear();
        this.cachedMergedProperties.clear();
    }

    protected com.ibm.icu.text.MessageFormat createMessageFormatICU(String msg, Locale locale) {
        return new com.ibm.icu.text.MessageFormat(msg, locale);
    }

    protected MessageFormat createMessageFormat(String msg, Locale locale) {
        throw new UnsupportedOperationException("Use createMessageFormatICU for ibm.icu");
    }

    protected class PropertiesHolder
    extends ReloadableResourceBundleMessageSource.PropertiesHolder {
        private final ReentrantLock refreshLock;
        private final ConcurrentMap<String, Map<Locale, com.ibm.icu.text.MessageFormat>> cachedMessageFormats;

        public PropertiesHolder() {
            super((ReloadableResourceBundleMessageSource)ICUBundleMessageSource.this);
            this.refreshLock = new ReentrantLock();
            this.cachedMessageFormats = new ConcurrentHashMap<String, Map<Locale, com.ibm.icu.text.MessageFormat>>();
        }

        public PropertiesHolder(Properties properties, long fileTimestamp) {
            super((ReloadableResourceBundleMessageSource)ICUBundleMessageSource.this, properties, fileTimestamp);
            this.refreshLock = new ReentrantLock();
            this.cachedMessageFormats = new ConcurrentHashMap<String, Map<Locale, com.ibm.icu.text.MessageFormat>>();
        }

        @Nullable
        public MessageFormat getMessageFormat(String code, Locale locale) {
            throw new UnsupportedOperationException("Use getMessageFormatICU for ibm.icu");
        }

        @Nullable
        public com.ibm.icu.text.MessageFormat getMessageFormatICU(String code, Locale locale) {
            com.ibm.icu.text.MessageFormat result;
            if (this.getProperties() == null) {
                return null;
            }
            Map<Locale, Object> localeMap = (ConcurrentHashMap<Locale, com.ibm.icu.text.MessageFormat>)this.cachedMessageFormats.get(code);
            if (localeMap != null && (result = (com.ibm.icu.text.MessageFormat)localeMap.get(locale)) != null) {
                return result;
            }
            String msg = this.getProperties().getProperty(code);
            if (msg != null) {
                Map existing;
                if (localeMap == null && (existing = (Map)this.cachedMessageFormats.putIfAbsent(code, localeMap = new ConcurrentHashMap<Locale, com.ibm.icu.text.MessageFormat>())) != null) {
                    localeMap = existing;
                }
                com.ibm.icu.text.MessageFormat result2 = ICUBundleMessageSource.this.createMessageFormatICU(msg, locale);
                localeMap.put(locale, result2);
                return result2;
            }
            return null;
        }
    }
}

