/*
 * Decompiled with CFR 0.152.
 */
package yakworks.spring;

import groovy.lang.Closure;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.PostConstruct;
import org.apache.groovy.nio.extensions.NioExtensions;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.trait.Traits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.lang.NonNull;
import yakworks.commons.io.PathTools;
import yakworks.commons.lang.Validate;
import yakworks.spring.SpringEnvironment;

public class AppResourceLoader
implements ResourceLoader,
SpringEnvironment,
GroovyObject,
SpringEnvironment.Trait.FieldHelper {
    @Autowired
    private ResourceLoader resourceLoader;
    private String resourcesConfigRootKey;
    private Path rootPath;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private Environment yakworks_spring_SpringEnvironment__environment;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public AppResourceLoader() {
        MetaClass metaClass;
        String string;
        this.resourcesConfigRootKey = string = "app.resources";
        this.metaClass = metaClass = this.$getStaticMetaClass();
        SpringEnvironment.Trait.Helper.$init$(this);
    }

    @PostConstruct
    public void init() {
        String rootLoc = ShortTypeHandling.castToString((Object)this.getEnvironment().getProperty(this.buildResourceKey("rootLocation"), String.class));
        if (DefaultTypeTransformation.booleanUnbox((Object)rootLoc)) {
            Path path;
            this.validatePath(rootLoc, "rootLocation");
            this.rootPath = path = Paths.get(rootLoc, new String[0]);
            if (Files.notExists(this.rootPath, new LinkOption[0])) {
                Files.createDirectories(this.rootPath, new FileAttribute[0]);
            }
        }
    }

    public String validatePath(String dir, String pathKey) {
        boolean valid = false;
        if (dir.startsWith("null/") || dir.startsWith("[:]")) {
            boolean bl;
            valid = bl = false;
        } else if (ScriptBytecodeAdapter.matchRegex((Object)dir, (Object)"^\\.?/?\\.?[a-zA-Z0-9].*")) {
            boolean bl;
            valid = bl = true;
        }
        if (!valid) {
            String message = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{pathKey, dir}, new String[]{"AppResourceLoader Problem ", " = ", " is not a valid path"}));
            throw (Throwable)new IllegalArgumentException(message);
        }
        return dir;
    }

    public Resource getResource(String location) {
        Object v0;
        String urlToUse = location;
        if (!location.startsWith("/") && !location.startsWith("file:")) {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{this.rootPath.resolve(location)}, new String[]{"file:", "/"});
            urlToUse = ShortTypeHandling.castToString((Object)gStringImpl);
        }
        if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{urlToUse}, new String[]{"appResourceLoader.getResource with ", ""})));
            v0 = null;
        } else {
            v0 = null;
        }
        return this.resourceLoader.getResource(urlToUse);
    }

    public Resource getResource(String configKey, String location) {
        Path path = this.getPath(configKey);
        Path locationPath = path.resolve(location);
        return this.resourceLoader.getResource(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{locationPath}, new String[]{"file:", "/"})));
    }

    public Resource getResource(Path pathLoc) {
        return this.getResource(pathLoc.toString());
    }

    public ClassLoader getClassLoader() {
        return this.resourceLoader.getClassLoader();
    }

    public Path createTempFile(String originalFileName, Object data) {
        Reference data2 = new Reference(data);
        String baseName = PathTools.getBaseName((String)originalFileName);
        if (baseName.length() < 3) {
            String string;
            baseName = string = StringGroovyMethods.plus((String)baseName, (CharSequence)"tmp");
        }
        String extension = PathTools.getExtension((String)originalFileName);
        String string = DefaultTypeTransformation.booleanUnbox((Object)extension) ? new GStringImpl(new Object[]{extension}, new String[]{".", ""}) : "";
        extension = ShortTypeHandling.castToString((Object)string);
        Path tmpDir = this.getTempDirectory();
        Path tmpFilePath = Files.createTempFile(tmpDir, baseName, extension, new FileAttribute[0]);
        if (DefaultTypeTransformation.booleanUnbox((Object)data2.get())) {
            if (data2.get() instanceof String) {
                NioExtensions.write((Path)tmpFilePath, (String)ShortTypeHandling.castToString((Object)data2.get()));
            } else if (data2.get() instanceof byte[]) {
                NioExtensions.setBytes((Path)tmpFilePath, (byte[])((byte[])ScriptBytecodeAdapter.castToType((Object)data2.get(), byte[].class)));
            } else if (data2.get() instanceof ByteArrayOutputStream) {
                public final class _createTempFile_closure1
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference data;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _createTempFile_closure1(Object _outerInstance, Object _thisObject, Reference data) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.data = reference = data;
                    }

                    public Object doCall(Object it) {
                        ((ByteArrayOutputStream)ScriptBytecodeAdapter.asType((Object)this.data.get(), ByteArrayOutputStream.class)).writeTo((OutputStream)ScriptBytecodeAdapter.castToType((Object)it, OutputStream.class));
                        return null;
                    }

                    @Generated
                    public Object getData() {
                        return this.data.get();
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _createTempFile_closure1.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                NioExtensions.withOutputStream((Path)tmpFilePath, (Closure)new _createTempFile_closure1(this, this, data2));
            }
        }
        return tmpFilePath;
    }

    public static void deleteIfExists(Path ... paths) {
        Path path2 = null;
        Path[] pathArray = paths;
        if (paths != null) {
            for (Path path2 : pathArray) {
                Files.deleteIfExists(path2);
            }
        }
    }

    public Path getTempDirectory() {
        Path tempPath = null;
        String _tempDir = this.getProp("tempDir");
        if (DefaultTypeTransformation.booleanUnbox((Object)_tempDir)) {
            Path path;
            this.validatePath(_tempDir, "tempDir");
            tempPath = path = Paths.get(_tempDir, new String[0]);
            if (_tempDir.startsWith("./")) {
                Path path2;
                tempPath = path2 = tempPath.toAbsolutePath().normalize();
            }
            if (!tempPath.isAbsolute()) {
                Path path3;
                tempPath = path3 = this.rootPath.resolve(_tempDir);
            }
            if (Files.notExists(tempPath, new LinkOption[0])) {
                Files.createDirectories(tempPath, new FileAttribute[0]);
            }
        } else {
            Path path;
            tempPath = path = Files.createTempDirectory("appResources", new FileAttribute[0]);
        }
        return tempPath;
    }

    @NonNull
    public Path getRootPath() {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Path path = this.rootPath;
            valueRecorder.record((Object)path, 13);
            if (DefaultTypeTransformation.booleanUnbox((Object)path)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert this.rootPath", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        return this.rootPath;
    }

    public Path getPath(String key, boolean create) {
        String dir = this.getProp(key);
        if (!DefaultTypeTransformation.booleanUnbox((Object)dir)) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{key}, new String[]{"app resource key '", "' is not defined or returns an empty value."})));
        }
        return this.checkPath(Paths.get(dir, new String[0]), create);
    }

    public Path checkPath(Path directory, boolean create) {
        Path dirPath = directory;
        if (!dirPath.isAbsolute()) {
            Path path;
            dirPath = path = this.rootPath.resolve(dirPath);
        }
        if (create) {
            PathTools.createDirectories((Path)dirPath);
        }
        return dirPath;
    }

    public Path checkPath(String directory) {
        return this.checkPath(Paths.get(directory, new String[0]));
    }

    public boolean deleteDirectory(String key) {
        return PathTools.deleteDirectory((Path)this.getPath(key));
    }

    public Path getScripts() {
        String scriptsDir = this.getProp("scripts.location", "scripts");
        return this.checkPath(Paths.get(scriptsDir, new String[0]));
    }

    public Path getRelativePath(Path file, String locationKey) {
        Path rootPath = this.getPath(locationKey);
        Path relativePath = rootPath.relativize(file);
        return relativePath;
    }

    public String getProp(String subKey, String defaultValue) {
        return ShortTypeHandling.castToString((Object)this.getConfigProperty(subKey, String.class, defaultValue));
    }

    public String buildResourceKey(String subKey) {
        Validate.notEmpty((Object)subKey);
        return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)this.resourcesConfigRootKey, (CharSequence)"."), (CharSequence)subKey);
    }

    public <T> T getConfigProperty(String subKey, Class<T> targetType, T defaultValue) {
        String fullKey = this.buildResourceKey(subKey);
        return (T)(DefaultTypeTransformation.booleanUnbox(defaultValue) ? this.getEnvironment().getProperty(fullKey, targetType, defaultValue) : this.getEnvironment().getProperty(fullKey, targetType));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AppResourceLoader.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Override
    @Generated
    @Traits.TraitBridge(traitClass=SpringEnvironment.class, desc="()Lorg/springframework/core/env/Environment;")
    public Environment getEnvironment() {
        return SpringEnvironment.Trait.Helper.getEnvironment(this);
    }

    @Generated
    public /* synthetic */ Environment yakworks_spring_SpringEnvironmenttrait$super$getEnvironment() {
        if (this instanceof GeneratedGroovyProxy) {
            return (Environment)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getEnvironment", (Object)new Object[0]), Environment.class);
        }
        return (Environment)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getEnvironment"), Environment.class);
    }

    @Override
    @Traits.TraitBridge(traitClass=SpringEnvironment.class, desc="(Lorg/springframework/core/env/Environment;)V")
    public void setEnvironment(Environment env) {
        SpringEnvironment.Trait.Helper.setEnvironment(this, env);
    }

    @Generated
    public /* synthetic */ void yakworks_spring_SpringEnvironmenttrait$super$setEnvironment(Environment env) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setEnvironment", (Object)new Object[]{env});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"setEnvironment", (Object[])new Object[]{env});
        }
    }

    @Override
    @Traits.TraitBridge(traitClass=SpringEnvironment.class, desc="()Lorg/springframework/core/env/Environment;")
    public Environment getConfig() {
        return SpringEnvironment.Trait.Helper.getConfig(this);
    }

    @Generated
    public /* synthetic */ Environment yakworks_spring_SpringEnvironmenttrait$super$getConfig() {
        if (this instanceof GeneratedGroovyProxy) {
            return (Environment)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getConfig", (Object)new Object[0]), Environment.class);
        }
        return (Environment)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getConfig"), Environment.class);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"yakworks.spring.AppResourceLoader");
        SpringEnvironment.Trait.Helper.$static$init$(AppResourceLoader.class);
    }

    @Override
    @Generated
    public /* synthetic */ Environment yakworks_spring_SpringEnvironment__environment$get() {
        return this.yakworks_spring_SpringEnvironment__environment;
    }

    @Override
    @Generated
    public /* synthetic */ Environment yakworks_spring_SpringEnvironment__environment$set(Environment val) {
        Environment environment;
        this.yakworks_spring_SpringEnvironment__environment = environment = val;
        return environment;
    }

    @Generated
    public String validatePath(String dir) {
        CallSite[] callSiteArray = AppResourceLoader.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.validatePath(dir, "?");
        }
        return this.validatePath(dir, "?");
    }

    @Generated
    public Path getPath(String key) {
        CallSite[] callSiteArray = AppResourceLoader.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.getPath(key, false);
        }
        return this.getPath(key, false);
    }

    @Generated
    public Path checkPath(Path directory) {
        CallSite[] callSiteArray = AppResourceLoader.$getCallSiteArray();
        return this.checkPath(directory, false);
    }

    @Generated
    public String getProp(String subKey) {
        CallSite[] callSiteArray = AppResourceLoader.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.getProp(subKey, null);
        }
        return this.getProp(subKey, null);
    }

    @Generated
    public <T> T getConfigProperty(String subKey, Class<T> targetType) {
        CallSite[] callSiteArray = AppResourceLoader.$getCallSiteArray();
        return this.getConfigProperty(subKey, targetType, null);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @Generated
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Generated
    public String getResourcesConfigRootKey() {
        return this.resourcesConfigRootKey;
    }

    @Generated
    public void setResourcesConfigRootKey(String string) {
        this.resourcesConfigRootKey = string;
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[]{};
        return new CallSiteArray(AppResourceLoader.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = AppResourceLoader.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

